/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.ExifIFD;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileExifIFD;

public final class TiffProfileExif
extends TiffProfile {
    private String[] profileText = new String[]{"Exif 2.0", "Exif 2.1 (JEIDA-49-1998)", "Exif 2.2 (JEITA CP-3451)"};
    private TiffProfileExifIFD _exifIFDProfile = new TiffProfileExifIFD();

    public boolean satisfiesThisProfile(IFD iFD) {
        Object object;
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null) {
            return false;
        }
        if (this.satisfiesCompression(tiffIFD, 1)) {
            if (nisoImageMetadata.getImageWidth() == -1L || nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null) {
                return false;
            }
            if (nisoImageMetadata.getSamplesPerPixel() != 3) {
                return false;
            }
            object = nisoImageMetadata.getBitsPerSample();
            if (object == null || ((Object)object).length < 3 || object[0] != 8 || object[1] != 8 || object[2] != 8) {
                return false;
            }
            int n = nisoImageMetadata.getColorSpace();
            if (n != 2 && n != 6) {
                return false;
            }
            if (n == 6 && (nisoImageMetadata.getYCbCrSubSampling() == null || nisoImageMetadata.getYCbCrPositioning() == -1)) {
                return false;
            }
        } else if (tiffIFD.getJpegInterchangeFormat() == -1L) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (tiffIFD.isFirst()) {
            object = tiffIFD.getTheExifIFD();
            if (object == null) {
                return false;
            }
            if (!this._exifIFDProfile.satisfiesThisProfile((IFD)object)) {
                return false;
            }
            String string = ((ExifIFD)object).getExifVersion();
            int n = 0;
            if (string.equals("0220")) {
                n = 2;
            } else if (string.equals("0210")) {
                n = 1;
            } else if (string.equals("0200")) {
                n = 0;
            }
            this._profileText = this.profileText[n];
        }
        return true;
    }
}

