/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.file;

import java.io.*;
import java.util.ArrayList;

import uk.gov.nationalarchives.droid.core.Droid4LegacyDroid;
import uk.gov.nationalarchives.droid.core.interfaces.*;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import ch.docuteam.docutools.out.Logger;
import ch.docuteam.docutools.util.EnvironmentVariable;

/**
 * This is an abstract class for getting file format information using droid.
 * <br>
 * The droid subsystem requires the signature file "DROID_SignatureFile_V52.xml" to be in the folder "config" in the DOCUTOOLS_HOME folder.
 * @author denis
 *
 */
public abstract class MetadataProviderDROID
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	static private final String			DROIDConfigFile = "config/DROID_SignatureFile_V52.xml";

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static private DroidCore			Droid = null;
	
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	static
	{
		Logger.debug("Initializing droid...");

		Droid = new Droid4LegacyDroid();
		Droid.setSignatureFile(EnvironmentVariable.get("DOCUTOOLS_HOME", ".") + "/" + DROIDConfigFile);
		((Droid4LegacyDroid)Droid).init();

		Logger.debug(Droid == null? "...NOK!": "...done");
	}

	//	========	Static Public			=======================================================

	static public IdentificationResult getIdentificationResult(String fileName)
	{
		if (Droid == null)						return null;
		if (!new File(fileName).exists())		return null;

		// Set up file metadata.  May not be necessary if you only want the file identifications,
		// in which case, pass in null, null to the FileSystemIdentificationRequest constructor in the following section.
		File file = new File(fileName);
		RequestMetaData metadata = new RequestMetaData(file.length(), file.lastModified(), file.getName());
		RequestIdentifier id = new RequestIdentifier(file.toURI());
		//	Id.setParentId(1L); // obviously, should be id of parent object if processing file system hierarchies.

		// Open the file for reading (uses caching of small blocks, instead of reading the entire file).
		IdentificationRequest request = new FileSystemIdentificationRequest(metadata, id);
		FileInputStream fis = null;
		try
		{
			fis = new FileInputStream(file);
			request.open(fis);

			// Identify the file:
			ArrayList<IdentificationResult> resultList = new ArrayList<IdentificationResult>(Droid.submit(request).getResults());
			if (resultList.isEmpty())		return null;

			return resultList.get(resultList.size() - 1);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			return null;
		}
		finally
		{
			try
			{
				request.close();
				if (fis != null)		fis.close();
			}
			catch(IOException ex){};
		}
	}
	

	//	The following are convenience methods (shortcuts for retrieving specific metadata directly):
	
	static public String getMimeType(String fileName)
	{
		IdentificationResult result = getIdentificationResult(fileName);
		if (result == null)			return "";
		
		return result.getMimeType();
	}
	
	static public String getFileFormatName(String fileName)
	{
		IdentificationResult result = getIdentificationResult(fileName);
		if (result == null)			return "";
		
		return result.getName();
	}
	
	static public String getFileFormatVersion(String fileName)
	{
		return "";
	}
	
	static public String getFileFormatPUID(String fileName)
	{
		IdentificationResult result = getIdentificationResult(fileName);
		if (result == null)			return "";
		
		return result.getPuid();
	}

	//	========	Static Private			=======================================================

}
