/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.out;
/**
 * 
 */


import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;


/**
 * @author denis
 *
 */
public class SystemOutRedirector extends FilterOutputStream
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static private PrintStream				Out;
	static private PrintStream				Err;
	
	//	========	Instance Public			=======================================================

	//	========	Instance Private		=======================================================

	private SystemOutRedirectionTarget		target;
	
	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		//	If the SystemOutRedirectionTarget just implements the interface SystemOutRedirectionTarget, use this:
//		SystemOutRedirector.install(new SystemOutRedirectionTargetExample());

		//	If the SystemOutRedirectionTarget is a subclass of SystemOutRedirectionTargetAbstract, use this:
		new SystemOutRedirectionTargetExample().install();

		System.out.println("Yahoo");
		System.out.println("Yeah!");
		System.out.println("Yipii!!!");
		
		try
		{
			throw new RuntimeException("Yeah!!!");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}


		SystemOutRedirectionTargetExample.uninstall();
	
		System.out.println("Yahoo");
		System.out.println("Yeah!");
		System.out.println("Yipii!!!");
		
		try
		{
			throw new RuntimeException("Yeah!!!");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}
	}

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Constructors Public		=======================================================

	//	========	Constructors Private	=======================================================

	private SystemOutRedirector(SystemOutRedirectionTarget target)
	{
		super(new ByteArrayOutputStream());
		this.target = target;

		Out = System.out;
		Err = System.err;
		
		System.setOut(new PrintStream(this));
		System.setErr(new PrintStream(this));
	}

	//	========	Static Public			=======================================================

	static public void install(SystemOutRedirectionTarget target)
	{
		new SystemOutRedirector(target);
	}
	

	static public void unInstall()
	{
		System.setOut(Out);
		System.setErr(Err);
	}
	
	//	========	Static Private			=======================================================

	//	========	Instance Public			=======================================================

	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Interface			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------
	
	/* Override Ancestor method */
	@Override
	public void write(byte b[])
	{
		String str = new String(b);
		this.write(str);
	}

	/* Override Ancestor method */
	@Override
	public void write(byte b[], int off, int len)
	{
		String str = new String(b, off, len);
		this.write(str);
	}
 
	/* Override Ancestor method */
	@Override
	public void write(int b)
	{
		String str = new String(new char[] { (char) b});
		this.write(str);
	}
	 
	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	========	Instance Private		=======================================================

	//	--------		Initializing		-------------------------------------------------------
	//	--------		Accessing			-------------------------------------------------------
	//	--------		Inquiring			-------------------------------------------------------
	//	--------		Business Ops		-------------------------------------------------------

	private void write(String message)
	{
		this.target.write(message);
	}

	//	--------		Persistence			-------------------------------------------------------
	//	--------		Support				-------------------------------------------------------
	//	--------		Utilities			-------------------------------------------------------
	//	--------		Debugging			-------------------------------------------------------
	//	---------		Temporary			-------------------------------------------------------

	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

	static private class SystemOutRedirectionTargetExample extends SystemOutRedirectionTargetAbstract implements SystemOutRedirectionTarget
	{
		static
		{
			LogFile.initializeAppend("temp/LogFile.txt");
		}

		/* (non-Javadoc)
		 * @see doculib.util.SystemOutRedirectionTarget#write(java.lang.String)
		 */
		@Override
		public void write(String string)
		{
			try
			{
				LogFile.write(string);
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
	}
	
}
