/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.util;

public abstract class OperatingSystem
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	static private String			OSName;
	static private String			OSVersion;
	static private String			UserName;

	static private Boolean			IsWindows = false;
	static private Boolean			IsMacOSX = false;
	static private Boolean			IsLinux = false;
	
	//	========	Static Private			=======================================================

	//	===========================================================================================
	//	========	Main					=======================================================
	//	===========================================================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Static Public			=======================================================

	static public String osName()
	{
		initializeIfNecessary();

		return OSName;
	}
	
	static public String osVersion()
	{
		initializeIfNecessary();

		return OSVersion;
	}
	
	static public String userName()
	{
		initializeIfNecessary();

		return UserName;
	}
	

	static public boolean isWindows()
	{
		initializeIfNecessary();

		return IsWindows;
	}
	
	static public boolean isMacOSX()
	{
		initializeIfNecessary();

		return IsMacOSX;
	}
	
	static public boolean isLinux()
	{
		initializeIfNecessary();

		return IsLinux;
	}
	
	
	static public void beep(Integer times)
	{
		beep(times, 200);
	}
	
	static public void beep(Integer times, Integer mSexGap)
	{
		try
		{
			for (int i = 0; i < times; i++)
			{
				beep();
				Thread.sleep(mSexGap);
			}
		}
		catch (InterruptedException ex){}
	}
	
	static public void beep()
	{
		java.awt.Toolkit.getDefaultToolkit().beep();
	}
	
	//	========	Static Private			=======================================================

	static private void initializeIfNecessary()
	{
		if (OSName == null)		initialize();
	}

	
	static private void initialize()
	{
		OSName = System.getProperty("os.name");
		OSVersion = System.getProperty("os.version");
		UserName = System.getProperty("user.name");

		String osNameL = OSName.toLowerCase();
		if (osNameL.contains("windows"))		IsWindows = true;
		else if (osNameL.contains("os x"))		IsMacOSX = true;
		else if (osNameL.contains("linux"))		IsLinux = true;
	}
	
	//	===========================================================================================
	//	========	Inner Classes			=======================================================
	//	===========================================================================================

}
