/**
 * 
 */
package fedora.services.sipcreator.tasks;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import ch.docuteam.docutools.out.Logger;
import ch.docuteam.docutools.translations.I18N;

import fedora.services.sipcreator.Constants;
import fedora.services.sipcreator.SIPCreator;

/**
 * @author nef
 * 
 */
public class SubmissionAgreementTask extends JPanel implements Constants {

	private SIPCreator creator;

	private String saLabel;
	private String saType;
	private String userFullname;
	private String userNote = "";

	private JLabel lbUser;
	private JTextField tfUser;
	private JLabel lbPerson;
	private JComboBox cbPerson;
	private JLabel lbOrganisation;
	private JTextField tfOrganisation;
	private JLabel lbSA;
	private JComboBox cbSA;
	private JLabel lbNote;
	private JTextArea taNote;

	/**
	 * 
	 */
	public SubmissionAgreementTask(SIPCreator newCreator) {
		creator = newCreator;
		I18N.initialize(creator.getProperties().getProperty("sipcreator.language"), "ch.docuteam.sipcreator.translations.Translations");
		setLayout(new BorderLayout());
		add(createTopPanel(), BorderLayout.NORTH);
	}

	private JPanel createTopPanel() {
		lbUser = new JLabel(I18N.translate("LoggedInUser") + ":");
		tfUser = new JTextField(System.getProperty("user.name"));
		tfUser.setEditable(false);
		lbPerson = new JLabel(I18N.translate("Person") + ":");
		cbPerson = new JComboBox();
		cbPerson.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cbPersonActionPerformed(evt);
			}
		});
		cbPerson.setEnabled(creator.getProperties().getProperty("sipcreator.users.final").matches("0"));
		lbOrganisation = new JLabel(I18N.translate("Organisation") + ":");
		tfOrganisation = new JTextField();
		tfOrganisation.setEditable(false);
		lbSA = new JLabel(I18N.translate("SubmissionAgreement") + ":");
		cbSA = new JComboBox();
		cbSA.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cbAgreementActionPerformed(evt);
			}
		});
		lbNote = new JLabel(I18N.translate("Note") + ":");
		taNote = new JTextArea(3, 30);
		taNote.setBorder(BorderFactory.createLineBorder(Color.black));
		taNote.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				userNote = taNote.getText();
			}

			public void insertUpdate(DocumentEvent e) {
				userNote = taNote.getText();
			}

			public void removeUpdate(DocumentEvent e) {
				userNote = taNote.getText();
			}
		});
		JPanel top = new JPanel(new GridLayout(5, 2, 5, 5));
		top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		top.add(lbUser);
		top.add(tfUser);
		top.add(lbPerson);
		top.add(cbPerson);
		top.add(lbOrganisation);
		top.add(tfOrganisation);
		top.add(lbSA);
		top.add(cbSA);
		top.add(lbNote);
		top.add(taNote);

		connectUserInformation();

		return top;
	}

	protected void cbPersonActionPerformed(ActionEvent evt) {
		userFullname = cbPerson.getSelectedItem().toString();
		Document personal = readConfigFile(creator.getProperties().getProperty("sipcreator.default.personal"));
		if (personal == null)	return;
		
		Node person = personal.selectSingleNode("/producerlist/person/name[text()='" + cbPerson.getSelectedItem() + "']");
		tfOrganisation.setText(person.selectSingleNode("../dep").getText());
		cbSA.setModel(new DefaultComboBoxModel(getSubmAgreements(tfOrganisation.getText())));
		if (cbSA.getItemCount() > 0) {
			cbSA.setSelectedIndex(0);
		}
	}

	protected void cbAgreementActionPerformed(ActionEvent evt) {
		saType = cbSA.getSelectedItem().toString()
				.substring(cbSA.getSelectedItem().toString().lastIndexOf("(") + 1, cbSA.getSelectedItem().toString().length() - 1);
		saLabel = cbSA.getSelectedItem().toString().substring(0, cbSA.getSelectedItem().toString().indexOf("(") - 1);
	}

	@SuppressWarnings("unchecked")
	private String[] getSubmAgreements(String abteilung) {
		Logger.info("Getting agreements for '" + abteilung + "'");
		
		Document overview = readConfigFile(creator.getProperties().getProperty("sipcreator.default.overview"));
		if (overview == null)	return null;
		Logger.debug(overview.asXML());
		
		String draftFilter = "";
		if (creator.getProperties().getProperty("sipcreator.agreements.showdrafts").matches("0")) {
			draftFilter = "saStatus[text()='final']/../";
		}

		List<Node> sa = new ArrayList<Node>();
		List<Node> nodes = overview.selectNodes("/saoverview/sa/" + draftFilter + "dss/dssID");
		// If the <dep>-element of the personnel list contains the asterisk,
		// this person is allowed to do submissions for all agreements
		if (abteilung.contains("*") || abteilung.equals(creator.getProperties().getProperty("sipcreator.users.admingroup"))) {
			sa.addAll(nodes);
		} else {
			String abteilungen[] = abteilung.split("; ");
			for (int i = 0; i <= abteilungen.length - 1; i++) {
				// dom4j does not support XPath 2.0 which would include functions to do
				// case insensitive comparison. Therefore, the following code is doing
				// the string comparison in an own java loop.
				Iterator<Node> it = nodes.iterator();
				while (it.hasNext()) {
					Node node = it.next();
					if (node.getParent().getParent().elementText("saProducerShortname").toLowerCase().contains(abteilung.toLowerCase())) {
						sa.add(node);
					}
				}
			}
		}

		Logger.info("Result size: " + sa.size());
		String[] agreements = new String[sa.size()];
		for (int s = 0; s < sa.size(); s++) {
			Node n = (Node) sa.get(s);
			agreements[s] = String.valueOf(n.selectSingleNode("../../saTitle").getText()) + ": " + String.valueOf(n.selectSingleNode("../dssTitle").getText())
					+ " (" + String.valueOf(n.selectSingleNode("../../saID").getText() + "_" + n.getText()) + ")";
		}
		Logger.info("Result: " + Arrays.toString(agreements));
		return agreements;
	}

	private boolean contains(ComboBoxModel model, Object o) {
		int size = model.getSize();
		for (int i = 0; i < size; i++) {
			Object obj = model.getElementAt(i);
			if (obj.equals(o)) {
				return true;
			}
		}
		return false;
	}

	private void connectUserInformation() {
		Document overview = readConfigFile(creator.getProperties().getProperty("sipcreator.default.personal"));
		if (overview == null)	return;
		
		@SuppressWarnings("unchecked")
		List<Node> l = overview.selectNodes("/producerlist/person");
		cbPerson.setModel(new DefaultComboBoxModel());

		int i = 0;
		for (int s = 0; s < l.size(); s++) {
			Node n = (Node) l.get(s);
			String person = n.selectSingleNode("name").getText();
			if (!this.contains(cbPerson.getModel(), person)) {
				cbPerson.addItem(person);
			}
			String login = n.selectSingleNode("login").getText();
			if (login.equalsIgnoreCase(System.getProperty("user.name"))) {
				i = s;
			}
		}

		cbPerson.setSelectedIndex(i);
	}

	private Document readConfigFile(String configFile) {
		Document configXMLFile = null;
		try {
			configXMLFile = new SAXReader().read(new URL(this.creator.getCodeBase(), configFile));
		} catch (MalformedURLException e) {
			Logger.error("Could not load config file: " + configFile, e);
		} catch (DocumentException e) {
			Logger.error("Could not parse config file: " + configFile, e);
		}
		return configXMLFile;
	}

	/**
	 * @param saType
	 *            the saType to set
	 */
	public void setSaType(String saType) {
		for (int i = 0; i < cbSA.getItemCount(); i++) {
			String item = (String) cbSA.getItemAt(i);
			if (item.contains(saType)) {
				cbSA.setSelectedIndex(i);
			}
		}
	}

	/**
	 * @return the saType
	 */
	public String getSaType() {
		return saType;
	}

	/**
	 * @param saName
	 *            the saName to set
	 */
	public void setSaName(String saName) {
		for (int i = 0; i < cbPerson.getItemCount(); i++) {
			String item = (String) cbPerson.getItemAt(i);
			if (item.contains(saName)) {
				cbPerson.setSelectedIndex(i);
			}
		}
	}

	/**
	 * @return the saLabel
	 */
	public String getSaLabel() {
		return saLabel;
	}

	/**
	 * @return the userFullname
	 */
	public String getUserFullname() {
		return userFullname;
	}

	/**
	 * @return the userNote
	 */
	public String getUserNote() {
		return userNote;
	}

}
