/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.file;

import java.io.*;

import edu.harvard.hul.ois.jhove.Checksummer;

/**
 * This is an abstract class for calculating a file's checksum using the JHOVE Checksummer.
 * <br>
 * The JHOVE subsystem requires the configuration file "jhove.conf" to be in the folder "config" in the DOCUTOOLS_HOME folder.
 * @author denis
 * 
 */
public abstract class FileChecksumCalculator
{
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	/**
	 * Given a File name, this method will return the calculated MD5 checksum of that file.<br>
	 * @return The checksum of the given file.
	 */
	static public String getMD5(String filePath) throws FileNotFoundException, IOException
	{
		return getChecksummer(filePath).getMD5();
	}

	/**
	 * Given a File name, this method will return the calculated CRC32 checksum of that file.<br>
	 * @return The checksum of the given file.
	 */
	static public String getCRC32(String filePath) throws FileNotFoundException, IOException
	{
		return getChecksummer(filePath).getCRC32();
	}

	/**
	 * Given a File name, this method will return the calculated SHA1 checksum of that file.<br>
	 * @return The checksum of the given file.
	 */
	static public String getSHA1(String filePath) throws FileNotFoundException, IOException
	{
		return getChecksummer(filePath).getSHA1();
	}

	//	========	Static Private			=======================================================

	
	static private Checksummer getChecksummer(String filePath) throws FileNotFoundException, IOException
	{
		Checksummer checksummer = new Checksummer();
		DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(filePath)));

		try
		{
			while (true)
			{
				checksummer.update(dataInputStream.readUnsignedByte());
			}
		}
		catch (EOFException e)	{	/* This is the normal way for detecting we're done */	}
		finally
		{
			dataInputStream.close();
		}

		return checksummer;
	}

}
