/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.string;

/**
 * 
 */



/**
 * This abstract class returns a unique id (either a long or a String).
 * 
 * @author denis
 *
 */
public abstract class UniqueID
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Private			=======================================================

	/** The lastID is the last ID value generated, to avoid duplicate IDs. */
	private static String			lastID = "";

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Public			=======================================================

	/**
	 * This method generates a unique string to be used as an ID xml entries.
	 * This id is generated by using the current system time and prepending an
	 * underscore character. The underscore is prepended so as to conform to the
	 * XML requirements on the ID data type. This method is thread safe.<br>
	 * <br>
	 * @return A unique String to be used as an ID.
	 * 
	 * This method is @deprecated because the name is misleading: it implies a fix SEQUENCE of IDs. Use <code>get()</code> or <code>getXML()</code> instead.
	 */
	@Deprecated
	static public synchronized String getNextID()
	{
		return getXML();
	}


	/**
	 * This method generates a unique long to be used as an ID.
	 * This id is generated by using the current system time. This method is thread safe.<br>
	 * @return A unique long to be used as an ID.
	 */
	static public synchronized long get()
	{
		return new Long(getString()).longValue();
	}


	/**
	 * This method generates a unique string to be used as an ID for xml entries.
	 * This id is generated by using the current system time and prepending an
	 * underscore character. The underscore is prepended so as to conform to the
	 * METS requirements on the ID field. This method is thread safe. <br>
	 * @return A unique String to be used as an ID.
	 */
	static public synchronized String getXML()
	{
		return "_" + getString();
	}


	/**
	 * This method generates a unique string to be used as an ID.
	 * This id is generated by using the current system time. This method is thread safe.<br>
	 * @return A unique String to be used as an ID.
	 */
	static public synchronized String getString()
	{
		String newID;

		while ((newID = DateFormatter.getCurrentDateTimeString(DateFormatter.NumericalMSecs)).equals(lastID))
		{
			try { Thread.sleep(10); }
			catch (InterruptedException ex) {}
		}

		return lastID = newID;
	}
	
}

