/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.translations;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author denis
 *
 */
public abstract class I18N
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	static protected ResourceBundle			resources = null;
	
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================
	
	//	========	Static Initializer		=======================================================

	static public void initialize(String language, String translationBaseClassName)
	{
		resources = ResourceBundle.getBundle(translationBaseClassName, new Locale(language));
	}
	
	//	========	Static Public			=======================================================
	
	/**
	 * Return the translated word, or if something goes wrong, the word itself.
	 * Assume that the PropertyFile has already been initialized.
	 * 
	 * @deprecated Use method translate(String) instead.
	 */
	@Deprecated
	static public String get(String word)
	{
		return translate(word);
	}


	/**
	 * Return the translated word, or if something goes wrong, the word itself.
	 * Assume that the PropertyFile has already been initialized.
	 */
	static public String translate(String word)
	{
		if (resources == null)		throw new RuntimeException("I18N was not initialized");

		try
		{
			return resources.getString(word);
		}
		catch(Exception x)
		{
			return word;
		}
	}


	/**
	 * Return the translated word, or if something goes wrong, the word itself. Format any placeholder in the string using the object list.
	 * Assume that the PropertyFile has already been initialized.
	 */
	static public String translate(String word, Object... objects)
	{
		try
		{
			return String.format(translate(word), objects);
		}
		catch(Exception x)
		{
			return word;
		}
	}

	//	========	Static Private			=======================================================

}
