/**
 *	Copyright (C) 2011 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.docutools.util;

import ch.docuteam.docutools.out.Logger;

public abstract class EnvironmentVariable
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	static private final String			Home = ".";
	
	//	========	Static Public			=======================================================

	//	========	Static Private			=======================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	Static Public			=======================================================

	/**
	 * Return the value of the environment variable 'name', or null if undefined.
	 */
	static public String get(String name)
	{
		Logger.debug("Retrieving Environment Variable: " + name);

		String value = System.getenv(name);
		if (value == null)
		{
			Logger.warn("Undefined Environment Variable: " + name);
			return null;
		}
		
		Logger.debug("Returning value: " + value);
		return value;
	}


	/**
	 * Return the value of the environment variable 'name', or the 'ifUndefined' String if undefined.
	 */
	static public String get(String name, String ifUndefined)
	{
		Logger.debug("Retrieving Environment Variable: " + name + " with default value: " + ifUndefined);

		String value = System.getenv(name);
		if (value == null)		value = ifUndefined;
		
		Logger.debug("Returning value: " + value);
		return value;
	}


	/**
	 * Return the value of the environment variable 'name', or the home path "." if undefined.
	 */
	static public String getAsFolder(String name)
	{
		return get(name, Home);
	}
	
	//	========	Static Private			=======================================================

}
