/**
 * (c) Copyright  2008 Tessella Support Services plc.  
 * All rights reserved. 
 * <p/>
 * Project: 5890
 * DCS
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created By:     trir and owul
 * Created Date:   31 October 2008, 15:42
 */
package uk.gov.nationalarchives.droid.profile.GUI;

import com.jgoodies.plaf.plastic.PlasticLookAndFeel;
import com.jgoodies.plaf.plastic.theme.SkyBluer;
import uk.gov.nationalarchives.droid.profile.domain.ProfileVolume;
import uk.gov.nationalarchives.droid.profile.service.ProfilingManager;
import uk.gov.nationalarchives.droid.profile.service.ProfilingThread;
import org.apache.commons.io.FileUtils;
import uk.gov.nationalarchives.droid.AnalysisController;
import uk.gov.nationalarchives.droid.GUI.AboutDialog;
import uk.gov.nationalarchives.droid.stats.GUI.StatsResultDialog;
import uk.gov.nationalarchives.droid.xmlReader.PronomWebService;

import javax.help.HelpSet;
import javax.help.JHelp;
import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.*;
import uk.gov.nationalarchives.droid.GUI.FileIdentificationPane;
import uk.gov.nationalarchives.droid.GUI.FileSelection.FileSelectDialog;
import uk.gov.nationalarchives.droid.GUI.FileSelection.FileSelectReturnParameter;
import uk.gov.nationalarchives.droid.GUI.OptionsDialog;
import uk.gov.nationalarchives.droid.MessageDisplay;

/**
 * The primary view for profiling mode
 *
 * @author trir and owul
 */
public class ProfilingFrame extends javax.swing.JFrame implements WindowListener{

    private ProfilingManager manager;
    public static final String NEW_PROFILE = "New Profile";
    private List<String> currentProfileNames = new ArrayList<String>();
    private AnalysisController analysisController;
    private ReportForm reportForm = null;
    private Log log = LogFactory.getLog(this.getClass());
    private Image formIcon = null;
    private ImageIcon dialogIcon = null;
    private File dir = null;
    private FileSelectDialog DirectoryDialog = null;
    
    
    /**
     * Name of tool to be displayed in title bar *
     */
    private final String APPLICATION_NAME = "DROID (Digital Record Object Identification) - Profiling Mode";
    /**
     * Message to check if a signature file is available for download
     */
    private final String MSG_CHECK_SIG_FILE_UPDATE = "Would you like to check the web for a newer signature file?";
    /**
     * Message to download signature file
     */
    private final String MSG_DOWNLOAD_SIG_FILE = "A newer signature file is available.  Would you like to download it?";

    /**
     * Creates new form ProfilingFrame
     *
     * @param manager            the manager
     * @param analysisController the controller
     */
    public ProfilingFrame(ProfilingManager manager, AnalysisController analysisController) {
        this.manager = manager;
        this.analysisController = analysisController;
        try{
        this.currentProfileNames = manager.getAllProfileNames();
        }catch(Exception ex){
            log.error(ex.toString());
        }


        setCustomLookAndFeel();

        initComponents();
        this.setMinimumSize(new Dimension(927, 577));
        addWindowListener(this);
        //Set the icon for the window
        try {
            formIcon = javax.imageio.ImageIO.read(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/DROID16.gif"));
            dialogIcon = new ImageIcon(formIcon);
            setIconImage(formIcon);
        } catch (java.io.IOException e) {
            //Silently ignore exception
        }

        this.setTitle(APPLICATION_NAME);

        setFocusable(true);
        requestFocus();

        //Centre on screen
        setLocationRelativeTo(null);

        setTableColumns();

        //disable all reports menu item
        mnuItmViewAllRpts.setVisible(false);
        
        try {
            analysisController.readConfiguration();
            String theSigFileName = analysisController.getSignatureFileName();
            analysisController.readSigFile(theSigFileName, true, true);
            analysisController.checkSignatureFile();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.toString());
        }
        sigFileDownloadDue();
        DirectoryDialog = new FileSelectDialog(javax.swing.JOptionPane.getFrameForComponent(this), true,true);
        MessageDisplay.initialiseMainPane(this);
        hideErrorMessages();
        this.setResizable(true);
      
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        radioButtonGroup = new javax.swing.ButtonGroup();
        jPanel3 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        loadExistingRadio = new javax.swing.JRadioButton();
        if(currentProfileNames.isEmpty()){
            loadExistingRadio.setEnabled(false);
        }
        newProfileRadio = new javax.swing.JRadioButton();
        newProfileName = new javax.swing.JTextField();
        profileSelect = new JComboBox(currentProfileNames.toArray());
        invalidProfileNameWarning = new javax.swing.JLabel();
        invalidProfileNameWarning.setVisible(false);
        jPanel2 = new javax.swing.JPanel();
        volumeEntry = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        browseVolumeButton = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        invalidVolumeWarning = new javax.swing.JLabel();
        invalidVolumeWarning.setVisible(false);
        startProfilingButton = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        currentDatabaseLabel = new javax.swing.JLabel();
        databaseLocation = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        invalidDatabaseNameWarning = new javax.swing.JLabel();
        btnLoadDatabase = new javax.swing.JButton();
        btnCreateDatabase = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        volumeTable = new javax.swing.JTable();
        jMenuBar1 = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        standardDroidMenuItem = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        exitMenuItem = new javax.swing.JMenuItem();
        reportMenu = new javax.swing.JMenu();
        mnuItmViewProfileRpts = new javax.swing.JMenuItem();
        mnuItmViewDBRpts = new javax.swing.JMenuItem();
        mnuItmViewAllRpts = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        jMenuItemHelpContents = new javax.swing.JMenuItem();
        jMenuItemHelpAbout = new javax.swing.JMenuItem();
        radioButtonGroup.add(loadExistingRadio);
        radioButtonGroup.add(newProfileRadio);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(600, 495));
        setResizable(false);

        jPanel3.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Profiling Mode"), javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6)));

        jPanel1.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Profiling Options"), javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6)));
        jPanel1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jPanel1FocusGained(evt);
            }
        });

        loadExistingRadio.setText("Load Existing Profile");
        loadExistingRadio.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadExistingRadioPerformed(evt);
            }
        });

        newProfileRadio.setSelected(true);
        newProfileRadio.setText("Create New Profile");
        newProfileRadio.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newProfileRadioActionPerformed(evt);
            }
        });

        newProfileName.setToolTipText("Enter the name to give to your new profile");
        newProfileName.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                newProfileNameFocusLost(evt);
            }
        });
        newProfileName.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                newProfileNameKeyTyped(evt);
            }
        });

        profileSelect.setBackground(new java.awt.Color(241, 242, 242));
        profileSelect.setEnabled(false);
        profileSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                profileSelectActionPerformed(evt);
            }
        });

        invalidProfileNameWarning.setForeground(new java.awt.Color(255, 0, 0));
        invalidProfileNameWarning.setText("Invalid profile name!");
        invalidProfileNameWarning.setFocusable(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(loadExistingRadio)
                    .addComponent(newProfileRadio))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(invalidProfileNameWarning, javax.swing.GroupLayout.PREFERRED_SIZE, 272, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(profileSelect, javax.swing.GroupLayout.Alignment.LEADING, 0, 375, Short.MAX_VALUE)
                            .addComponent(newProfileName, javax.swing.GroupLayout.DEFAULT_SIZE, 375, Short.MAX_VALUE))
                        .addGap(390, 390, 390))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadExistingRadio)
                    .addComponent(profileSelect, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(newProfileRadio)
                    .addComponent(newProfileName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE)
                .addComponent(invalidProfileNameWarning)
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Add New File Location"), javax.swing.BorderFactory.createEmptyBorder(1, 6, 1, 6)));

        volumeEntry.setEnabled(false);

        jLabel1.setLabelFor(volumeEntry);
        jLabel1.setText("New File Location");
        jLabel1.setEnabled(false);

        browseVolumeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Open File or Folder 16 n g.gif"))); // NOI18N
        browseVolumeButton.setText("Browse");
        browseVolumeButton.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Open File or Folder 16 d g.gif"))); // NOI18N
        browseVolumeButton.setEnabled(false);
        browseVolumeButton.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        browseVolumeButton.setIconTextGap(6);
        browseVolumeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseVolumeButtonActionPerformed(evt);
            }
        });

        invalidVolumeWarning.setForeground(new java.awt.Color(255, 0, 0));
        invalidVolumeWarning.setText("Please enter a valid file location!");
        invalidVolumeWarning.setFocusable(false);

        startProfilingButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Forward or Next 16 n g.gif"))); // NOI18N
        startProfilingButton.setText("Identify Files ...");
        startProfilingButton.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Forward or Next 16 d g.gif"))); // NOI18N
        startProfilingButton.setEnabled(false);
        startProfilingButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                startProfilingButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGap(110, 110, 110)
                .addComponent(invalidVolumeWarning, javax.swing.GroupLayout.PREFERRED_SIZE, 292, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 343, Short.MAX_VALUE)
                .addComponent(startProfilingButton, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(invalidVolumeWarning, javax.swing.GroupLayout.DEFAULT_SIZE, 38, Short.MAX_VALUE)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(startProfilingButton))
        );

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(10, 10, 10)
                        .addComponent(volumeEntry, javax.swing.GroupLayout.DEFAULT_SIZE, 678, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(browseVolumeButton, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addComponent(jPanel6, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(volumeEntry, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseVolumeButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(86, 86, 86))
        );

        jPanel4.setBorder(javax.swing.BorderFactory.createEtchedBorder());

        currentDatabaseLabel.setText("Current Database");

        databaseLocation.setEditable(false);
        databaseLocation.setText(manager.getDatabaseLocation().getAbsolutePath());

        invalidDatabaseNameWarning.setForeground(new java.awt.Color(255, 0, 51));
        invalidDatabaseNameWarning.setText("Invalid Database name!");

        btnLoadDatabase.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/data_add-28.png"))); // NOI18N
        btnLoadDatabase.setText("Load Database");
        btnLoadDatabase.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        btnLoadDatabase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLoadDatabaseActionPerformed(evt);
            }
        });

        btnCreateDatabase.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/data_new-28.png"))); // NOI18N
        btnCreateDatabase.setText("Create Database");
        btnCreateDatabase.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        btnCreateDatabase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCreateDatabaseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup()
                .addGap(116, 116, 116)
                .addComponent(invalidDatabaseNameWarning, javax.swing.GroupLayout.PREFERRED_SIZE, 147, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 334, Short.MAX_VALUE)
                .addComponent(btnCreateDatabase)
                .addGap(18, 18, 18)
                .addComponent(btnLoadDatabase))
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(btnLoadDatabase, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(btnCreateDatabase, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(invalidDatabaseNameWarning))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(jPanel4Layout.createSequentialGroup()
                        .addComponent(currentDatabaseLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(databaseLocation, javax.swing.GroupLayout.DEFAULT_SIZE, 800, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(currentDatabaseLabel)
                    .addComponent(databaseLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, 36, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(60, 60, 60))
        );

        volumeTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "File System Location", "Profiling Started", "Profiling Completed", "Files", "Total Size"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        volumeTable.setToolTipText("Details concerning the selected profile's existing volumes.");
        jScrollPane1.setViewportView(volumeTable);

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 943, Short.MAX_VALUE)
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 164, Short.MAX_VALUE)
                .addContainerGap())
        );

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(12, 12, 12)
                .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jMenuBar1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                jMenuBar1FocusGained(evt);
            }
        });

        fileMenu.setMnemonic('F');
        fileMenu.setText("File");

        jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Cog 2 16 n g.gif"))); // NOI18N
        jMenuItem1.setMnemonic('O');
        jMenuItem1.setText("Options");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        fileMenu.add(jMenuItem1);

        standardDroidMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        standardDroidMenuItem.setMnemonic('S');
        standardDroidMenuItem.setText("Switch to Standard mode");
        standardDroidMenuItem.setToolTipText("Run DROID in the standard file classification mode.");
        standardDroidMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                standardDROIDModeSelected(evt);
            }
        });
        fileMenu.add(standardDroidMenuItem);
        fileMenu.add(jSeparator1);

        exitMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
        exitMenuItem.setMnemonic('X');
        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        jMenuBar1.add(fileMenu);

        reportMenu.setMnemonic('R');
        reportMenu.setText("Reports");

        mnuItmViewProfileRpts.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.CTRL_MASK));
        mnuItmViewProfileRpts.setMnemonic('P');
        mnuItmViewProfileRpts.setText("Profile Reports");
        mnuItmViewProfileRpts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuItmViewProfileRptsActionPerformed(evt);
            }
        });
        reportMenu.add(mnuItmViewProfileRpts);

        mnuItmViewDBRpts.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_T, java.awt.event.InputEvent.CTRL_MASK));
        mnuItmViewDBRpts.setMnemonic('T');
        mnuItmViewDBRpts.setText("Database Reports");
        mnuItmViewDBRpts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuItmViewDBRptsActionPerformed(evt);
            }
        });
        reportMenu.add(mnuItmViewDBRpts);

        mnuItmViewAllRpts.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.CTRL_MASK));
        mnuItmViewAllRpts.setMnemonic('L');
        mnuItmViewAllRpts.setText("All Reports");
        mnuItmViewAllRpts.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mnuItmViewAllRptsActionPerformed(evt);
            }
        });
        reportMenu.add(mnuItmViewAllRpts);

        jMenuBar1.add(reportMenu);

        helpMenu.setMnemonic('H');
        helpMenu.setText("Help");

        jMenuItemHelpContents.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_D, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemHelpContents.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Help Green 16 n g.gif"))); // NOI18N
        jMenuItemHelpContents.setMnemonic('D');
        jMenuItemHelpContents.setText("DROID Help");
        jMenuItemHelpContents.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Help Green 16 d g.gif"))); // NOI18N
        jMenuItemHelpContents.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Help Green 16 h g.gif"))); // NOI18N
        jMenuItemHelpContents.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemHelpContentsActionPerformed(evt);
            }
        });
        helpMenu.add(jMenuItemHelpContents);

        jMenuItemHelpAbout.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemHelpAbout.setIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Info Round Blue 16 n g.gif"))); // NOI18N
        jMenuItemHelpAbout.setMnemonic('A');
        jMenuItemHelpAbout.setText("About DROID");
        jMenuItemHelpAbout.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Info Round Blue 16 d g.gif"))); // NOI18N
        jMenuItemHelpAbout.setRolloverIcon(new javax.swing.ImageIcon(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Info Round Blue 16 h g.gif"))); // NOI18N
        jMenuItemHelpAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemHelpAboutActionPerformed(evt);
            }
        });
        helpMenu.add(jMenuItemHelpAbout);

        jMenuBar1.add(helpMenu);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Sets the look and feel for the form
     * Must be called before initComponents() in the constructor
     * <p/>
     * Jgoodies Plastic L&F with the Sky Bluer theme
     * (Changed from PlasticXP as this didn't work on Mac OS X)
     * All options as default except General options: Popup Shadow: On
     * REF: Email from A.Brown NPD/4305/CL/CSC/2005MAR21/12:25:13
     */
    private void setCustomLookAndFeel() {
        try {
            PlasticLookAndFeel lf = new PlasticLookAndFeel();
            PlasticLookAndFeel.setMyCurrentTheme(new SkyBluer());
            UIManager.setLookAndFeel(lf);
            UIManager.put("jgoodies.popupDropShadowEnabled", Boolean.TRUE);
        } catch (Exception e) {
            //Silently ignore exception
        }
    }

    public void windowClosing(WindowEvent e) {
        log.info("DROID is closing");
    }

   public void windowClosed(WindowEvent e) {
          
    }
    
   public void windowOpened(WindowEvent e) {
  
    }

    public void windowIconified(WindowEvent e) {
  
    }

    public void windowDeiconified(WindowEvent e) {
  
    }

    public void windowActivated(WindowEvent e) {
  
    }

    public void windowDeactivated(WindowEvent e) {
  
    }

    public void windowGainedFocus(WindowEvent e) {
  
    }

    public void windowLostFocus(WindowEvent e) {
  
    }

    public void windowStateChanged(WindowEvent e) {
  
    }    
 

    /**
     * This is used to verify whether or not a valid database path has been selected
     * @return A boolean value indicating whether or not a valid database path has been selected
     */
    private boolean isDatabaseSelected(boolean isCreateNewDB) {
        boolean selectionMade = false;
        int choice = JOptionPane.CLOSED_OPTION;


        if (isCreateNewDB) {
            dir = choosefile("Choose a location to create a new database", "Select a location to create a new database");

            if (dir == null) {
                selectionMade = false;
            } else {
                String DBname = (String) JOptionPane.showInputDialog(this, "Please enter the name of the Database you want to create", "Database name", JOptionPane.OK_OPTION, dialogIcon, null, " Database Name ");
                if(DBname == null || DBname.trim().equalsIgnoreCase("")){
                    DBname = "Database Name";
                }
                dir = new File(dir.getAbsolutePath().trim() + File.separator.trim() + DBname.trim());
                if (!dir.exists() || !dir.isDirectory()) {
                    selectionMade = true;
                } else if (dir.exists()) { //if directory already exists, check if user want to connect to an already existing DB
                    choice = JOptionPane.showConfirmDialog(this, "Database \"" + dir.getAbsolutePath() + "\" already EXISTS.\nDo you want to CONNECT to this existing database?", "Database Selection Option", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, dialogIcon);
                    if (choice == JOptionPane.YES_OPTION) {
                        selectionMade = true;
                    } else {
                        selectionMade = false;
                    }
                }
            }
        } else {
            dir = choosefile("Choose an existing database", "Select an existing database to connect to it");
            if (dir == null) {
                selectionMade = false;
            } else if (dir.exists() && dir.isDirectory()) {
                selectionMade = true;
            } else if (!dir.exists() || !dir.isDirectory()) { //if directory does not exist, check if user wants to create a new DB

                String message = "";
                if (!dir.exists()) {
                    message = "Database \"" + dir.getAbsolutePath() + "\" does NOT EXIST.\nDo you want to CREATE a new database with this name \"" + dir.getName() + "\" ?";
                } else {
                    message = "Database \"" + dir.getAbsolutePath() + "\" is NOT A VALID directory.\nDo you want to CREATE a new database with this name \"" + dir.getName() + "\" ?";
                }

                choice = JOptionPane.showConfirmDialog(this, message, "Database Selection Option", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, dialogIcon);
                if (choice == JOptionPane.YES_OPTION) {
                    selectionMade = true;
                } else {
                    selectionMade = false;
                }
            }
        }
        return selectionMade;
    }

    /**
     * 
     * @param Title Title for the File Chooser dialog box
     * @param ToolTipText Tooltip text for the "OK" button
     * @return Returns the Directory selected, returns a null value if an invalid directory is selected
     */
    private File choosefile(String Title, String ToolTipText) {
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
         

        File selectedDirectory = null;

        setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        DirectoryDialog = new FileSelectDialog(javax.swing.JOptionPane.getFrameForComponent(this), true,true);
        FileSelectReturnParameter returnObj = FileSelectDialog.showDialog(true,Title,"OK",ToolTipText,DirectoryDialog,javax.swing.JOptionPane.getFrameForComponent(this));
        if (returnObj.getAction() == FileSelectDialog.ACTION_ADD) {
            selectedDirectory = new File(returnObj.getPaths()[0]);
        }
        return selectedDirectory;

    }

    /**
     * The user clicks this button to connect to an existing database.
     *
     * @param evt the event
     */
    private void btnLoadDatabaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLoadDatabaseActionPerformed
       createLoadDatabase(false, evt);
}//GEN-LAST:event_btnLoadDatabaseActionPerformed

    
    /**
     * The user clicks browse for a volume location
     *
     * @param evt the event
     */
    private void browseVolumeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseVolumeButtonActionPerformed
        //Select volume for profiling only if a valid database path is selected 
        if (!invalidDatabaseNameWarning.isVisible()) {
            //Launch folder browser window for DROID launch
            DirectoryDialog = new FileSelectDialog(javax.swing.JOptionPane.getFrameForComponent(this), true,true);
            FileSelectReturnParameter returnObj = FileSelectDialog.showDialog(true,"Choose a profiling location","Select Location","Please choose a valid location for profiling",DirectoryDialog,javax.swing.JOptionPane.getFrameForComponent(this));
            if (returnObj.getAction() == FileSelectDialog.ACTION_ADD) {
                File selectedDir = new File(returnObj.getPaths()[0]);
                volumeEntry.setText(selectedDir.getAbsolutePath());
            }

            hideErrorMessages();
        }
    }//GEN-LAST:event_browseVolumeButtonActionPerformed

    /**
     * The user commences profiling. We first validate the inputs.
     *
     * @param evt the event
     */
    private void startProfilingButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startProfilingButtonActionPerformed
        //Check all necessary fields are filled, then launch!
        //Perform profiling only if a valid database path is selected 
        if (!invalidDatabaseNameWarning.isVisible()) {
            boolean proceed = true;
            File newLocation = new File(volumeEntry.getText());
            //We check that a valid file location has been entered
            if (!newLocation.exists()) {
                invalidVolumeWarning.setVisible(true);
                proceed = false;
            } else {
                invalidVolumeWarning.setVisible(false);
            }
            String profileName;
            if (newProfileRadio.isSelected()) {
                profileName = newProfileName.getText().toUpperCase();
            } else {
                profileName = (String) profileSelect.getSelectedItem();
            }
            //Profile name must not be blank, and must not be the same as an existing profile name
            //We do not allow ' or " in the profile name to help prevent sql-injection
            if (newProfileRadio.isSelected() && (currentProfileNames.contains(profileName.toUpperCase()) || profileName.equals("") || profileName.indexOf("\'") != -1 || profileName.indexOf("\"") != -1)) {
                invalidProfileNameWarning.setVisible(true);
                proceed = false;

            } else {
                invalidProfileNameWarning.setVisible(false);
            }
            //check to make sure there is enough space to grow the database
            //Threshold is set to 1MB
            double freeSpace = (manager.getDatabaseLocation().getUsableSpace() / 1024d) / 1024d;

            if (freeSpace < 1) {
                proceed = false;
                String theMessage = "Error: There is not enough free disk space on location: " + manager.getDatabaseLocation().getAbsolutePath() + ".\nDROID needs a minimum of 1.0 MB to perform profiling.\nPlease free space on this drive and try again.";
                javax.swing.JOptionPane.showMessageDialog(this, theMessage, "DROID error", javax.swing.JOptionPane.ERROR_MESSAGE);
            }
            if (proceed) {
                //Launch the profiling!
                log.info("Profiling Started for folder: " + newLocation.getAbsolutePath());
                setCursor(new Cursor(Cursor.WAIT_CURSOR));
                
                analysisController.setAnalysisStart();
                ProfileVolume vol = manager.prepareVolumeForProfilingImmediately(profileName, newLocation);
                ProfilingThread thread = new ProfilingThread(manager, vol, analysisController);
                thread.start();
                StatsResultDialog.showDialog(this, vol, analysisController);

                //Update volumes table and profile drop down
                if (newProfileRadio.isSelected()) {
                    //The user selected create new profile - we add the new profile to the drop down and select it
                    profileSelect.addItem(profileName);
                    profileSelect.getModel().setSelectedItem(profileName);
                    newProfileName.setText("");
                    newProfileName.setEnabled(false);
                    loadExistingRadio.setEnabled(true);
                    loadExistingRadio.setSelected(true);
                    profileSelect.setEnabled(true);
                    //Also add it to the in memory list of names
                    currentProfileNames.add(profileName);
                }
                while (thread.isAlive()) {
                    //Check that the profiling thread has finished
                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        log.error(e.toString());
                    }
                }
                updateVolumeTable();
                setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
                log.info("Profiling Ended for folder: " + newLocation.getAbsolutePath());
              }
        }
    }//GEN-LAST:event_startProfilingButtonActionPerformed


private void createLoadDatabase(boolean isCreateNewDB,java.awt.event.ActionEvent evt){
         //Launch folder browser window for database location selection
        //Try to connect or create a new DB if the user selected a valid DB path (i.e. if isDatabaseSelected() returns a value of true)
        if (isDatabaseSelected(isCreateNewDB)) {
            try {

                hideErrorMessages();

                setCursor(new Cursor(Cursor.WAIT_CURSOR));
                //Set the new database
                manager.changeDerbyDatabase(dir);
                databaseLocation.setText(dir.getAbsolutePath());
                analysisController.setDatabaseLocation(dir.getAbsolutePath());
                //Clear and repopulate the profile dropdown
                profileSelect.removeAllItems();
                currentProfileNames = manager.getAllProfileNames();
                for (String name : currentProfileNames) {
                    profileSelect.addItem(name);
                }
                newProfileRadio.setSelected(true);
                newProfileRadioActionPerformed(evt);
                if (currentProfileNames.isEmpty()) {
                    loadExistingRadio.setEnabled(false);
                } else {
                    loadExistingRadio.setEnabled(true);
                }
                updateVolumeTable();
                invalidDatabaseNameWarning.setVisible(false);
            } catch (Exception ex) {
                //Most likely Database path selected is not a valid Derby Database folder path
                log.error("An error occured in connecting to or creating a new database, please try again.\nIt is possible an invalid" +
                        " database path was provided.");
                invalidDatabaseNameWarning.setVisible(true);
            }
            setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        }
}
    
    
    /**
     * Launch the help
     *
     * @param evt the event
     */
    private void jMenuItemHelpContentsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHelpContentsActionPerformed
        launchHelp();
    }//GEN-LAST:event_jMenuItemHelpContentsActionPerformed

    /**
     * Launch the about box
     *
     * @param evt the event
     */
    private void jMenuItemHelpAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHelpAboutActionPerformed
        showAboutBox();
    }//GEN-LAST:event_jMenuItemHelpAboutActionPerformed

    /**
     * Switch back to standard DROID mode
     *
     * @param evt the event
     */
    private void standardDROIDModeSelected(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_standardDROIDModeSelected
        log.info("Switching to DROID mode");
        analysisController.switchToDroidMode();
    }//GEN-LAST:event_standardDROIDModeSelected



    /**
     * Exit is chosen from the file menu
     *
     * @param evt the event
     */
    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        log.info("DROID is closing");
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    /**
     * View reports is chosen from the menu
     *
     * @param evt the event
     */
private void mnuItmViewProfileRptsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuItmViewProfileRptsActionPerformed
        //Generate profile reports only if a valid database path is selected 
        try {
            if (!invalidDatabaseNameWarning.isVisible()) {
                launchReportForm(ReportForm.ReportType.PROFILE, "Profile Reports");
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage() + ex.toString());
            log.error("An error occured in loading reports");
        }
}//GEN-LAST:event_mnuItmViewProfileRptsActionPerformed

private void mnuItmViewDBRptsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuItmViewDBRptsActionPerformed
    //Generate Database reports only if a valid database path is selected 
    try {
        if (!invalidDatabaseNameWarning.isVisible()) {
            launchReportForm(ReportForm.ReportType.DATABASE, "Database Reports");
        }
    } catch (Exception ex) {
        System.out.println(ex.getMessage() + ex.toString());
        log.error("An error occured in loading reports");
    }

}//GEN-LAST:event_mnuItmViewDBRptsActionPerformed

private void mnuItmViewAllRptsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mnuItmViewAllRptsActionPerformed
    //Generate All reports only if a valid database path is selected 
    try {
        if (!invalidDatabaseNameWarning.isVisible()) {
            launchReportForm(ReportForm.ReportType.ALL_REPORTS, "All Reports");
        }
    } catch (Exception ex) {
        System.out.println(ex.getMessage() + ex.toString());
        log.error("An error occured in loading reports");
    }

}//GEN-LAST:event_mnuItmViewAllRptsActionPerformed

private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
  
    OptionsDialog.showDialog(this, analysisController);
}//GEN-LAST:event_jMenuItem1ActionPerformed

private void jMenuBar1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jMenuBar1FocusGained
 System.out.println("Menu bar gained focus");
}//GEN-LAST:event_jMenuBar1FocusGained

private void jPanel1FocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jPanel1FocusGained
System.out.println("Panel Options gained focus");
}//GEN-LAST:event_jPanel1FocusGained

private void profileSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_profileSelectActionPerformed
hideErrorMessages();
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
        updateVolumeTable();
        setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
}//GEN-LAST:event_profileSelectActionPerformed

private void newProfileNameKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_newProfileNameKeyTyped
if(newProfileRadio.isSelected() && newProfileName.isEnabled() && !evt.isActionKey()){
         enableProfilingComponents(true);
      
     }else{
        enableProfilingComponents(false);
     }
}//GEN-LAST:event_newProfileNameKeyTyped

private void newProfileNameFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_newProfileNameFocusLost
if(newProfileRadio.isSelected() && newProfileName.isEnabled() && !newProfileName.getText().trim().equals("")){
      enableProfilingComponents(true);
      
  }else{
      enableProfilingComponents(false);
  }
}//GEN-LAST:event_newProfileNameFocusLost

private void newProfileRadioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newProfileRadioActionPerformed
//Create a new profile only if a valid database path is selected 
        if (!invalidDatabaseNameWarning.isVisible()) {
            profileSelect.setEnabled(false);
            newProfileName.setEnabled(true);
            hideErrorMessages();
            DefaultTableModel model = (DefaultTableModel) volumeTable.getModel();
            //Clear the current data
            for (int i = model.getRowCount() - 1; i > -1; i--) {
                model.removeRow(i);
            }
            newProfileName.requestFocus();
            newProfileName.selectAll();
            if(!newProfileName.getText().trim().equals("")){
                enableProfilingComponents(true);
            }else{
                enableProfilingComponents(false);
            }
                
        }
}//GEN-LAST:event_newProfileRadioActionPerformed

private void loadExistingRadioPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadExistingRadioPerformed
//Load existing profile only if a valid database path is selected 
        if (!invalidDatabaseNameWarning.isVisible()) {
            profileSelect.setEnabled(true);
            newProfileName.setEnabled(false);
            hideErrorMessages();
            updateVolumeTable();
            if(profileSelect.getItemCount() > 0 && profileSelect.getSelectedIndex() > -1 ){
                enableProfilingComponents(true);
            }
        }
}//GEN-LAST:event_loadExistingRadioPerformed

private void btnCreateDatabaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCreateDatabaseActionPerformed
    createLoadDatabase(true, evt);
}//GEN-LAST:event_btnCreateDatabaseActionPerformed

/**
 * This is used to enable or disable the profile components
 * @param setValue Boolean value to which profiling components enabled property is set
 */
private void enableProfilingComponents(boolean setValue){
    jLabel1.setEnabled(setValue);
    volumeEntry.setEnabled(setValue);
    browseVolumeButton.setEnabled(setValue);
    startProfilingButton.setEnabled(setValue);
}
    /**
     * Hides all error messages
     */
    private void hideErrorMessages() {
        invalidProfileNameWarning.setVisible(false);
        invalidVolumeWarning.setVisible(false);
        invalidDatabaseNameWarning.setVisible(false);
    }

    /**
     * Updates the volume table
     */
    private void updateVolumeTable() {
        DefaultTableModel model = (DefaultTableModel) volumeTable.getModel();
        //Clear the current data
        for (int i = model.getRowCount() - 1; i > -1; i--) {
            model.removeRow(i);
        }
        //Repopulate the table
        if (loadExistingRadio.isSelected()) {
            String profileName = (String) profileSelect.getSelectedItem();
            //Get the volumes and fill in the table
            List<ProfileVolume> volumes = manager.getAllVolumesForProfile(profileName);
            SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
            for (ProfileVolume volume : volumes) {
                String startDate = "";
                if (volume.getDateStarted() != null) {
                    startDate = format.format(volume.getDateStarted());
                }
                String endDate = "";
                if (volume.getDateCompleted() != null) {
                    endDate = format.format(volume.getDateCompleted());
                }
                String numberOfFiles = String.valueOf(manager.getNumberOfFilesInVolume(volume));
                String totalSize = "";
                Long size = manager.getTotalSizeOfVolume(volume);
                if (size != null) {
                    totalSize = FileUtils.byteCountToDisplaySize(size);
                }
                model.addRow(new Object[]{volume.getVolume(), startDate, endDate, numberOfFiles, totalSize});
            }
        }
        model.fireTableDataChanged();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        final String arg = args[0];
        EventQueue.invokeLater(new Runnable() {
            public void run() {
                AnalysisController control = new AnalysisController();
                try{
                new ProfilingFrame(new ProfilingManager(new File(arg)), control).setVisible(true);
                }catch(Exception ex){
                    
                }
            }
        });
    }

    /**
     * Sets the default column sizes
     */
    private void setTableColumns() {
        volumeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        volumeTable.getColumnModel().getColumn(1).setPreferredWidth(190);
        volumeTable.getColumnModel().getColumn(2).setPreferredWidth(190);
        volumeTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        volumeTable.getColumnModel().getColumn(4).setPreferredWidth(80);
        volumeTable.getParent().setBackground(Color.white);
   }

    /**
     * Checks whether a new signature file download is due
     */
    private void sigFileDownloadDue() {

        //Message for confirmm dialog
        final String confirmMessage = MSG_CHECK_SIG_FILE_UPDATE;

        //Check if a signature download file is due and that a
        if (analysisController.isSigFileDownloadDue()) {
            //if download is due ask user if they would like to check for a new signature file
            int confirmValue = JOptionPane.showConfirmDialog(this, confirmMessage, "Signature file update", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

            if (confirmValue == JOptionPane.YES_OPTION) {
                //if they confirm they would like to then
                //check if a newer file exists and download
                checkSigFileAndDownload();
            }
        }
    }

    /**
     * Checks whether a new signature file download is due
     */
    private void checkSigFileAndDownload() {
        //Message for confirm dialog
        final String confirmMessage = MSG_DOWNLOAD_SIG_FILE;

        //Set cursor to wait
        setCursor(java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.WAIT_CURSOR));

        //Check if newer sig file available
        if (analysisController.isNewerSigFileAvailable()) {

            //Reset status bar text and mouse cursor
            setCursor(null);

            //Confirm with user whether they would like to download new signature file
            int confirmValue = JOptionPane.showConfirmDialog(this, confirmMessage, "Signature file update available", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

            if (confirmValue == JOptionPane.YES_OPTION) {
                //if they confirm they would like to then
                //download
                //Set cursor to wait
                setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                analysisController.downloadwwwSigFile();
                setCursor(null);

            }
        } else if (PronomWebService.isCommSuccess) {
            //Newer sig file not found
            setCursor(null);
            //Update the DateLastDownload in the configuration file - this is so that the user is not asked to check signature file until another "DownloadFrequency" days have elapsed
            analysisController.updateDateLastDownload();
            //Tell user newer sig file not found
            JOptionPane.showMessageDialog(this, "Your signature file is up to date.", "No update available", JOptionPane.INFORMATION_MESSAGE);
        } else {
            //failed to connect to web service

            setCursor(null);
            //Message to warn user
            String failureMessage = "Unable to connect to the PRONOM web service. Make sure that the following settings in your configuration file (DROID_config.xml) are correct:\n";
            failureMessage += "    1- <SigFileURL> is the URL of the PRONOM web service.  This should be '" + AnalysisController.PRONOM_WEB_SERVICE_URL + "'\n";
            failureMessage += "    2- <ProxyHost> is the IP address of the proxy server if one is required\n";
            failureMessage += "    3- <ProxyPort> is the port to use on the proxy server if one is required";
            //Warn the user that the connection failed
            JOptionPane.showMessageDialog(this, failureMessage, "Web service connection error", javax.swing.JOptionPane.WARNING_MESSAGE);
        }
    }

    /**
     * Displays About box
     */
    private void showAboutBox() {
        AboutDialog.showDialog(this, APPLICATION_NAME, AnalysisController.getDROIDVersion(), analysisController.getSigFileVersion() + "");
    }

    /**
     * Launch the help window
     */
    private void launchHelp() {
        JHelp helpViewer = null;
        boolean foundHelpSet;

        //Set cursor to wait (Egg timer)
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

        // Get the classloader of this class.
        ClassLoader cl = FileIdentificationPane.class.getClassLoader();
        URL url = FileIdentificationPane.class.getResource("Help/jhelpset.hs");
//        ClassLoader cl = ProfilingFrame.class.getClassLoader();
//        URL url = getClass().getResource("../../GUI/Help/jhelpset.hs");

        try {
            // Create a new JHelp object with a new HelpSet.
            helpViewer = new JHelp(new HelpSet(cl, url));
            // Set the initial entry point in the table of contents.
            helpViewer.setCurrentID("Simple.Introduction");
            foundHelpSet = true;
        }
        catch (Exception e) {
            log.error("API Help Set not found");
            System.err.println("API Help Set not found");
            log.error(e.toString());
            System.err.println(e.toString());
            foundHelpSet = false;
            setCursor(null);
            JOptionPane.showMessageDialog(this, "DROID Help set not found");
        }

        //If the help set has been found and intialised then show window
        if (foundHelpSet) {
            // Create a new frame.
            JFrame frame = new JFrame();

            //Set title same as menu item
            frame.setTitle(jMenuItemHelpContents.getText());

            // Set it's size.
            frame.setSize(800, 500);
            // Add the created helpViewer to it.
            frame.getContentPane().add(helpViewer);
            // Set a default close operation.
            frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
            //Set location of help window relative to application window
            frame.setLocationRelativeTo(this);

            try {
                frame.setIconImage(ImageIO.read(getClass().getResource("/uk/gov/nationalarchives/droid/GUI/Icons/Help Green 16 h g.gif")));
            } catch (java.io.IOException e) {
                //silently ignore exception
            }
            // Make the frame visible.
            frame.setVisible(true);
        }
        setCursor(null);
    }
    
    /**
     * Launch the Report form
     */
    public void launchReportForm(ReportForm.ReportType reportType,String reportTitle){
      if (reportForm != null){
             reportForm.dispose();
        }
        reportForm = new ReportForm(this, false, manager,analysisController);   
        reportForm.reportType = reportType;
        reportForm.setTitle("DROID Reporting  ["+reportTitle+"]");
        reportForm.populateProfileAndReportNames();
        reportForm.setFilterComponents();
        reportForm.setEnablePropOperatorsList(false);
        reportForm.toFront();
        reportForm.setLocationRelativeTo(this);
        reportForm.setVisible(true);
        
                 
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton browseVolumeButton;
    protected javax.swing.JButton btnCreateDatabase;
    protected javax.swing.JButton btnLoadDatabase;
    private javax.swing.JLabel currentDatabaseLabel;
    protected javax.swing.JTextField databaseLocation;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JLabel invalidDatabaseNameWarning;
    private javax.swing.JLabel invalidProfileNameWarning;
    private javax.swing.JLabel invalidVolumeWarning;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItemHelpAbout;
    private javax.swing.JMenuItem jMenuItemHelpContents;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JRadioButton loadExistingRadio;
    private javax.swing.JMenuItem mnuItmViewAllRpts;
    private javax.swing.JMenuItem mnuItmViewDBRpts;
    private javax.swing.JMenuItem mnuItmViewProfileRpts;
    protected javax.swing.JTextField newProfileName;
    private javax.swing.JRadioButton newProfileRadio;
    protected javax.swing.JComboBox profileSelect;
    private javax.swing.ButtonGroup radioButtonGroup;
    private javax.swing.JMenu reportMenu;
    protected javax.swing.JMenuItem standardDroidMenuItem;
    protected javax.swing.JButton startProfilingButton;
    protected javax.swing.JTextField volumeEntry;
    protected javax.swing.JTable volumeTable;
    // End of variables declaration//GEN-END:variables

}
