/**
 *  � The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   1-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import org.hibernate.annotations.Index;

import javax.persistence.*;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.Cascade;

/**
 * Domain class for file objects
 */
@Entity(name = "FileObject")
public class FileObject implements Serializable, Comparable<FileObject> {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    @Column(nullable = false, name = "name")
    @Index(name = "fileNameIndex")
    private String name;

    @Column(nullable = false, name="filesize")
    @Index(name = "fileSizeIndex")
    private Long fileSize;

    @Column(length = 1024, name = "path")
    @Index(name = "filePathIndex")
    private String path;

    @Column(name = "lastModified")
    @Temporal(value = TemporalType.TIMESTAMP)
    @Index(name = "filelastModifiedIndex")
    private Date lastModified;

    @Column(name = "classificationtext")
    private String classificationText;

    @Transient
    private static final long serialVersionUID = 6115739363922702070L;

    @ManyToOne(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER, targetEntity = ProfileVolume.class)
    @JoinColumn(name = "profilevolume_id")
    private ProfileVolume profileVolume;

   // @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, targetEntity = Format.class)
   // @Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)
   // private List<Format> formats;
    
    
    /**
     * Default constructor - used by hibernate
     */
    public FileObject() {
    }

    /**
     * Specified constructor using parent volume, and a java file object
     *
     * @param file          the file object on which this is based
     * @param profileVolume the profile volume to add it to
     */
    public FileObject(File file, ProfileVolume profileVolume) {
        this();
        setProfileVolume(profileVolume);
        setName(file.getName());
        setPath(file.getAbsolutePath());
        setFileSize(file.length());
        setLastModified(new Date(file.lastModified()));
    }

    /**
     * Setter
     * @param name  the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Setter
     * @param size the file size
     */
    public void setFileSize(Long size) {
        this.fileSize = size;
    }

    /**
     * Setter
     * @param path the path
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * Setter
     * @param profileVolume the profile volume
     */
    public void setProfileVolume(ProfileVolume profileVolume) {
        this.profileVolume = profileVolume;
    }

    /**
     * Setter
     * @param lastModified  the last modified date
     */
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * Sort by paths
     *
     * @param fileObject for comparison
     * @return sort
     */
    public int compareTo(FileObject fileObject) {
        return this.path.compareTo(fileObject.path);
    }

    /**
     * Set classification text
     * @param classificationText    the text
     */
    public void setClassificationText(String classificationText) {
        this.classificationText = classificationText;
    }

    /**
     * Getter
     * @return  the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Getter
     * @return  the name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter
     * @return  the file size
     */
    public Long getFileSize() {
        return fileSize;
    }

    /**
     * Getter
     * @return  the path
     */
    public String getPath() {
        return path;
    }

    /**
     * Getter
     * @return  last modified date
     */
    public Date getLastModified() {
        return lastModified;
    }

    /**
     * Getter
     * @return  classification text
     */
    public String getClassificationText() {
        return classificationText;
    }
}
