/**
 *  � The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   1-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.Cascade;

/**
 * Base class for profile volumes
 */
@Entity(name = "ProfileVolume")
public class ProfileVolume implements Serializable, Comparable<ProfileVolume> {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    @Temporal(value = TemporalType.TIMESTAMP)
    @Column(name = "datestarted")
    private Date dateStarted;

    @Temporal(value = TemporalType.TIMESTAMP)
    @Column(name = "datecompleted")
    private Date dateCompleted;

    @Column(length = 1024, name = "volume")
    private String volume;

    @Column(name = "hostname")
    private String hostname;

    @ManyToOne(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER, targetEntity = Profile.class)
    @JoinColumn(name = "profile_id")
    private Profile profile;

    //@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.LAZY, targetEntity = FileObject.class)
    //@Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)
    //private List<FileObject> fileObjects;
    
    
    @Transient
    private static final long serialVersionUID = 4892012403675729200L;

    /**
     * Getter
     * @return  date started
     */
    public Date getDateStarted() {
        return dateStarted;
    }

    /**
     * Setter
     * @param dateStarted   date started
     */
    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    /**
     * Getter
     * @return  date completed
     */
    public Date getDateCompleted() {
        return dateCompleted;
    }

    /**
     * Setter
     * @param dateCompleted the date completed
     */
    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    /**
     * Getter
     * @return  the volume location
     */
    public String getVolume() {
        return volume;
    }

    /**
     * Setter
     * @param volume    the volume location
     */
    public void setVolume(String volume) {
        this.volume = volume;
    }

    /**
     * Getter
     * @return  the hostname
     */
    public String getHostname() {
        return hostname;
    }

    /**
     * Setter
     * @param hostname  the hostname
     */
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    /**
     * Getter
     * @return the profile
     */
    public Profile getProfile() {
        return profile;
    }

    /**
     * Setter
     * @param profile   the profile
     */
    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    /**
     * Compares based on date completed
     * @param profileVolume     volume for comparison
     * @return  sort
     */
    public int compareTo(ProfileVolume profileVolume) {
        return dateCompleted.compareTo(profileVolume.dateCompleted);
    }

    /**
     * Getter
     * @return  the id
     */
    public Long getId() {
        return id;
    }
}
