/**
 *   The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   1-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import javax.persistence.*;
import java.io.Serializable;

/**
 * File property class (hibernate compatible)
 */
@Entity
public class Property implements Serializable, Comparable<Property> {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    @Basic
    private String name;

    @Basic
    private Integer propertyId;

    @Basic
    private String value;

    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER, targetEntity = FileObject.class)
    private FileObject fileObject;


    @Transient
    private static final long serialVersionUID = -7354280898508038620L;


    public Property() {
    }

    public Property(FileObject fileObject) {
        this();
        this.fileObject = fileObject;
    }

    public int compareTo(Property property) {
        return propertyId.compareTo(this.propertyId);
    }
}
