/**
 *   The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   12-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import java.io.Serializable;

/**
 * Represents a row in the puid data summary
 */
public class PuidData implements Serializable {

    private String puid;
    private String mimeType;
    private String name;
    private String version;
    private Long numOfFiles;
    private Long totalSize;

    /**
     * Creates a new puid row from a file object and a format
     *
     * @param file   the file object
     * @param format the format
     */
    protected PuidData(FileObject file, Format format) {
        this.puid = format.getPuid();
        this.name = format.getName();
        this.version = format.getVersion();
        this.mimeType = format.getMimeType();
        this.numOfFiles = 1L;
        this.totalSize = file.getFileSize();
    }

    /**
     * Getter
     *
     * @return the puid
     */
    public String getPuid() {
        return puid;
    }

    /**
     * Getter
     *
     * @return the mime type
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Getter
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter
     *
     * @return the version
     */
    public String getVersion() {
        return version;
    }

    /**
     * Getter
     *
     * @return the number of files
     */
    public Long getNumOfFiles() {
        return numOfFiles;
    }

    /**
     * Getter
     *
     * @return the total size
     */
    public Long getTotalSize() {
        return totalSize;
    }

    /**
     * Adds a file of the same format to this puid data
     *
     * @param obj the file object
     */
    protected void addFileOfSameFormat(FileObject obj) {
        this.numOfFiles++;
        totalSize += obj.getFileSize();
    }
}
