/**
 * (c) Copyright  2008 Tessella Support Services plc.  
 * All rights reserved. 
 * <p/>
 * Project: 4678
 * DCS Profiling
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created By:     trir
 * Created Date:   04-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.service;

import uk.gov.nationalarchives.droid.profile.domain.ProfileVolume;
import uk.gov.nationalarchives.droid.AnalysisController;

/**
 * Thread for running directory walker in background
 */
public class ProfilingThread extends Thread {

    private ProfilingManager manager;
    private ProfileVolume volume;
    private AnalysisController analysisController;

    /**
     * Fully specified constructor
     *
     * @param manager the profile manager
     * @param vol     the profile volume
     * @param control the analysis controller
     */
    public ProfilingThread(ProfilingManager manager, ProfileVolume vol, AnalysisController control) {
        this.manager = manager;
        this.volume = vol;
        this.analysisController = control;
        setPriority(Thread.MIN_PRIORITY);
    }

    @Override
    public void run() {
        //Starts the profiling on the specified volume. Returns when finished
        boolean isCompleted = manager.performProfilingOnDirectory(volume, analysisController);
        if(isCompleted){
        manager.labelVolumeComplete(volume);
        }else{
            manager.saveVolume(volume);
        }
        
        analysisController.setProfilingComplete();
        
    }
}
