/*
 * ï¿½ The National Archives 2005-2006.  All rights reserved.
 * See Licence.txt for full licence details.
 *
 * Developed by:
 * Tessella Support Services plc
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * email: info@tessella.com
 * web:   www.tessella.com
 *
 * Project Number:  Tessella/NPD/4305
 *                  
 *
 * Project Title:   File Format Identification Tool
 * Project Identifier: uk
 *
 * $Id: OptionsDialog.java,v 1.12 2006/03/13 15:15:26 linb Exp $
 *
 * $Log: OptionsDialog.java,v $
 * Revision 1.12  2006/03/13 15:15:26  linb
 * Changed copyright holder from Crown Copyright to The National Archives.
 * Added reference to licence.txt
 * Changed dates to 2005-2006
 *
 * Revision 1.11  2006/02/13 11:27:29  linb
 * - Correct spelling in error message
 *
 * Revision 1.10  2006/02/09 12:14:15  linb
 * Changed some javadoc to allow it to be created cleanly
 *
 * Revision 1.9  2006/02/08 11:42:31  linb
 * - make saveConfiguration throw an IOException
 *
 * Revision 1.8  2006/01/31 16:47:30  linb
 * Added log messages that were missing due to the log keyword being added too late
 *
 * Revision 1.7  2006/01/31 16:21:20  linb
 * Removed the dollars from the log lines generated by the previous message, so as not to cause problems with subsequent commits
 *
 * Revision 1.6  2006/01/31 16:19:07  linb
 * Added Log: and Id: tags to these files
 *
 * Revision 1.5  2006/01/31 16:11:37  linb
 * Add support for XML namespaces to:
 * 1) The reading of the config file, spec file and file-list file
 * 2) The writing of the config file and file-list file
 * - The namespaces still need to be set to their proper URIs (currently set to example.com...)
 * - Can still read in files without namespaces
 *
 * Revision 1.4  2006/01/31 12:22:57  linb
 * - Changed height of proxy host and port text boxes to match others in the dialog
 *
 * Revision 1.3  2006/01/31 12:20:34  linb
 * - Aligned label text for proxy host and port
 * - Capitalised 'Port' label
 *
 * Revision 1.2  2006/01/31 12:00:37  linb
 * - Added new text field to option dialog for proxy setting
 * - Added new get/set methods to AnalysisController for proxy settings (from ConfigFile)

 * Version      Date        Author      Short Description
 *
 * V1.R0.M0     08-Mar-2005 S.Malik     Created

 * $History: OptionsDialog.java $ 
 * 
 * *****************  Version 25  *****************
 * User: Walm         Date: 20/10/05   Time: 15:15
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * When using the PRONOM web service, check whether the connection failed,
 * and if so provide a helpful message
 * 
 * *****************  Version 24  *****************
 * User: Mals         Date: 14/07/05   Time: 13:33
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Spinner cannot set update days value  below 1 or above 500
 * 
 * *****************  Version 23  *****************
 * User: Walm         Date: 6/06/05    Time: 17:04
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Review appearance
 * 
 * *****************  Version 22  *****************
 * User: Walm         Date: 12/05/05   Time: 10:14
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Bug fix: signature file display method erroneously removed path of
 * signature file if the file name started with the DROID directory name
 * and it was stored in the same level as the DROID directory
 * 
 * *****************  Version 21  *****************
 * User: Walm         Date: 11/05/05   Time: 17:30
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Bug correction: options dialog failed to notice if subdirectory added
 * to a relative signature file path
 * 
 * *****************  Version 20  *****************
 * User: Walm         Date: 11/05/05   Time: 15:15
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Bug correction: if signature file is in subdirectory of application
 * directory, make sure DROID doesn't assume it is in application
 * directory.
 * 
 * *****************  Version 19  *****************
 * User: Mals         Date: 4/05/05    Time: 10:04
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/CL/CSC/2005MAY03/17:29:14
 * Escape key cancels dialog
 * 
 * *****************  Version 18  *****************
 * User: Mals         Date: 4/05/05    Time: 9:28
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/CL/CSC/2005MAY03/16:54:42
 * Only show the full signature file path when it is not in the working
 * directory
 * 
 * *****************  Version 17  *****************
 * User: Mals         Date: 3/05/05    Time: 14:00
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/PR/IM/2005MAY03/08:51:16
 * 
 * B: Some of the labels, fields and buttons still need to be aligned. The
 * OK button also still needs to be resized to match Cancel. Also, these
 * buttons need keyboard shortcuts too.
 * 
 * *****************  Version 16  *****************
 * User: Walm         Date: 27/04/05   Time: 17:38
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * updates the date of last download in the configuration file when DROID
 * looks for a newer signature file and does not find one.
 * 
 * *****************  Version 15  *****************
 * User: Mals         Date: 20/04/05   Time: 12:21
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Uses methods in AnalysisController to parse and write signature file
 * date
 * 
 * *****************  Version 14  *****************
 * User: Mals         Date: 18/04/05   Time: 11:15
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/PR/IM/2005APR18/09:51:03
 * Title changed to "Options"   action from Issue 10.Menu bar changes as
 * in document.
 * 
 * *****************  Version 13  *****************
 * User: Mals         Date: 18/04/05   Time: 10:58
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/PR/IM/2005APR18/09:51:03
 * 13.The "Location" label should be "Signature file location".
 * 15."Update now" should be "Update Now".
 * 16.Labels, text boxes and buttons on a single line should be aligned
 * centrally  currently, they appear to be aligned top
 * 17.The OK and Cancel buttons should be the same size.
 * 
 * *****************  Version 12  *****************
 * User: Mals         Date: 15/04/05   Time: 17:09
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Signature file version time not shown
 * 
 * *****************  Version 11  *****************
 * User: Mals         Date: 15/04/05   Time: 15:53
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/PR/IM/2005APR13/17:56:51
 * 7. Options dialog could be cleaned up. 
 * +Layout changed 
 * 
 * *****************  Version 10  *****************
 * User: Mals         Date: 14/04/05   Time: 13:31
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Tessella Ref: NPD/4305/PR/IM/2005APR13/17:56:51
 * 7. I also think the Options dialog could be cleaned up. -Update Now
 * button moved
 * 
 * *****************  Version 9  *****************
 * User: Mals         Date: 13/04/05   Time: 10:57
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Ref:Email from A.Brown NPD/4305/CL/CSC/2005APR12/13:11  File ID GUI
 * Comments
 * "Request Update" button changed to "Update now"
 * 
 * *****************  Version 8  *****************
 * User: Mals         Date: 7/04/05    Time: 14:02
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Generate mnemonics code in NetBeans 3.6 turned off , so openide library
 * not needed
 * 
 * *****************  Version 7  *****************
 * User: Walm         Date: 6/04/05    Time: 15:23
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * further debugging of configuration parameter settings
 * 
 * *****************  Version 6  *****************
 * User: Walm         Date: 5/04/05    Time: 18:08
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * read signature file when browsing for new signature file
 * 
 * *****************  Version 5  *****************
 * User: Walm         Date: 4/04/05    Time: 17:45
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * review saving of config data
 * 
 * *****************  Version 4  *****************
 * User: Mals         Date: 31/03/05   Time: 10:42
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Uses CustomFileFilter when browsing for signature file
 * 
 * *****************  Version 3  *****************
 * User: Mals         Date: 30/03/05   Time: 15:44
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Displays current config options , but does not do saving
 * 
 * *****************  Version 2  *****************
 * User: Mals         Date: 29/03/05   Time: 15:56
 * Updated in $/PRONOM4/FFIT_SOURCE/GUI
 * Dialog updated after comments from A.Brown
 * NPD/4305/CL/CSC/2005MAR21/12:25:13 
 */

package uk.gov.nationalarchives.droid.GUI;

import uk.gov.nationalarchives.droid.AnalysisController;
import uk.gov.nationalarchives.droid.MessageDisplay;
import uk.gov.nationalarchives.droid.signatureFile.FFSignatureFile;
import uk.gov.nationalarchives.droid.xmlReader.PronomWebService;

import javax.swing.*;
import java.io.IOException;

/**
 * Dialog to change config settings
 * Features:
 * Sets the signature file update url
 * Sets the number of days before new signature file is checked
 * Requests update
 * Created in netBeans IDE 3.6
 * Related file OptionsDialog.Form (for use in netBeans)
 * <p/>
 * Dialog fields specified in email from A.Brown NPD/4305/CL/CSC/2005MAR21/12:25:13
 *
 * @author Shahzad Malik
 * @version V1.R0.M0, 08-Mar-2005
 */
public class OptionsDialog extends javax.swing.JDialog {

    /**
     * maximum number of days aloud for download frequency
     */
    private final int MAX_DOWNLOAD_DAYS = 500;

    /**
     * Dialog object to show *
     */
    private static OptionsDialog dialog;

    /**
     * return value for dialog
     */
    private static boolean value;

    /**
     * Analysis controller object to get and save config settings
     */
    private AnalysisController analysisControl;

    /**
     * Signature file extension
     */
    private String SIGNATURE_FILE_EXTENSION = "xml";
    /**
     * Signature file description
     */
    private String SIGNATURE_FILE_DESCRIPTION = "Signature file (*.xml) ";

    /**
     * previously loaded signature file
     */
    private String myPrevSigFile = "";

    /**
     * The full signature file path corresponding to what is in the text box
     */
    private String signatureFilePath;

    /**
     * Model for Days JSpinner object to restrict to positive values only
     */
    private SpinnerModel daysSpinnerModel;


    /**
     * Creates new form Options
     */
    private OptionsDialog(java.awt.Frame parent, boolean modal, AnalysisController analysisConrol) {
        super(parent, modal);
        this.analysisControl = analysisConrol;

        //Restrict JSpinner to values above 0 and not greater than 500
        daysSpinnerModel = new SpinnerNumberModel(1, 1, MAX_DOWNLOAD_DAYS, 1);

        initComponents();
        //Set "OK" as the default button
        this.getRootPane().setDefaultButton(jButtonOK);
        makeDisposeOnEscapeKey(this);
        setMnemonics();
        loadSettings();
        this.setLocationRelativeTo(parent);
        pack();
    }

    /**
     * Utility method to cancel dialog when escape button pressed
     *
     * @param rootPane dialog to close on escape key press
     */
    private static void makeDisposeOnEscapeKey(final javax.swing.RootPaneContainer rootPane) {
        //Create action to dispose
        javax.swing.Action action = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent arg0) {
                ((java.awt.Window) rootPane).dispose();

            }
        };

        //Get keystroke for escape key
        javax.swing.KeyStroke stroke = javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0);
        //Add escape key to action map for dialog
        rootPane.getRootPane().getActionMap().put(action, action);
        rootPane.getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(stroke, action);
    }

    /**
     * Set the mnemonics (Keyboard shortcuts) for menu items on this form
     * Can only be called after initComponents()
     */
    private void setMnemonics() {

        jButtonSigFileBrowse.setMnemonic('B');
        jButtonRequestUpdate.setMnemonic('U');

    }

    /**
     * Creates signature file version and date string in format 123(12-Mar-2005) ;
     *
     * @param version Signature file version
     * @param date    Signature file date (in the format 2005-02-24T12:35:23)
     * @return Version and date in required format
     */
    private String buildSigVersionDate(int version, String date) {

        java.util.Date myDate;
        String dateText;

        try {
            //parse the date supplied  into a Date object
            myDate = AnalysisController.parseXMLDate(date);
            dateText = AnalysisController.writeDisplayDate(myDate);

        } catch (java.text.ParseException pe) {
            //If date cannot be parsed then show the text supplied  
            dateText = date;
        }
        return version + " (" + dateText + ")";
    }

    /**
     * Returns full signature file path if it is somewhere other than the working directory
     * ,but shows just the file name if it is the working directory
     */
    private String displaySignatureFilePath() {
        String workingDirPath = System.getProperty("user.dir");
        if (signatureFilePath.startsWith(workingDirPath + java.io.File.separator)) {
            return signatureFilePath.substring(workingDirPath.length() + 1);
        } else {
            return signatureFilePath;
        }

    }

    /**
     * Get the current config settings and display
     */
    private void loadSettings() {


        jTextFieldSigFileVersion.setText(buildSigVersionDate(analysisControl.getSigFileVersion(), analysisControl.getSignatureFileDate()));

        signatureFilePath = analysisControl.getSignatureFileName();
        jTextSigFileAddress.setText(displaySignatureFilePath());

        jSpinnerUpdateDays.setValue(analysisControl.getSigFileCheckFreq());

        //keep a record of the current signature file in case there are any problems loading a new one.
        myPrevSigFile = analysisControl.getSignatureFileName();

        proxyHostTextField.setText(analysisControl.getProxyHost());
        int proxyPort;
        if ((proxyPort = analysisControl.getProxyPort()) == 0) {
            proxyPortTextField.setText("");
        } else {
            proxyPortTextField.setText(Integer.toString(proxyPort));
        }


    }

    /**
     * Apply config settings if they have changed
     */
    private void applySettings() {
        analysisControl.setSigFileCheckFreq(jSpinnerUpdateDays.getValue().toString());
        analysisControl.setProxyHost(proxyHostTextField.getText());
        int proxyPort;
        try {
            proxyPort = Integer.parseInt(proxyPortTextField.getText());
        } catch (NumberFormatException ex) {
            proxyPort = 0;
        }
        analysisControl.setProxyPort(proxyPort);


    }


    /**
     * Checks whether a new signature file download is due
     */
    private void downloadSigFile() {

        applySettings();

        //flag indicating whether to download signature file
        boolean doDownload = false;

        //Set cursor to wait
        this.setCursor(java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.WAIT_CURSOR));
        //Show in status bar that sig file update search is taking place
        // setStatusText("Checking for signature file update...") ;

        //Check if newer sig file available
        if (analysisControl.isNewerSigFileAvailable()) {

            doDownload = true;

        } else if (PronomWebService.isCommSuccess) {
            //Newer sig file not found

            //update DateLastDownload in configuration file
            analysisControl.updateDateLastDownload();

            this.setCursor(null);

            //Message for confirm dialog
            final String confirmMessage = "Your current signature file is up to date.\nDo you wish to download a new one anyway?";
            //Confirm with user whether they would like to download new signature file
            int confirmValue = JOptionPane.showConfirmDialog(this, confirmMessage, "Signature file up to date", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
            //Set cursor to wait
            this.setCursor(java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.WAIT_CURSOR));

            if (confirmValue == JOptionPane.YES_OPTION) {
                //if they confirm they would like to then download
                doDownload = true;
            }

        } else {
            //Failed to connect to web service

            this.setCursor(null);

            //Message to warn user
            String failureMessage = "Unable to connect to the PRONOM web service. Make sure that the following settings in your configuration file (DROID_config.xml) are correct:\n";
            failureMessage += "    1- <SigFileURL> is the URL of the PRONOM web service.  This should be '" + AnalysisController.PRONOM_WEB_SERVICE_URL + "'\n";
            failureMessage += "    2- <ProxyHost> is the IP address of the proxy server if one is required\n";
            failureMessage += "    3- <ProxyPort> is the port to use on the proxy server if one is required";
            //Warn the user that the connection failed
            javax.swing.JOptionPane.showMessageDialog(this, failureMessage, "Web service connection error", javax.swing.JOptionPane.WARNING_MESSAGE);

        }

        //cary out download of signature file
        if (doDownload) {
            //Set cursor to wait
            this.setCursor(java.awt.Cursor.getPredefinedCursor(java.awt.Cursor.WAIT_CURSOR));

            analysisControl.downloadwwwSigFile();

            loadSettings();
        }

        this.setCursor(null);

    }

    /**
     * Opens file browser to select signature file *
     */
    private void browseForSignatureFile() {

        //Intialise file chooser dialog
        javax.swing.JFileChooser fc = new javax.swing.JFileChooser();
        //Set current folder to current signature file location
        fc.setCurrentDirectory(new java.io.File(signatureFilePath));
        //Add file filter so only shows Signature files
        fc.addChoosableFileFilter(new CustomFileFilter(SIGNATURE_FILE_EXTENSION, SIGNATURE_FILE_DESCRIPTION));

        fc.setAcceptAllFileFilterUsed(false);
        //Show the dialog
        int returnVal = fc.showOpenDialog(this);

        //If user pressed OK then change location text to file selected
        if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
            signatureFilePath = fc.getSelectedFile().getPath();
            jTextSigFileAddress.setText(displaySignatureFilePath());
        }

    }

    /**
     * Validates that signature file exists
     *
     * @return message if signature file is invalid, empty string if signature file is valid
     */
    private String validateSignatureFile() {
        //Intialise return message as an empty string
        String returnMessage = "";


        java.io.File sigFile = new java.io.File(jTextSigFileAddress.getText());
        signatureFilePath = sigFile.getAbsolutePath();
        /*
        if (!sigFile.isAbsolute()){
           signatureFilePath = System.getProperty("user.dir") + java.io.File.separator + jTextSigFileAddress.getText() ;
           sigFile = new java.io.File(signatureFilePath);
        } else {
            signatureFilePath = jTextSigFileAddress.getText() ;
            sigFile = new java.io.File(signatureFilePath);
        }*/
        //If file exisits return message 
        if (!sigFile.exists()) {
            returnMessage = "\n" + sigFile.getPath() + " does not exist";
        }
        //return point 
        return returnMessage;
    }

    /**
     * Validate  update days
     * Check a valid number has been entered
     *
     * @return message if signature day is invalid, empty string if signature days is valid
     */
    private String validateUpdateDays() {
        //Intialise return message as an empty string
        String returnMessage = "";
        String toCheck = jSpinnerUpdateDays.getValue().toString();
        int updateDays = 0;

        //Check if string is blank
        if (toCheck.equals("")) {
            returnMessage = "\nPlease enter the number of days to check for a new signature file";
            return returnMessage;
        }

        //Try to parse number 
        try {
            updateDays = Integer.parseInt(toCheck);
        }
        catch (NumberFormatException e) {
            //if exception court return message that string is not a number 
            returnMessage = "\n" + toCheck + " is not a valid number";
            return returnMessage;
        }

        //Check value is a postive value above zero
        if (updateDays < 1) {
            returnMessage = "\nNumber of days to check for a new signature file should be above 0";
            return returnMessage;
        }

        //Check value is a postive value above zero
        if (updateDays > MAX_DOWNLOAD_DAYS) {
            returnMessage = "\nNumber of days to check for a new signature file should not be larger than " + MAX_DOWNLOAD_DAYS;
            return returnMessage;
        }

        //return point 
        return returnMessage;
    }

    /**
     * Calls all validation methods and displays message box if form is invalid
     *
     * @return true - if all validation methods pass , false - otherwise
     */
    private boolean validateAll() {

        boolean validated = true;
        String warningMessage = "";

        //Call all validation methods
        warningMessage = warningMessage + validateSignatureFile();
        warningMessage = warningMessage + validateUpdateDays();

        //if warning message exists show in dialog
        if (!warningMessage.equals("")) {
            validated = false;
            javax.swing.JOptionPane.showMessageDialog(this, warningMessage, "Options are invalid", javax.swing.JOptionPane.WARNING_MESSAGE);
        }

        //returns whether warnings exist 
        return validated;
    }


    /**
     * Checks whether the name of the signature file has been changed, and if so
     * the new one is loaded in. Returns true if the specified signature ifle is valid
     * otherwise it attempts to relaod the previously valid signature file
     */
    private boolean isNewSigFileLoaded() {

        boolean isValid = true;
        String theNewSigFileName = signatureFilePath;
        FFSignatureFile theNewSigFile;

        //set cursor to hourglass
        java.awt.Cursor hourglassCursor = new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR);
        java.awt.Cursor normalCursor = new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR);
        setCursor(hourglassCursor);

        //is this a new file or just the existing one again
        if (!theNewSigFileName.equalsIgnoreCase(myPrevSigFile)) {
            try {
                analysisControl.readSigFile(theNewSigFileName);

            } catch (Exception e) {
                isValid = false;
                //set cursor back to normal
                setCursor(normalCursor);
                javax.swing.JOptionPane.showMessageDialog(this, "Unable to read in signature file " + theNewSigFileName, "Signature file reader error", javax.swing.JOptionPane.WARNING_MESSAGE);
                try {
                    if (!myPrevSigFile.equals("")) {
                        setCursor(hourglassCursor);
                        analysisControl.readSigFile(myPrevSigFile);
                    }
                } catch (Exception e2) {
                }
            }
        }
        //review display of configuration settings
        jTextFieldSigFileVersion.setText(buildSigVersionDate(analysisControl.getSigFileVersion(), analysisControl.getSignatureFileDate()));
        jTextSigFileAddress.setText(displaySignatureFilePath());
        signatureFilePath = analysisControl.getSignatureFileName();
        //set cursor back to normal
        setCursor(normalCursor);
        //was new signature file load successful?
        return isValid;
    }

    /**
     * Checks whether the specified signature file loads successfully and displays the version info
     */
    private boolean isNewSigFileValid() {

        boolean isValid = true;
        String theNewSigFileName = signatureFilePath;
        FFSignatureFile theNewSigFile;

        //set cursor to hourglass
        java.awt.Cursor hourglassCursor = new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR);
        java.awt.Cursor normalCursor = new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR);
        setCursor(hourglassCursor);

        //is this a new file or just the existing one again
        if (!theNewSigFileName.equalsIgnoreCase(myPrevSigFile)) {
            try {
                //analysisControl.readSigFile(theNewSigFileName);
                theNewSigFile = analysisControl.parseSigFile(theNewSigFileName);

                //update display
                jTextFieldSigFileVersion.setText(buildSigVersionDate(analysisControl.getSigFileVersion(), analysisControl.getSignatureFileDate()));

            } catch (Exception e) {
                isValid = false;
                //set cursor back to normal
                setCursor(normalCursor);
                javax.swing.JOptionPane.showMessageDialog(this, "Unable to read in signature file " + theNewSigFileName, "Signature file reader error", javax.swing.JOptionPane.WARNING_MESSAGE);
/*                 try {
                     if (!myPrevSigFile.equals("")){
                         setCursor(hourglassCursor);
                         analysisControl.readSigFile(myPrevSigFile);
                     }
                 } catch(Exception e2) {
                 }*/
            }
        }
        //review display of configuration settings
//        loadSettings();
        //set cursor back to normal
        setCursor(normalCursor);
        //was new signature file load successful?
        return isValid;
    }

    /**
     * User confirms to change option settings
     */
    private void confirmOK() {
        if (validateAll()) {

            if (!isNewSigFileLoaded()) {
                return;
            }
            this.applySettings();
            try {
                analysisControl.saveConfiguration();
            } catch (IOException e) {
                MessageDisplay.generalWarning("Unable to save configuration updates");
            }

            //Hide dialog 
            OptionsDialog.dialog.setVisible(false);
            MessageDisplay.setStatusText("Current signature file is V" + analysisControl.getSigFileVersion());
        }
    }


    /**
     * Creates and shows a options dialog
     *
     * @param frameComp       Component dialog is owned by
     * @param analysisControl AnalysisController object to get and save config settings
     * @return return value
     */
    public static boolean showDialog(java.awt.Component frameComp, AnalysisController analysisControl) {

        java.awt.Frame f = javax.swing.JOptionPane.getFrameForComponent(frameComp);

        dialog = new OptionsDialog(f, true, analysisControl);
        
        //Centre on screen
        dialog.setLocationRelativeTo(f);
        
        dialog.setVisible(true);

        return value;

    }

    /**
     * Hide dialog when cancel action performed
     */
    private void cancelDialog() {
        OptionsDialog.dialog.setVisible(false);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMiddle = new javax.swing.JPanel();
        jPanelSigFileDetails = new javax.swing.JPanel();
        jLabelSigFileVersion = new javax.swing.JLabel();
        jTextFieldSigFileVersion = new javax.swing.JTextField();
        jLabelCheckForSignature = new javax.swing.JLabel();
        jSpinnerUpdateDays =  new javax.swing.JSpinner(daysSpinnerModel);
        jLabelDays = new javax.swing.JLabel();
        jButtonRequestUpdate = new javax.swing.JButton();
        jLabelSignatureUpdateAddress = new javax.swing.JLabel();
        jTextSigFileAddress = new javax.swing.JTextField();
        jButtonSigFileBrowse = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        proxyHostTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        proxyPortTextField = new javax.swing.JTextField();
        jSeparator1 = new javax.swing.JSeparator();
        jPanelActions = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Options");
        setResizable(false);

        jPanelMiddle.setPreferredSize(new java.awt.Dimension(455, 135));
        jPanelMiddle.setLayout(new java.awt.BorderLayout());

        jPanelSigFileDetails.setPreferredSize(new java.awt.Dimension(430, 100));
        jPanelSigFileDetails.setLayout(null);

        jLabelSigFileVersion.setLabelFor(jLabelSigFileVersion);
        jLabelSigFileVersion.setText("Current version");
        jPanelSigFileDetails.add(jLabelSigFileVersion);
        jLabelSigFileVersion.setBounds(10, 40, 90, 20);

        jTextFieldSigFileVersion.setEditable(false);
        jTextFieldSigFileVersion.setPreferredSize(new java.awt.Dimension(60, 20));
        jPanelSigFileDetails.add(jTextFieldSigFileVersion);
        jTextFieldSigFileVersion.setBounds(100, 40, 260, 20);

        jLabelCheckForSignature.setLabelFor(jSpinnerUpdateDays);
        jLabelCheckForSignature.setText("Check for update every");
        jPanelSigFileDetails.add(jLabelCheckForSignature);
        jLabelCheckForSignature.setBounds(10, 70, 130, 20);

        jSpinnerUpdateDays.setPreferredSize(new java.awt.Dimension(50, 20));
        jPanelSigFileDetails.add(jSpinnerUpdateDays);
        jSpinnerUpdateDays.setBounds(140, 70, 50, 20);

        jLabelDays.setText("days");
        jPanelSigFileDetails.add(jLabelDays);
        jLabelDays.setBounds(200, 70, 50, 20);

        jButtonRequestUpdate.setText("Update Now");
        jButtonRequestUpdate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRequestUpdateActionPerformed(evt);
            }
        });
        jPanelSigFileDetails.add(jButtonRequestUpdate);
        jButtonRequestUpdate.setBounds(250, 70, 110, 20);

        jLabelSignatureUpdateAddress.setLabelFor(jTextSigFileAddress);
        jLabelSignatureUpdateAddress.setText("Signature File");
        jPanelSigFileDetails.add(jLabelSignatureUpdateAddress);
        jLabelSignatureUpdateAddress.setBounds(10, 10, 80, 20);

        jTextSigFileAddress.setPreferredSize(new java.awt.Dimension(500, 20));
        jPanelSigFileDetails.add(jTextSigFileAddress);
        jTextSigFileAddress.setBounds(100, 10, 260, 20);

        jButtonSigFileBrowse.setText("Browse...");
        jButtonSigFileBrowse.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonSigFileBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSigFileBrowseActionPerformed(evt);
            }
        });
        jPanelSigFileDetails.add(jButtonSigFileBrowse);
        jButtonSigFileBrowse.setBounds(370, 10, 80, 20);

        jLabel1.setLabelFor(proxyHostTextField);
        jLabel1.setText("Proxy Host");
        jPanelSigFileDetails.add(jLabel1);
        jLabel1.setBounds(10, 110, 80, 20);
        jPanelSigFileDetails.add(proxyHostTextField);
        proxyHostTextField.setBounds(100, 110, 140, 20);

        jLabel2.setLabelFor(proxyPortTextField);
        jLabel2.setText("Port");
        jPanelSigFileDetails.add(jLabel2);
        jLabel2.setBounds(260, 110, 30, 20);
        jPanelSigFileDetails.add(proxyPortTextField);
        proxyPortTextField.setBounds(290, 110, 70, 20);
        jPanelSigFileDetails.add(jSeparator1);
        jSeparator1.setBounds(10, 100, 350, 2);

        jPanelMiddle.add(jPanelSigFileDetails, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanelMiddle, java.awt.BorderLayout.CENTER);

        jPanelActions.setPreferredSize(new java.awt.Dimension(10, 35));
        jPanelActions.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setText("OK");
        jButtonOK.setMaximumSize(new java.awt.Dimension(75, 23));
        jButtonOK.setMinimumSize(new java.awt.Dimension(75, 23));
        jButtonOK.setPreferredSize(new java.awt.Dimension(75, 23));
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });
        jPanelActions.add(jButtonOK);

        jButtonCancel.setText("Close");
        jButtonCancel.setMaximumSize(new java.awt.Dimension(75, 23));
        jButtonCancel.setMinimumSize(new java.awt.Dimension(75, 23));
        jButtonCancel.setPreferredSize(new java.awt.Dimension(75, 23));
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });
        jPanelActions.add(jButtonCancel);

        getContentPane().add(jPanelActions, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    /**
     * requests an updated signature file on button click
     *
     * @param evt Action event object
     */
    private void jButtonRequestUpdateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRequestUpdateActionPerformed
        downloadSigFile();
    }//GEN-LAST:event_jButtonRequestUpdateActionPerformed

    /**
     * Browse for signature file on button click
     *
     * @param evt Action event object
     */
    private void jButtonSigFileBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSigFileBrowseActionPerformed
        browseForSignatureFile();
        //attempt to load new signature file
        isNewSigFileLoaded();
    }//GEN-LAST:event_jButtonSigFileBrowseActionPerformed

    /**
     * Closes dialog on click wihtout saving
     *
     * @param evt ActionEvent Object
     */
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        cancelDialog();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    /**
     * Saves config information and closes dialog on click
     *
     * @param evt ActionEvent Object
     */
    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        confirmOK();

    }//GEN-LAST:event_jButtonOKActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JButton jButtonRequestUpdate;
    private javax.swing.JButton jButtonSigFileBrowse;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelCheckForSignature;
    private javax.swing.JLabel jLabelDays;
    private javax.swing.JLabel jLabelSigFileVersion;
    private javax.swing.JLabel jLabelSignatureUpdateAddress;
    private javax.swing.JPanel jPanelActions;
    private javax.swing.JPanel jPanelMiddle;
    private javax.swing.JPanel jPanelSigFileDetails;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSpinner jSpinnerUpdateDays;
    private javax.swing.JTextField jTextFieldSigFileVersion;
    private javax.swing.JTextField jTextSigFileAddress;
    private javax.swing.JTextField proxyHostTextField;
    private javax.swing.JTextField proxyPortTextField;
    // End of variables declaration//GEN-END:variables


}
