/**
 *  � The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   1-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import org.hibernate.annotations.Index;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Base class for formats
 */
@Entity(name = "Format")
public class Format implements Serializable, Comparable<Format> {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    @Column(nullable = true, name = "puid")
    @Index(name = "puidIndex")
    private String puid;

    @Column(nullable = true, name = "name")
    @Index(name = "formatNameIndex")
    private String name;

    @Column(nullable = true, name = "version")
    @Index(name = "formatVersionIndex")
    private String version;

    @Column(nullable = true, name = "mimetype")
    @Index(name = "mimeTypeIndex")
    private String mimeType;

    @Column(nullable = true, name = "warning")
    private String warning;

    @ManyToOne(cascade = CascadeType.PERSIST, fetch = FetchType.EAGER, targetEntity = FileObject.class)
    @JoinColumn(name = "fileobject_id")
    private FileObject fileObject;

    @Transient
    private static final long serialVersionUID = 1301014524441878729L;

    /**
     * Default constructor for hibernate
     */
    public Format() {
    }

    /**
     * Constructor setting parent
     * @param fileObject        the parent file object
     */
    public Format(FileObject fileObject) {
        this();
        setFileObject(fileObject);
    }

    /**
     * Setter
     * @param puid  the puid
     */
    public void setPuid(String puid) {
        this.puid = puid;
    }

    /**
     * Setter
     * @param name  the format name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Setter
     * @param version   the version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * Setter
     * @param mimeType  the mime type
     */
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    /**
     * Compares objects
     * @param format    the format for comparison
     * @return  sort
     */
    public int compareTo(Format format) {
        return puid.compareTo(format.puid);
    }

    /**
     * Setter
     * @param warning   the warning
     */
    public void setWarning(String warning) {
        this.warning = warning;
    }

    /**
     * Setter
     * @param fileObject    the file object
     */
    public void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    /**
     * Getter
     * @return  the puid
     */
    public String getPuid() {
        return puid;
    }

    /**
     * Getter
     * @return  the name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter
     * @return  the version
     */
    public String getVersion() {
        return version;
    }

    /**
     * Getter
     * @return  the mime type
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Getter
     * @return  the warning
     */
    public String getWarning() {
        return warning;
    }

    /**
     * Getter
     * @return  the file object
     */
    public FileObject getFileObject() {
        return fileObject;
    }
}
