/**
 *  � The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   1-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import org.hibernate.annotations.Index;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.annotations.Cascade;

/**
 * Base class for a profile
 */
@Entity(name = "Profile")
public class Profile implements Serializable, Comparable<Profile> {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    private Long id;

    @Column(unique = true, nullable = false, name = "name")
    @Index(name = "profileNameIndex")
    private String name;

    @Column(name = "datecreated")
    @Temporal(value = TemporalType.TIMESTAMP)
    private Date dateCreated;

    @Column(name = "description")
    private String description;

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, targetEntity = ProfileVolume.class)
    @Cascade(value = org.hibernate.annotations.CascadeType.DELETE_ORPHAN)
    private List<ProfileVolume> profileVolumes;

    @Transient
    private static final long serialVersionUID = 4732012403673029200L;

    /**
     * Default constructor used by hibernate
     */
    public Profile() {

    }

    public Long getId() {
        return id;
    }

    /**
     * Setter
     * @param name  the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Setter
     * @param dateCreated   the date created
     */
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    /**
     * Setter
     * @param description   the description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Compares profiles by name alphabetically
     * @param profile   the name
     * @return  sort
     */
    public int compareTo(Profile profile) {
        return this.name.compareTo(profile.name);
    }

    /**
     * Getter
     * @return  the name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter
     * @return  the date created
     */
    public Date getDateCreated() {
        return dateCreated;
    }

    /**
     * Getter
     * @return  the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Get all profile volumes corresponding to this profile
     * @return list
     */
    public List<ProfileVolume> getProfileVolumes() {
        if (profileVolumes == null) {
            profileVolumes = new ArrayList<ProfileVolume>();
        }
        return profileVolumes;
    }
}
