/**
 *   The National Archives 2005-2008.  All rights reserved.
 * See Licence.txt for full licence details.
 * <p/>
 *
 *  DROID DCS Profile Tool
 * <p/>
 * <p/>
 * Developed By:
 * Tessella Support Services
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * <p/>
 * email:  info@tessella.com
 * web:    www.tessella.com
 * <p/>
 * <p/>
 * Created Date:   12-Nov-2008
 */
package uk.gov.nationalarchives.droid.profile.domain;

import java.io.Serializable;
import java.util.Calendar;

/**
 * Represents a row of year data in the summary
 */
public class YearData implements Serializable {

    private Integer year;
    private Long totalSize;
    private Long numOfFiles;

    /**
     * Creates a new year object from the given file object
     *
     * @param file the file object
     */
    protected YearData(FileObject file) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(file.getLastModified());
        this.year = cal.get(Calendar.YEAR);
        this.totalSize = file.getFileSize();
        this.numOfFiles = 1L;
    }

    /**
     * Getter
     *
     * @return the year
     */
    public Integer getYear() {
        return year;
    }

    /**
     * Getter
     *
     * @return the total size of files
     */
    public Long getTotalSize() {
        return totalSize;
    }

    /**
     * Getter
     *
     * @return the number of files
     */
    public Long getNumOfFiles() {
        return numOfFiles;
    }

    /**
     * Adds a file of the same year
     *
     * @param file the file object
     */
    protected void addFileToTotals(FileObject file) {
        numOfFiles++;
        totalSize += file.getFileSize();
    }
}
