package fedora.services.sipcreator.mimetype;

import java.io.File;

import uk.gov.nationalarchives.droid.IdentificationFile;

import fedora.services.sipcreator.SIPCreator;

/**
 * This constructor produces a Droid mime type detection tool.<br>
 * <br>
 */
public class DroidDetector extends MimetypeDetector {

	/**
	 * This constructor uses the Droid object instantiated in SIPCreator to get
	 * the mimetype<br>
	 * <br>
	 * 
	 * @param newCreator
	 *            The SIPCreator from which to obtain Droid.
	 */
	public DroidDetector(SIPCreator newCreator) {
		super(newCreator);
	}

	/**
	 * Returns the latest (and generally the most highest version) hit. If not
	 * hit is found, returns an empty string
	 * 
	 * @param file
	 *            The file to identify
	 */
	public String getMimeType(File file) {
		IdentificationFile iFile = this.getCreator().getDroid().performAnalysis(file);
		if (iFile.getNumHits() == 0) {
			return "";
		} else {
			return iFile.getHit(iFile.getNumHits() - 1).getMimeType();
		}
	}

}
