/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class Checksummer
implements Checksum {
    protected long _nByte;
    private CRC32 _crc32;
    private MessageDigest _md5;
    private MessageDigest _sha1;

    public Checksummer() {
        this.reset();
    }

    public void reset() {
        this._nByte = 0L;
        this._crc32 = new CRC32();
        try {
            this._md5 = MessageDigest.getInstance("MD5");
            this._sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public long getValue() {
        return this._crc32.getValue();
    }

    public void update(byte by) {
        this._crc32.update(by);
        if (this._md5 != null) {
            this._md5.update(by);
        }
        if (this._sha1 != null) {
            this._sha1.update(by);
        }
    }

    public void update(int n) {
        byte by = n > 127 ? (byte)(n - 256) : (byte)n;
        this.update(by);
    }

    public void update(byte[] byArray) {
        this._crc32.update(byArray);
        if (this._md5 != null) {
            this._md5.update(byArray);
        }
        if (this._sha1 != null) {
            this._sha1.update(byArray);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        this._crc32.update(byArray, n, n2);
        if (this._md5 != null) {
            this._md5.update(byArray, n, n2);
        }
        if (this._sha1 != null) {
            this._sha1.update(byArray, n, n2);
        }
    }

    public String getCRC32() {
        return this.padLeadingZeroes(Long.toHexString(this._crc32.getValue()), 8);
    }

    public String getMD5() {
        String string = null;
        if (this._md5 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = this._md5.digest();
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] >= 0 ? byArray[i] : 256 + byArray[i];
                stringBuffer.append(this.padLeadingZeroes(Integer.toHexString(n), 2));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String getSHA1() {
        String string = null;
        if (this._sha1 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = this._sha1.digest();
            for (int i = 0; i < byArray.length; ++i) {
                int n = byArray[i] >= 0 ? byArray[i] : 256 + byArray[i];
                stringBuffer.append(this.padLeadingZeroes(Integer.toHexString(n), 2));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String padLeadingZeroes(String string, int n) {
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }
}

