/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ImageHeaderBox
extends JP2Box {
    public ImageHeaderBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    public boolean readBox() throws IOException {
        int n;
        int n2;
        int n3;
        NisoImageMetadata nisoImageMetadata;
        if (!(this._parentBox instanceof JP2HeaderBox)) {
            this._repInfo.setMessage((Message)new ErrorMessage("ImageHeader Box in illegal context", this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        if (this._boxHeader.getLength() != 22L) {
            this._repInfo.setMessage((Message)new ErrorMessage("Image Header Box is incorrect size", this._module.getFilePos()));
            this._repInfo.setWellFormed(false);
            return false;
        }
        if (this._parentBox instanceof CodestreamHeaderBox) {
            Codestream codestream = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            nisoImageMetadata = codestream.getNiso();
        } else {
            nisoImageMetadata = this._module.getDefaultNiso();
        }
        long l = this._module.readUnsignedInt(this._dstrm);
        nisoImageMetadata.setImageLength(l);
        long l2 = this._module.readUnsignedInt(this._dstrm);
        nisoImageMetadata.setImageWidth(l2);
        int n4 = this._module.readUnsignedShort(this._dstrm);
        nisoImageMetadata.setSamplesPerPixel(n4);
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        if (n5 != 255) {
            int[] nArray = new int[n4];
            n3 = (n5 & 0x7F) + 1;
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n2] = n3;
            }
            nisoImageMetadata.setBitsPerSample(nArray);
        }
        if ((n = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module)) == 7) {
            nisoImageMetadata.setCompressionScheme(34712);
        }
        this._module.addProperty(new Property("ColorspaceUnknown", PropertyType.BOOLEAN, (Object)new Boolean((n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module)) != 0)));
        n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        this.finalizeBytesRead();
        this._module.setImageHeaderSeen(true);
        return true;
    }

    protected String getSelfPropName() {
        return "Image Header Box";
    }
}

