/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXF
extends TiffFXBase {
    public TiffProfileFXF() {
        this._profileText = "TIFF-FX (Profile F)";
        this._mimeClass = 1;
    }

    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        if (!this.satisfiesClass(tiffIFD)) {
            return false;
        }
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{3, 4})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tiffIFD, new int[]{1, 2})) {
            return false;
        }
        if (nisoImageMetadata.getCompressionScheme() == 4 && tiffIFD.getT6Options() != 0L) {
            return false;
        }
        boolean bl = false;
        long l = nisoImageMetadata.getXSamplingFrequency().toLong();
        long l2 = nisoImageMetadata.getYSamplingFrequency().toLong();
        if (nisoImageMetadata.getSamplingFrequencyUnit() == 3) {
            l = this.perCMtoPerInch((int)l);
            l2 = this.perCMtoPerInch((int)l2);
        }
        long l3 = nisoImageMetadata.getImageWidth();
        if ((l == 200L && l2 == 100L || l == 204L && l2 == 98L || l == 200L && l2 == 200L || l == 204L && l2 == 196L || l == 204L && l2 == 391L) && (l3 == 1728L || l3 == 2048L || l3 == 2432L)) {
            bl = true;
        }
        if (l == 300L && l2 == 300L && (l3 == 2592L || l3 == 3072L || l3 == 3648L)) {
            bl = true;
        }
        if ((l == 408L && l2 == 391L || l == 400L && l2 == 400L) && (l3 == 3456L || l3 == 4096L || l3 == 4864L)) {
            bl = true;
        }
        return bl;
    }
}

