/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import uk.gov.nationalarchives.droid.command.action.CommandExecutionException;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.i18n.I18N;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalConfig;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileException;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureFileInfo;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureManager;
import uk.gov.nationalarchives.droid.core.interfaces.signature.SignatureType;

public class ConfigureDefaultSignatureFileVersionCommand
implements DroidCommand {
    private static Map<SignatureType, DroidGlobalProperty> mapping = new HashMap<SignatureType, DroidGlobalProperty>();
    private PrintWriter printWriter;
    private SignatureManager signatureManager;
    private DroidGlobalConfig globalConfig;
    private int signatureFileVersion;
    private SignatureType type;

    @Override
    public void execute() throws CommandExecutionException {
        boolean validVersion = false;
        Map<SignatureType, SortedMap<String, SignatureFileInfo>> sigFileInfos = this.signatureManager.getAvailableSignatureFiles();
        Map sigFileInfoForType = sigFileInfos.get((Object)this.type);
        for (Map.Entry entry : sigFileInfoForType.entrySet()) {
            String key = (String)entry.getKey();
            SignatureFileInfo info = (SignatureFileInfo)entry.getValue();
            if (info.getVersion() != this.signatureFileVersion) continue;
            validVersion = true;
            this.updateDefaultVersion(key);
            break;
        }
        if (!validVersion) {
            throw new CommandExecutionException(I18N.getResource("signature.configure_default.invalid", this.signatureFileVersion));
        }
    }

    private void updateDefaultVersion(String key) throws CommandExecutionException {
        PropertiesConfiguration properties = this.globalConfig.getProperties();
        properties.setProperty(mapping.get((Object)this.type).getName(), (Object)key);
        try {
            properties.save();
            SignatureFileInfo sigFileInfo = this.signatureManager.getDefaultSignatures().get((Object)this.type);
            this.printWriter.println(I18N.getResource("signature.configure_default.success", sigFileInfo.getVersion(), sigFileInfo.getFile().getName()));
        }
        catch (ConfigurationException e) {
            throw new CommandExecutionException(e);
        }
        catch (SignatureFileException e) {
            throw new CommandExecutionException(e);
        }
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.printWriter = printWriter;
    }

    public void setSignatureManager(SignatureManager signatureManager) {
        this.signatureManager = signatureManager;
    }

    public void setGlobalConfig(DroidGlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void setSignatureFileVersion(int signatureFileVersion) {
        this.signatureFileVersion = signatureFileVersion;
    }

    public void setType(SignatureType type) {
        this.type = type;
    }

    static {
        mapping.put(SignatureType.BINARY, DroidGlobalProperty.DEFAULT_BINARY_SIG_FILE_VERSION);
        mapping.put(SignatureType.CONTAINER, DroidGlobalProperty.DEFAULT_CONTAINER_SIG_FILE_VERSION);
        mapping.put(SignatureType.TEXT, DroidGlobalProperty.DEFAULT_TEXT_SIG_FILE_VERSION);
    }
}

