/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class LazyOutputSocket<E extends Entry>
extends DecoratingOutputSocket<E> {
    public LazyOutputSocket(@NonNull OutputSocket<? extends E> output) {
        super(output);
    }

    @Override
    public OutputStream newOutputStream() throws IOException {
        return new ProxyOutputStream();
    }

    @NotThreadSafe
    private class ProxyOutputStream
    extends DecoratingOutputStream {
        ProxyOutputStream() {
            super(null);
        }

        OutputStream getOutputStream() throws IOException {
            return null != this.delegate ? this.delegate : (this.delegate = LazyOutputSocket.this.getBoundSocket().newOutputStream());
        }

        @Override
        public void write(int b) throws IOException {
            this.getOutputStream().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.getOutputStream().write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            if (null != this.delegate) {
                this.delegate.close();
            }
        }
    }
}

