/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence.searcher;

import net.domesdaybook.matcher.sequence.SequenceMatcher;
import net.domesdaybook.matcher.sequence.searcher.SequenceMatcherSearcher;
import net.domesdaybook.matcher.singlebyte.SingleByteMatcher;
import net.domesdaybook.reader.ByteReader;

public final class BoyerMooreHorspoolSearcher
extends SequenceMatcherSearcher {
    private int[] shiftForwardFunction;
    private int[] shiftBackwardFunction;
    private SingleByteMatcher firstSingleMatcher;
    private SingleByteMatcher lastSingleMatcher;

    public BoyerMooreHorspoolSearcher(SequenceMatcher matcher) {
        super(matcher);
        this.getForwardShifts();
        this.getBackwardShifts();
    }

    @Override
    public final long searchForwards(ByteReader reader, long fromPosition, long toPosition) {
        long matchPosition;
        byte lastByte;
        int[] safeShifts = this.getForwardShifts();
        SingleByteMatcher lastMatcher = this.lastSingleMatcher;
        int lastBytePositionInSequence = this.matcher.length() - 1;
        boolean matchFound = false;
        for (matchPosition = fromPosition; matchPosition <= toPosition; matchPosition += (long)safeShifts[lastByte & 0xFF]) {
            lastByte = reader.readByte(matchPosition);
            while (!lastMatcher.matches(lastByte) && (matchPosition += (long)safeShifts[lastByte & 0xFF]) <= toPosition) {
                lastByte = reader.readByte(matchPosition);
            }
            if (matchPosition <= toPosition && (matchFound = this.matcher.matches(reader, matchPosition - (long)lastBytePositionInSequence))) break;
        }
        return matchFound ? matchPosition : -1L;
    }

    @Override
    public final long searchBackwards(ByteReader reader, long fromPosition, long toPosition) {
        long matchPosition;
        byte firstByte;
        int[] safeShifts = this.getBackwardShifts();
        SingleByteMatcher firstMatcher = this.firstSingleMatcher;
        boolean matchFound = false;
        for (matchPosition = fromPosition; matchPosition >= toPosition; matchPosition += (long)safeShifts[firstByte & 0xFF]) {
            firstByte = reader.readByte(matchPosition);
            while (!firstMatcher.matches(firstByte) && (matchPosition += (long)safeShifts[firstByte & 0xFF]) >= toPosition) {
                firstByte = reader.readByte(matchPosition);
            }
            if (matchPosition >= toPosition && (matchFound = this.matcher.matches(reader, matchPosition))) break;
        }
        return matchFound ? matchPosition : -1L;
    }

    private int[] getForwardShifts() {
        if (this.shiftForwardFunction == null) {
            this.calculateForwardShifts();
            this.lastSingleMatcher = this.matcher.getByteMatcherForPosition(this.matcher.length() - 1);
        }
        return this.shiftForwardFunction;
    }

    private int[] getBackwardShifts() {
        if (this.shiftBackwardFunction == null) {
            this.calculateBackwardShifts();
            this.firstSingleMatcher = this.matcher.getByteMatcherForPosition(0);
        }
        return this.shiftBackwardFunction;
    }

    private void calculateBackwardShifts() {
        int[] shifts = this.shiftBackwardFunction = new int[256];
        int numBytes = this.matcher.length();
        int defaultShift = numBytes * -1;
        for (int charValueIndex = 255; charValueIndex >= 0; --charValueIndex) {
            shifts[charValueIndex] = defaultShift;
        }
        for (int sequenceByteIndex = numBytes - 1; sequenceByteIndex > 0; --sequenceByteIndex) {
            SingleByteMatcher aMatcher = this.matcher.getByteMatcherForPosition(sequenceByteIndex);
            byte[] matchingBytes = aMatcher.getMatchingBytes();
            for (int byteIndex = 0; byteIndex < matchingBytes.length; ++byteIndex) {
                int byteSequenceValue = matchingBytes[byteIndex] & 0xFF;
                shifts[byteSequenceValue] = -sequenceByteIndex;
            }
        }
    }

    private void calculateForwardShifts() {
        int numBytes;
        int[] shifts = this.shiftForwardFunction = new int[256];
        int defaultShift = numBytes = this.matcher.length();
        for (int charValueIndex = 255; charValueIndex >= 0; --charValueIndex) {
            shifts[charValueIndex] = defaultShift;
        }
        for (int sequenceByteIndex = 0; sequenceByteIndex < numBytes - 1; ++sequenceByteIndex) {
            SingleByteMatcher aMatcher = this.matcher.getByteMatcherForPosition(sequenceByteIndex);
            byte[] matchingBytes = aMatcher.getMatchingBytes();
            for (int byteIndex = 0; byteIndex < matchingBytes.length; ++byteIndex) {
                int byteSequenceValue = matchingBytes[byteIndex] & 0xFF;
                shifts[byteSequenceValue] = numBytes - sequenceByteIndex - 1;
            }
        }
    }
}

