/*
 * Decompiled with CFR 0.152.
 */
package net.domesdaybook.matcher.sequence.searcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WuManberSearch {
    private int shortestPatternLength = 0;
    private int shiftTableSize = 0;
    private int shiftTableHashBitMask = 0;
    private int verifierTableSize = 0;
    private int blockSize = 1;
    private int[] shifts;
    private Map<String, List<String>> verifiers;

    public WuManberSearch(List<String> patterns) {
        this.compile(patterns);
    }

    public WuManberSearch(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(pattern);
        this.compile(patterns);
    }

    public void compile(List<String> patterns) {
        this.calculateParameters(patterns);
        this.buildTables(patterns);
    }

    public List<MatchResult> find(String text, searchType type) {
        return this.findFrom(text, 0, type);
    }

    public List<MatchResult> findFrom(String text, int fromPosition, searchType type) {
        return this.findWithin(text, fromPosition, text.length(), type);
    }

    public List<MatchResult> findWithin(String text, int fromPosition, int toPosition, searchType type) {
        if (fromPosition >= text.length() || toPosition >= text.length()) {
            throw new IllegalArgumentException("Search positions outside length of text.");
        }
        if (fromPosition > toPosition) {
            throw new IllegalArgumentException("Search from position greater than to position.");
        }
        return this.search(text, fromPosition, toPosition, type);
    }

    private List<MatchResult> search(String text, int fromPosition, int toPosition, searchType type) {
        ArrayList<MatchResult> result = new ArrayList<MatchResult>();
        int pos = fromPosition + this.shortestPatternLength - 1;
        while (pos <= toPosition) {
            String textBlock = text.substring(pos - this.blockSize + 1, pos + 1);
            int shiftValue = this.shifts[this.getBlockHash(textBlock)];
            if (shiftValue == 0) {
                List<MatchResult> matches = this.verifyMatches(text, pos, this.verifiers.get(textBlock));
                if (matches.size() > 0) {
                    result.addAll(matches);
                    if (type == searchType.FIND_NEXT) break;
                }
                ++pos;
                continue;
            }
            pos += shiftValue;
        }
        return result;
    }

    private List<MatchResult> verifyMatches(String text, int pos, List<String> possibleMatches) {
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>();
        for (String match : possibleMatches) {
            int matchLength = match.length();
            int matchStart = pos - matchLength + 1;
            if (!text.regionMatches(matchStart, match, 0, matchLength)) continue;
            matches.add(new MatchResult(matchStart, match));
        }
        return matches;
    }

    private void calculateParameters(List<String> patterns) {
        this.shortestPatternLength = this.getShortestPatternLength(patterns);
        this.blockSize = this.calculateBlockSize(patterns);
        this.shiftTableSize = 1 << this.calculateShiftTablePowerTwoSize(patterns);
        this.shiftTableHashBitMask = this.shiftTableSize - 1;
        this.verifierTableSize = this.calculateVerifierTableSize(patterns);
    }

    private void buildTables(List<String> patterns) {
        this.shifts = new int[this.shiftTableSize];
        this.verifiers = new HashMap<String, List<String>>(this.verifierTableSize);
        this.initialiseDefaultShift();
        for (String pattern : patterns) {
            int patternLength = pattern.length();
            String block = "";
            for (int blockIndex = this.blockSize; blockIndex <= patternLength; ++blockIndex) {
                block = pattern.substring(blockIndex - this.blockSize, blockIndex);
                int hashValue = this.getBlockHash(block);
                int shiftValue = patternLength - blockIndex;
                this.shifts[hashValue] = Math.min(this.shifts[hashValue], shiftValue);
            }
            this.addVerifier(block, pattern);
        }
    }

    private void initialiseDefaultShift() {
        int defaultShift = this.shortestPatternLength - this.blockSize + 1;
        Arrays.fill(this.shifts, defaultShift);
    }

    private void addVerifier(String block, String pattern) {
        List<String> verifiersForBlock = this.verifiers.get(block);
        if (verifiersForBlock == null) {
            verifiersForBlock = new ArrayList<String>();
            this.verifiers.put(block, verifiersForBlock);
        }
        verifiersForBlock.add(pattern);
    }

    private int getBlockHash(String block) {
        return block.hashCode() & this.shiftTableHashBitMask;
    }

    private int getShortestPatternLength(List<String> patterns) {
        int shortestLength = Integer.MAX_VALUE;
        for (String pattern : patterns) {
            shortestLength = Math.min(shortestLength, pattern.length());
        }
        return shortestLength;
    }

    private int calculateBlockSize(List<String> patterns) {
        return this.shortestPatternLength > 1 ? 2 : 1;
    }

    private int calculateShiftTablePowerTwoSize(List<String> patterns) {
        return 12;
    }

    private int calculateVerifierTableSize(List<String> patterns) {
        return 1024;
    }

    public class MatchResult {
        private long matchPosition;
        private String matchingPattern;

        public MatchResult(long matchPosition, String matchingPattern) {
            this.matchPosition = matchPosition;
            this.matchingPattern = matchingPattern;
        }

        public long getMatchPosition() {
            return this.matchPosition;
        }

        public String getMatchingPattern() {
            return this.matchingPattern;
        }
    }

    public static enum searchType {
        FIND_ALL,
        FIND_NEXT;

    }
}

