/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.control;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import uk.gov.nationalarchives.droid.core.interfaces.control.ThreadWaitingHandler;

@Aspect
public class PauseAspect {
    private boolean isPaused;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition unpaused = this.pauseLock.newCondition();
    private ThreadWaitingHandler threadWaitingHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before(value="@annotation(uk.gov.nationalarchives.droid.core.interfaces.control.PauseBefore)")
    @After(value="@annotation(uk.gov.nationalarchives.droid.core.interfaces.control.PauseAfter)")
    public void awaitUnpaused() {
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.threadWaitingHandler.onThreadWaiting();
                this.unpaused.awaitUninterruptibly();
            }
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void setThreadWaitingHandler(ThreadWaitingHandler threadWaitingHandler) {
        this.threadWaitingHandler = threadWaitingHandler;
    }
}

