/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Map;
import net.domesdaybook.reader.ByteReader;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.collections.map.LazyMap;
import uk.gov.nationalarchives.droid.core.interfaces.resource.CachedBytes;

public final class CachedByteBuffers
implements ByteReader,
CachedBytes {
    private static final String READ_ONLY = "r";
    private final Map<Long, ByteBuffer> cache;
    private File source;
    private RandomAccessFile raf;
    private final int bufferCapacity;
    private FileChannel channel;
    private long currentBufferStart;
    private long currentBufferEnd;
    private ByteBuffer currentBuffer;

    public CachedByteBuffers(int blocks, int blockCapacity, ByteBuffer blockZero) {
        this.cache = LazyMap.decorate((Map)new LRUMap(blocks), (Transformer)new CacheTransformer());
        this.bufferCapacity = blockCapacity;
        blockZero.flip();
        this.cache.put(0L, blockZero);
        this.currentBuffer = blockZero;
        this.currentBufferStart = 0L;
        this.currentBufferEnd = this.bufferCapacity - 1;
    }

    @Override
    public void setSourceFile(File sourceFile) throws FileNotFoundException {
        this.source = sourceFile;
        this.raf = new RandomAccessFile(this.source, READ_ONLY);
        this.channel = this.raf.getChannel();
    }

    public byte readByte(long position) {
        if (position > this.currentBufferEnd || position < this.currentBufferStart) {
            long blockStart = position - position % (long)this.bufferCapacity;
            this.currentBuffer = this.cache.get(blockStart);
            this.currentBufferStart = blockStart;
            this.currentBufferEnd = blockStart + (long)this.bufferCapacity - 1L;
        }
        return this.currentBuffer.get((int)(position - this.currentBufferStart));
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    Map<Long, ByteBuffer> getBuffers() {
        return this.cache;
    }

    RandomAccessFile getRaf() {
        return this.raf;
    }

    @Override
    public InputStream getSourceInputStream() throws IOException {
        InputStream in;
        if (this.raf == null) {
            ByteBuffer blockZero = this.cache.get(0L);
            blockZero.rewind();
            byte[] bytes = new byte[blockZero.limit()];
            blockZero.get(bytes);
            in = new ByteArrayInputStream(bytes);
        } else {
            RandomAccessFile newRaf = new RandomAccessFile(this.source, READ_ONLY);
            FileChannel chan = newRaf.getChannel();
            chan.position(0L);
            in = Channels.newInputStream(chan);
        }
        return in;
    }

    @Override
    public File getSourceFile() {
        return this.source;
    }

    private final class CacheTransformer
    implements Transformer {
        private CacheTransformer() {
        }

        public Object transform(Object input) {
            Long block = (Long)input;
            try {
                ByteBuffer buffer = ByteBuffer.allocate(CachedByteBuffers.this.bufferCapacity);
                CachedByteBuffers.this.raf.seek(block);
                CachedByteBuffers.this.channel.read(buffer);
                buffer.flip();
                return buffer;
            }
            catch (IOException e) {
                String message = "Error reading from file into CachedByteArray.";
                throw new FunctorException("Error reading from file into CachedByteArray.", (Throwable)e);
            }
        }
    }
}

