/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.command.action;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import uk.gov.nationalarchives.droid.command.FilterFieldCommand;
import uk.gov.nationalarchives.droid.command.action.CheckSignatureUpdateCommand;
import uk.gov.nationalarchives.droid.command.action.CommandFactory;
import uk.gov.nationalarchives.droid.command.action.CommandLineException;
import uk.gov.nationalarchives.droid.command.action.CommandLineParam;
import uk.gov.nationalarchives.droid.command.action.CommandLineSyntaxException;
import uk.gov.nationalarchives.droid.command.action.ConfigureDefaultSignatureFileVersionCommand;
import uk.gov.nationalarchives.droid.command.action.DisplayDefaultSignatureFileVersionCommand;
import uk.gov.nationalarchives.droid.command.action.DownloadSignatureUpdateCommand;
import uk.gov.nationalarchives.droid.command.action.DroidCommand;
import uk.gov.nationalarchives.droid.command.action.ExportCommand;
import uk.gov.nationalarchives.droid.command.action.HelpCommand;
import uk.gov.nationalarchives.droid.command.action.ListAllSignatureFilesCommand;
import uk.gov.nationalarchives.droid.command.action.ListReportsCommand;
import uk.gov.nationalarchives.droid.command.action.NoProfileRunCommand;
import uk.gov.nationalarchives.droid.command.action.ProfileRunCommand;
import uk.gov.nationalarchives.droid.command.action.ReportCommand;
import uk.gov.nationalarchives.droid.command.action.VersionCommand;
import uk.gov.nationalarchives.droid.command.context.GlobalContext;
import uk.gov.nationalarchives.droid.command.filter.CommandLineFilter;
import uk.gov.nationalarchives.droid.export.interfaces.ExportOptions;

public class CommandFactoryImpl
implements CommandFactory {
    private static final String NO_RESOURCES_SPECIFIED = "No resources specified.";
    private static final String NO_PROFILES_SPECIFIED_FOR_EXPORT = "No profiles specified for export.";
    private GlobalContext context;
    private PrintWriter printWriter;

    public CommandFactoryImpl(GlobalContext context, PrintWriter printWriter) {
        this.context = context;
        this.printWriter = printWriter;
    }

    @Override
    public DroidCommand getExportFileCommand(CommandLine cli) throws CommandLineSyntaxException {
        if (!cli.hasOption(CommandLineParam.PROFILES.toString())) {
            throw new CommandLineSyntaxException(NO_PROFILES_SPECIFIED_FOR_EXPORT);
        }
        String destination = cli.getOptionValue(CommandLineParam.EXPORT_ONE_ROW_PER_FILE.toString());
        String[] profiles = cli.getOptionValues(CommandLineParam.PROFILES.toString());
        ExportCommand cmd = this.context.getExportCommand(ExportOptions.ONE_ROW_PER_FILE);
        cmd.setDestination(destination);
        cmd.setProfiles(profiles);
        if (cli.hasOption(CommandLineParam.ALL_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ALL_FILTER.toString()), CommandLineFilter.FilterType.ALL));
        }
        if (cli.hasOption(CommandLineParam.ANY_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ANY_FILTER.toString()), CommandLineFilter.FilterType.ANY));
        }
        return cmd;
    }

    @Override
    public DroidCommand getExportFormatCommand(CommandLine cli) throws CommandLineSyntaxException {
        if (!cli.hasOption(CommandLineParam.PROFILES.toString())) {
            throw new CommandLineSyntaxException(NO_PROFILES_SPECIFIED_FOR_EXPORT);
        }
        String destination = cli.getOptionValue(CommandLineParam.EXPORT_ONE_ROW_PER_FORMAT.toString());
        String[] profiles = cli.getOptionValues(CommandLineParam.PROFILES.toString());
        ExportCommand cmd = this.context.getExportCommand(ExportOptions.ONE_ROW_PER_FORMAT);
        cmd.setDestination(destination);
        cmd.setProfiles(profiles);
        if (cli.hasOption(CommandLineParam.ALL_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ALL_FILTER.toString()), CommandLineFilter.FilterType.ALL));
        }
        if (cli.hasOption(CommandLineParam.ANY_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ANY_FILTER.toString()), CommandLineFilter.FilterType.ANY));
        }
        return cmd;
    }

    @Override
    public DroidCommand getReportCommand(CommandLine cli) throws CommandLineSyntaxException {
        if (!cli.hasOption(CommandLineParam.PROFILES.toString())) {
            throw new CommandLineSyntaxException("No profiles specified for report.");
        }
        if (!cli.hasOption(CommandLineParam.REPORT_NAME.toString())) {
            throw new CommandLineSyntaxException("No name specified for report.");
        }
        String reportType = cli.getOptionValue(CommandLineParam.REPORT_NAME.toString());
        String reportOutputType = cli.getOptionValue(CommandLineParam.REPORT_OUTPUT_TYPE.toString());
        reportOutputType = reportOutputType == null ? "pdf" : reportOutputType;
        String destination = cli.getOptionValue(CommandLineParam.REPORT.toString());
        String[] profiles = cli.getOptionValues(CommandLineParam.PROFILES.toString());
        ReportCommand cmd = this.context.getReportCommand();
        cmd.setDestination(destination);
        cmd.setProfiles(profiles);
        cmd.setReportType(reportType);
        cmd.setReportOutputType(reportOutputType);
        if (cli.hasOption(CommandLineParam.ALL_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ALL_FILTER.toString()), CommandLineFilter.FilterType.ALL));
        }
        if (cli.hasOption(CommandLineParam.ANY_FILTER.toString())) {
            cmd.setFilter(new CommandLineFilter(cli.getOptionValues(CommandLineParam.ANY_FILTER.toString()), CommandLineFilter.FilterType.ANY));
        }
        return cmd;
    }

    @Override
    public FilterFieldCommand getFilterFieldCommand() {
        return new FilterFieldCommand(this.printWriter);
    }

    @Override
    public DroidCommand getHelpCommand() {
        return new HelpCommand(this.printWriter);
    }

    @Override
    public DroidCommand getVersionCommand() {
        return new VersionCommand(this.printWriter);
    }

    @Override
    public DroidCommand getProfileCommand(CommandLine cli) throws CommandLineSyntaxException {
        String[] resources = cli.getOptionValues(CommandLineParam.RUN_PROFILE.toString());
        if (resources.length == 0) {
            throw new CommandLineSyntaxException(NO_RESOURCES_SPECIFIED);
        }
        String[] destination = cli.getOptionValues(CommandLineParam.PROFILES.toString());
        if (destination == null || destination.length > 1) {
            throw new CommandLineSyntaxException("Must specify exactly one profile.");
        }
        ProfileRunCommand command = this.context.getProfileRunCommand();
        command.setDestination(destination[0]);
        command.setResources(resources);
        command.setRecursive(cli.hasOption(CommandLineParam.RECURSIVE.toString()));
        return command;
    }

    @Override
    public DroidCommand getNoProfileCommand(CommandLine cli) throws CommandLineSyntaxException {
        String[] resources = cli.getOptionValues(CommandLineParam.RUN_NO_PROFILE.toString());
        if (resources.length == 0) {
            throw new CommandLineSyntaxException(NO_RESOURCES_SPECIFIED);
        }
        if (!cli.hasOption(CommandLineParam.SIGNATURE_FILE.toString())) {
            throw new CommandLineSyntaxException("No signature file specified.");
        }
        String signatureFile = cli.getOptionValue(CommandLineParam.SIGNATURE_FILE.toString());
        String containerSignatureFile = cli.getOptionValue(CommandLineParam.CONTAINER_SIGNATURE_FILE.toString());
        String[] extensions = cli.getOptionValues(CommandLineParam.EXTENSION_LIST.toString());
        NoProfileRunCommand command = this.context.getNoProfileRunCommand();
        command.setResources(resources);
        command.setSignatureFile(signatureFile);
        command.setContainerSignatureFile(containerSignatureFile);
        command.setRecursive(cli.hasOption(CommandLineParam.RECURSIVE.toString()));
        command.setArchives(cli.hasOption(CommandLineParam.ARCHIVES.toString()));
        command.setExtensionFilter(extensions);
        command.setQuiet(cli.hasOption(CommandLineParam.QUIET.toString()));
        return command;
    }

    @Override
    public DroidCommand getCheckSignatureUpdateCommand() {
        CheckSignatureUpdateCommand command = this.context.getCheckSignatureUpdateCommand();
        command.setPrintWriter(this.printWriter);
        return command;
    }

    @Override
    public DroidCommand getDownloadSignatureUpdateCommand() {
        DownloadSignatureUpdateCommand command = this.context.getDownloadSignatureUpdateCommand();
        command.setPrintWriter(this.printWriter);
        return command;
    }

    @Override
    public DroidCommand getDisplayDefaultSignatureVersionCommand() {
        DisplayDefaultSignatureFileVersionCommand command = this.context.getDisplayDefaultSignatureFileVersionCommand();
        command.setPrintWriter(this.printWriter);
        return command;
    }

    @Override
    public DroidCommand getConfigureDefaultSignatureVersionCommand(CommandLine cli) throws CommandLineException {
        String newVersion = cli.getOptionValue(CommandLineParam.CONFIGURE_DEFAULT_SIGNATURE_VERSION.toString());
        ConfigureDefaultSignatureFileVersionCommand command = this.context.getConfigureDefaultSignatureFileVersionCommand();
        command.setPrintWriter(this.printWriter);
        try {
            command.setSignatureFileVersion(Integer.parseInt(StringUtils.trimToEmpty((String)newVersion)));
            return command;
        }
        catch (NumberFormatException e) {
            throw new CommandLineSyntaxException("Invalid version: " + newVersion);
        }
    }

    @Override
    public DroidCommand getListAllSignatureVersionsCommand() {
        ListAllSignatureFilesCommand command = this.context.getListAllSignatureFilesCommand();
        command.setPrintWriter(this.printWriter);
        return command;
    }

    @Override
    public DroidCommand getListReportCommand() {
        ListReportsCommand command = this.context.getListReportsCommand();
        command.setPrintWriter(this.printWriter);
        return command;
    }
}

