/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.Executor;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.LegacyExecutor;
import de.schlichtherle.io.Task;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class Streams {
    private static final Executor readerExecutor = Streams.getExecutor("TrueZIP InputStream Reader");

    protected Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException();
        }
        Buffer[] buffers = Streams.allocateBuffers();
        try {
            class Reader
            implements Runnable {
                int off;
                int len;
                volatile InputIOException exception;
                private final /* synthetic */ InputStream val$in;
                private final /* synthetic */ Buffer[] val$buffers;

                Reader(InputStream inputStream, Buffer[] bufferArray) {
                    this.val$in = inputStream;
                    this.val$buffers = bufferArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int read;
                    InputStream _in = this.val$in;
                    Buffer[] _buffers = this.val$buffers;
                    int _buffersLen = this.val$buffers.length;
                    do {
                        Buffer buffer;
                        Reader reader = this;
                        synchronized (reader) {
                            while (this.len >= _buffersLen) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interrupted) {
                                    return;
                                }
                            }
                            buffer = _buffers[(this.off + this.len) % _buffersLen];
                        }
                        byte[] buf = buffer.buf;
                        try {
                            read = _in.read(buf, 0, buf.length);
                        }
                        catch (IOException ex) {
                            this.exception = new InputIOException(ex);
                            read = -1;
                        }
                        buffer.read = read;
                        Reader reader2 = this;
                        synchronized (reader2) {
                            ++this.len;
                            this.notify();
                        }
                    } while (read != -1);
                }
            }
            Reader reader = new Reader(in, buffers);
            Task task = readerExecutor.submit(reader);
            int buffersLen = buffers.length;
            while (true) {
                Buffer buffer;
                int off;
                Reader reader2 = reader;
                synchronized (reader2) {
                    while (reader.len <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    off = reader.off;
                    buffer = buffers[off];
                }
                int write = buffer.read;
                if (write == -1) break;
                byte[] buf = buffer.buf;
                try {
                    out.write(buf, 0, write);
                }
                catch (IOException ex) {
                    task.cancel();
                    throw ex;
                }
                Reader reader3 = reader;
                synchronized (reader3) {
                    reader.off = (off + 1) % buffersLen;
                    --reader.len;
                    reader.notify();
                }
            }
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            Streams.releaseBuffers(buffers);
        }
    }

    private static Executor getExecutor(String threadName) {
        try {
            Class<?> cl = Class.forName("de.schlichtherle.io.JSE5Executor");
            Constructor<?> co = cl.getConstructor(String.class);
            return (Executor)co.newInstance(threadName);
        }
        catch (Throwable ex) {
            return new LegacyExecutor(threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Buffer[] allocateBuffers() {
        List list = Buffer.list;
        synchronized (list) {
            Iterator i = Buffer.list.iterator();
            while (i.hasNext()) {
                Buffer[] buffers = (Buffer[])((Reference)i.next()).get();
                i.remove();
                if (buffers == null) continue;
                return buffers;
            }
        }
        Buffer[] buffers = new Buffer[4];
        int i = buffers.length;
        while (--i >= 0) {
            buffers[i] = new Buffer();
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseBuffers(Buffer[] buffers) {
        List list = Buffer.list;
        synchronized (list) {
            Buffer.list.add(new SoftReference<Buffer[]>(buffers));
        }
    }

    private static class Buffer {
        static final List list = new LinkedList();
        byte[] buf = new byte[65536];
        int read;

        private Buffer() {
        }
    }
}

