/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.out;
/**
 *
 */


import java.awt.BorderLayout;
import java.io.*;

import javax.swing.*;


/**
 * @author denis
 *
 *		If the SystemOutRedirectionTarget just implements the interface SystemOutRedirectionTarget, use this:
 *			SystemOutRedirector.install(new SystemOutRedirectionTargetExample());
 *
 *		If the SystemOutRedirectionTarget is a subclass of SystemOutRedirectionTargetAbstract, use this:
 *			new SystemOutRedirectionTargetExampleFile().install();
 *
 */
public class SystemOutRedirector extends FilterOutputStream
{

	private static PrintStream				Out;
	private static PrintStream				Err;


	private SystemOutRedirectionTarget		target;


	/**
	 * For Testing.
	 *
	 * @param args
	 */
	public static void main(String[] args)
	{
		System.out.println("0.1");
		System.out.println("0.2");
		System.out.println("0.3");

		try
		{
			throw new RuntimeException("X0");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}

		new SystemOutRedirectionTargetExampleFile().install();

		System.out.println("1.1");
		System.out.println("1.2");
		System.out.println("1.3");

		try
		{
			throw new RuntimeException("X1");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}

		SystemOutRedirectionTargetExampleFile.uninstall();

		System.out.println("2.1");
		System.out.println("2.2");
		System.out.println("2.3");

		try
		{
			throw new RuntimeException("X2");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}

		new SystemOutRedirectionTargetExampleTextArea().install();

		System.out.println("3.1");
		System.out.println("3.2");
		System.out.println("3.3");

		try
		{
			throw new RuntimeException("X3");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}

		SystemOutRedirectionTargetExampleTextArea.uninstall();

		System.out.println("4.1");
		System.out.println("4.2");
		System.out.println("4.3");

		try
		{
			throw new RuntimeException("X4");
		}
		catch (RuntimeException x)
		{
			x.printStackTrace();
		}
	}


	private SystemOutRedirector(SystemOutRedirectionTarget target)
	{
		super(new ByteArrayOutputStream());
		this.target = target;

		Out = System.out;
		Err = System.err;

		System.setOut(new PrintStream(this));
		System.setErr(new PrintStream(this));
	}


	@SuppressWarnings("resource")
	public static void install(SystemOutRedirectionTarget target)
	{
		new SystemOutRedirector(target);

		//	When switching STDOUT and STDERR using System.setOut() and System.setErr(), DOMConfigurator must be reconfigured:
		Logger.reInitialize();
	}


	public static void unInstall()
	{
		System.setOut(Out);
		System.setErr(Err);

		//	When switching STDOUT and STDERR using System.setOut() and System.setErr(), DOMConfigurator must be reconfigured:
		Logger.reInitialize();
	}


	/* Override Ancestor method */
	@Override
	public void write(byte b[])
	{
		String str = new String(b);
		this.write(str);
	}

	/* Override Ancestor method */
	@Override
	public void write(byte b[], int off, int len)
	{
		String str = new String(b, off, len);
		this.write(str);
	}

	/* Override Ancestor method */
	@Override
	public void write(int b)
	{
		String str = new String(new char[] { (char) b});
		this.write(str);
	}


	private void write(String message)
	{
		this.target.write(message);
	}


	private static class SystemOutRedirectionTargetExampleFile extends SystemOutRedirectionTargetAbstract
	{
		static
		{
			LogFile.initializeAppend("temp/LogFile.txt");
		}

		/* (non-Javadoc)
		 * @see doculib.util.SystemOutRedirectionTarget#write(java.lang.String)
		 */
		@Override
		public void write(String string)
		{
			try
			{
				LogFile.write(string);
			}
			catch (IOException e)
			{
				e.printStackTrace();
			}
		}
	}


	private static class SystemOutRedirectionTargetExampleTextArea extends SystemOutRedirectionTargetAbstract
	{
		private static JTextArea textArea = new JTextArea();

		static
		{
			JFrame f = new JFrame();
			f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			f.add(new JScrollPane(textArea), BorderLayout.CENTER);
			f.setSize(300, 200);
			f.setLocationRelativeTo(null);
			f.setVisible(true);
		}

		/* (non-Javadoc)
		 * @see doculib.util.SystemOutRedirectionTarget#write(java.lang.String)
		 */
		@Override
		public void write(String string)
		{
			textArea.append(string);
		}
	}

}
