/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.string;
/**
 * 
 */


import java.io.Serializable;

/**
 * This class works close together with <a href="./StringSet.html">StringSet</a>.
 * <p>
 * StringSets define a set of StringSetElements.
 * A corresponding set of StringSetElements is defined by creating a subclass of StringSetElement and specifying in the static initializer its elements
 * (see example <a href="./StringSetElementExample.html">StringSetElementExample</a>).
 * @author denis
 *
 */
@SuppressWarnings("serial")
public abstract class StringSetElement implements Serializable, Comparable<StringSetElement>
{

	private static Integer		CurrentSortValue = 0;


	protected String			value;
	protected Integer			sortOrder;


	protected StringSetElement(String value)
	{
		super();
		this.value = value;
		this.sortOrder = CurrentSortValue++;

		StringSet.add(this);
	}
	

	/**
	 * The key is used as the Map key for this StringSetElement in the class StringSet.
	 * It is very flexible: One can omit or add spaces and non-alphanumeric characters, or change the case, and still the StringSetElement will be found.
	 */
	static String asKey(String value)
	{
		return value.toLowerCase().replaceAll("[_\\s\\W]", "");		//	Keep only alphanumeric characters
	}
	

	public String getValue()
	{
		return this.value;
	}

	
	public String getValueAsKey()
	{
		return asKey(this.value);
	}


	@Override
	public int compareTo(StringSetElement o)
	{
		return this.sortOrder.compareTo(o.sortOrder);
	}

	
	@Override
	public String toString()
	{
		return "[" + this.getClass().getSimpleName() + ":" + this.value + "]";
	}


}
