/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.util;

import java.applet.Applet;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;

import ch.docuteam.tools.string.StringUtil;

/**
 * @author denis
 *
 */
public abstract class Sound
{

	public static void playAIFFile(String filePath) throws FileNotFoundException
	{
		if (!new File(filePath).exists())									throw new FileNotFoundException(filePath);
		if (!StringUtil.last(filePath, 4).toLowerCase().equals(".aif"))		throw new IllegalArgumentException("File must be an .aif file: " + filePath);

		try
		{
			Applet.newAudioClip(new File(filePath).toURI().toURL()).play();
		}
		catch (MalformedURLException ex)
		{
			throw new IllegalArgumentException(ex);
		}
	}

}
