/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.admin;

import java.util.Arrays;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 * 
 * Version 2.18.2:
 * 01.11.2016:
 * exclude file extension from metadata default expressions "extractXXXFromFilename"
 * 28.10.2016:
 * bump to next bugfix release
 * 
 * Version 2.18.1:
 * 28.10.2016:
 * upgrade dependency for docuteam-tools to 1.11.7
 * update node permissions after deletion of file content
 * 26.10.2016:
 * bump to next bugfix release
 * 
 * Version 2.18.0:
 * 26.10.2016:
 * upgrade dependency for docuteam-tools to 1.11.6
 * 24.10.2016:
 * extend interface for ch.docuteam.darc.ingest.AIPCreator to include checkIngestFeedback(String workspaceFolder)
 * bump to next minor release
 * 04.10.2016:
 * bump to next bugfix release
 * 
 * Version 2.17.0:
 * 04.10.2016:
 * upgrade dependency for docuteam-tools to 1.11.5
 * 03.10.2016:
 * remove checkIngestFeedback from mets.Document to become part of AIPCreator implementations
 * set visibility of some constants to public
 * add public getter for currently used levels configuration file
 * 29.09.2016:
 * cleanup AIPCreatorBasic: don't deal with submitStatus, but check metadata (mandatory, levels), various file permissions and _move_ SIP to target directory
 * additional dynamic metadata elements:
 * 		- unitTitleOriginal	EAD:did/EAD:unittitle[@label = 'original']
 * 		- format			EAD:did/EAD:physdesc[@label = 'format']
 * 		- size				EAD:did/EAD:physdesc[@label = 'size']
 * 		- date				EAD:did/EAD:unitdate[@label = 'date']
 * 23.09.2016:
 * bump to next minor release
 * support migration from a file to a folder
 * add public setter methods used by implementations of ch.docuteam.darc.ingest.AIPCreator 
 * 12.09.2016:
 * bump to next bugfix release
 * 
 * Version 2.16.9:
 * 12.09.2016:
 * new default expression for dynamic metadata elements:
 * 		- ch.docuteam.darc.mdconfig.MetadataElementDefaultExpressions.extractDateFromFilename(NodeAbstract)
 * 		- ch.docuteam.darc.mdconfig.MetadataElementDefaultExpressions.extractTitleFromFilename(NodeAbstract)
 * 		- ch.docuteam.darc.mdconfig.MetadataElementDefaultExpressions.extractNotesFromFilename(NodeAbstract)
 * 08.09.2016:
 * bump to next bugfix release
 * 
 * Version 2.16.8:
 * 08.09.2016:
 * fix EAD export to contain missing fields
 * 07.09.2016:
 * bump to next bugfix release
 * 
 * Version 2.16.7:
 * 07.09.2016:
 * additional dynamic metadata elements:
 * 		- cartographicMaterial	EAD:did/EAD:materialspec[@label = 'cartographic']
 * 		- codeLocation			EAD:did/EAD:physloc[@label = 'code']
 * 		- creator				EAD:controlaccess/EAD:persname[@role = 'creator']
 * 		- dimensions			EAD:did/EAD:physdesc/EAD:dimensions
 * 		- DOI					EAD:did/EAD:unitid[@type = 'otherStandardIdentifier']
 * 		- editionStatement		EAD:odd[@type = 'edition']/EAD:p
 * 		- fullLocation			EAD:did/EAD:physloc[@label = 'fullLocation']
 * 		- geogName				EAD:controlaccess/EAD:geogname[@role = 'general']
 * 		- institutionCreator	EAD:controlaccess/EAD:corpname[@role = 'creator']
 * 		- institutionInvolved	EAD:controlaccess/EAD:corpname[@role = 'involved']
 * 		- ISBN					EAD:did/EAD:unitid[@type = 'isbn']
 * 		- ISSN					EAD:did/EAD:unitid[@type = 'issn']
 * 		- placeOfPublication	EAD:controlaccess/EAD:name[@role = 'placeOfPublication']
 * 		- subjectGeneral		EAD:controlaccess/EAD:subject[@role = 'general']
 * 		- uniformTitle			EAD:controlaccess/EAD:title[@type = 'uniform']
 * 		- unitTitleVarying		EAD:did/EAD:unittitle[@label = 'varying']
 * bump to next bugfix release
 * 
 * Version 2.16.6:
 * 08.08.2016 (Andreas):
 * eCH-0160 conversion:
 * 		- properly handle non-mandatory elements
 * 		- allow any labels for intermediate top-level folders within zipped eCH-0160 SIPs
 * 26.07.2016 (Andreas):
 * bump to next bugfix release
 * 
 * Version 2.16.5:
 * 26.07.2016 (Andreas):
 * - upgrade dependency for docuteam-tools to 1.11.4
 * - allow "Erscheinungsform" to be empty in eCH-0160
 * 22.06.2016 (Iliya):
 * additional metadata elements "to" and "from"
 * 15.06.2016 (Iliya):
 * submit in AIPCreatorBasic deletes the original sip now
 * 
 * Version 2.16.4:
 * 10.06.2016 (Andreas):
 * ingest.AIPCreatorBasic:
 * 		- block undefined levels of descriptions
 * 		- check for unsaved changes
 * 01.06.2016 (Andreas/Christian):
 * ingest.*, mets.Document: move submit method to aipcreator interface
 * 30.05.2016 (Iliya):
 * mdconfig.MetadataElementValidatorYYYYMMDD: new validator for dates without months/days
 * 27.05.2016 (Andreas):
 * admin.Version: bump to next bugfix release
 * 
 * Version 2.16.3:
 * 27.05.2016 (Andreas):
 * mets.Document: add logging information for submit through SFTP
 * 24.05.2016 (Andreas):
 * premis.Object: public setter/getter for default checksum algorithm
 * 11.05.2016 (Andreas):
 * admin.Version: bump to next bugfix release
 * 
 * Version 2.16.2:
 * 10.05.2016 (Andreas):
 * lib/commons-codec-1.3.jar: remove obsolete library
 * lib/docuteam-tools-2.11.3.jar: fix closing of SFTP streams
 * 09.05.2016 (Andreas):
 * admin.Version: bump to next development release
 * 
 * Version 2.16.1:
 * 05.05.2016 (Andreas):
 * mets.structmap.NodeFile: modify checksum calculation to work if submitStatus is not used
 * 04.05.2016 (Andreas):
 * admin.Version: bump to next development release
 * 
 * Version 2.16.0:
 * 04.05.2016 (Andreas):
 * mets.Document:
 * 		- submit through SSH if parameters available
 * 		- submit will re-submit parent nodes of selected nodes
 * 		- automatically deleteOnExit working copies of zipped SIP files that were opened read-only
 * 		- submit only transfers the files that are selected for submit, not the entire SIP anymore
 * 		- fix method getSIPNameForSubmit() to allow for dots in SIP names.
 * 		- add method hasSubmittedNodes() to check if parts of the SIP have been submitted.
 * 		- properly lock SIPs while being submitted
 * 		- properly unlock SIPs after getting the feedback
 * 		- remove locking of entire SIPs after submit and submit feedback.
 * 		- use the above mentioned new method to prepare the SIP for submission
 * mets.structmap.NodeFile:
 * 		- verify checksums only for submitted nodes.
 * 		- setDynamicMetadataValueForName_force() will ignore SubmitStatus (allowing to set metadata during ingest for submitted nodes)
 * 		- fix migration when keeping original, take into account that the SIP can have a submit status blocking regular modifications
 * 		- adjust behaviour of root file migration, set levels for original/derived files if available
 * 		- changed handling of metadata for migrateToFileKeepOriginal()
 * 		- change behavior when migrating files to create a new subfolder containing original and copy
 * mets.structmap.NodeAbstract:
 * 		- When setting the SubmitStatus recursively, include the parent hierarchy as well
 * 		- split method setSubmitStatusRecursivelyAllOrNone() into two separate ones: ..._check() and _force()
 * 		- add method to switch a specific SubmitStatus for all nodes from one state to another
 * mdconfig.LevelOfDescription: add optional levels to indicate original/derived files
 * admin.Version: bump to next minor release
 * ingest.AIPCreatorExtended: additional AIPCreator implementation with additional checks regarding submit status
 * 03.05.2016 (Andreas):
 * mets.structmap.NodeFolder: create digiprovMDs for folders as well when checking SA for conforming file formats
 * 27.04.2016 (Andreas):
 * admin.Version: bump to next development release
 * 
 * Version 2.15.1:
 * 27.04.2016 (Andreas):
 * ead.DID, ead.ComponentAbstract, config/levels*.xml: new dynamic metadata element 'extentNote'
 * util.XMLUtil: allow dynamic metadata elements to specify a non-used attribute
 * mets.structmap.NodeFile: new method to remove file content from submitted nodes
 * mets.Document: new method to submit using SFTP
 * lib/docuteam-tools-1.11.2.jar:
 * 		- file.ssh.SFTPFileTransfer, file.ssh.SSHSessionProvider: new classes for SFTP file transfer
 * 		- lib/jsch-0.1.53.jar: add java ssh library
 * admin.Version: bump to next development release
 * 
 * Version 2.15.0:
 * 30.03.2016 (Andreas):
 * lib/docuteam-tools-1.11.1.jar: update to current version, changes since version 1.11.0:
 * 		- translations.I18N: extended to load several resource bundles per language
 * 		- config_dist/container-signature-20160121.xml, config_dist/DROID_SignatureFile_V84.xml, file.MetadataProviderDROID: update to current DROID signature files
 * 07.03.2016 (Christian):
 * mdconfig.LevelMetadataElement, mdconfig.MetadataElement, mets.structmap.NodeAbstract: validate default expressions against metadata validators and allowed values
 * 01.02.2016 (Andreas):
 * lib/docuteam-tools-1.11.0: use tagged version:
 * 		- file.FileChecksumCalculator, file.FileWithMetadata: add checksum calculations for SHA-256 and SHA-512
 * premis.Object: set default algorithm to SHA-512
 * mets.structmap.NodeFile: instead of hard-coded use of MD5, select the specified algorithm to check fixity.
 * bump to next minor release (interface change because of additional exception)
 * 
 * Version 2.14.10:
 * 27.01.2016 (Andreas):
 * mets.Document: add method saveAndClose which moves the sip instead of copying it (closing the working copy and setting it into ReadWriteNoFileOps mode) using less resources
 * mets.amdsec.AMDSection: create the amdSec at the proper location if missing
 * 20.01.2016 (Andreas/Christian):
 * mdconfig.MetadataElement: treat null value like an empty string for validation against allowed values
 * 19.01.2016 (Andreas):
 * admin.Version: bump to next development release
 * 
 * Version 2.14.9:
 * 14.01.2016 (Andreas):
 * mets.Document, mdconfig.LevelOfDescription: use SAXReader.read() with a File instead of a String to handle file paths with special characters
 * 08.01.2016 (Andreas):
 * MetadataElementValidatorDateHierarchyRangeCH: fix to include the "NoDate" string into interpretation
 * MetadataElementValidatorDateHierarchyYear: fix to deal with empty/null values and check against child nodes as well
 * MetadataElementValidatorDateRangeCH: fix to allow dates with single digit days/months
 * 22.12.2015 (Andreas):
 * mets.filesec.File: quote regex string
 * admin.Version: bump to new version
 * 
 * Version 2.14.8:
 * 18.11.2015 (Andreas):
 * mets.Document: simplify filter for valid SIP folders
 * 03.11.2015 (Andreas):
 * mets.amdsec.DigiprovWithPremis: new method signatures to create PREMIS events with a specific date
 * premis.Event: modify constructor to include the event date (defaults to the current date)
 * 
 * Version 2.14.7:
 * 26.10.2015 (Andreas):
 * lib/docuteam-tools-1.10.9:
 *		- file.FileUtil, file.FileWithMetadata, file.MetadataProviderDROID, file.MetadataProviderJHOVE, file.PropertyFile, os.OSXAdapter: replace any Exception.printStackTrace() to proper logging calls
 * ingest.AIPCreatorBasic: new AIPCreator that only checks for mandatory metadata elements and readability of files
 * 20.10.2015 (Andreas):
 * config_levels/levels_all_*.xml: include additional icon filenames
 * 05.10.2015 (Andreas):
 * admin.Version: bump to new version
 * 
 * Version 2.14.6:
 * 05.10.2015 (Andreas):
 * levels_*.xml: fit translations to actual language definition
 * 02.10.2015 (Andreas):
 * mdconfig.MetadataElementValidator*CH: allow dates to have single digits for month/day components
 * 21.09.2015 (Andreas):
 * admin.Version: bump to new version
 * 
 * Version 2.14.5:
 * 21.09.2015 (Christian):
 * mdconfig.MetadataElementValidatorDateHierarchyRangeCH: fix check for null values in child nodes
 * 17.09.2015 (Andreas):
 * admin.Version: bump to new version
 * 
 * Version 2.14.4:
 * 17.09.2015 (Andreas):
 * ead.C: fix to allow EAD files with just an archdesc and no further child components
 * 08.09.2015 (Andreas):
 * mdconfig.MetadataElementValidatorDate*: accept a value of 'NoDate' (and translations if available, e.g. "undatiert") 
 * 28.08.2015 (Andreas):
 * admin.Version: bump to new version
 * 
 * Version 2.14.3:
 * 28.08.2015 (Andreas):
 * lib/docuteam-tools-1.10.8: Use final tagged version
 * 		- file.FileUtil: fix basicCopyTo method to ignore copying if source equals destination
 * lib/docuteam-tools-1.10.7: Use final tagged version
 * 		- lib/log4j-1.2.17.jar: updated version
 * 		- lib/commons-codec-1.9.jar: dependency of poi-3.11-20141221.jar
 * 16.08.2015 (Andreas):
 * util.XMLUtil: replace both \r and \n with <EAD:lb> elements
 * 08.07.2015 (Andreas):
 * config_levels/levels_cmi_de.xml:
 * 		- allow repetition of levels
 * 		- change objectType for document level to mandatory/not repeatable
 * 20.05.2015 (Christian, Andreas):
 * ead.Document: added static method read(BufferedReader)
 * 15.04.2015 (Andreas):
 * admin.Version: initialized new version
 *
 * Version 2.14.2:
 * 15.04.2015 (Christian, Andreas):
 * unittest.darc.mets.Document: corrected assertions to meet some incompatibilities (different order of files to check)
 * mets.Document: optimize initialization of empty mets files
 * mets.Document: new private method initializeEmptyMetsFile initializes an empty mets file with provided submission agreement
 * unittest.darc.mets.Document: adapted assertions to expect existing and valid submission agreement
 * 14.04.2015 (Christian):
 * mets.Document: collect exception if mets file has no TYPE attribute in root element
 * unittest.darc.mets.Document: add test case missing TYPE attribute in root element of mets file
 * unittest/files/ch-001194-4_459_no_SA: added SIP with mets file without attribute TYPE in root element
 * unittest/files/ch-001194-4_459_no_SA/mets.xml: added mets file without attribute TYPE in root element
 * 09.04.2015 (Andreas):
 * reintegrated branch "2015-03-02 detailinfos_bei_premis_events":
 * 		- mets.structmap.Node*: revised event creation and extended event detail messages
 * 		- premis.EventType: added event type Replacement
 * 		- unittest.darc.mets.Document: adapted unittests to new event model
 * 		- mets.Document: removed deletion of digiprovs after deleting node (deleting of digiprovs now is done while deleting node in mets.structmap.NodeAbstract)
 * lib/docuteam-tools-1.10.6: Use final tagged version
 * 		- config/*: updated DROID signature files
 * 		- string.StringUtil: new method isDecimal(String)
 * 		- lib/droid*: clean droid libraries
 * 16.03.2015 (Christian):
 * mets.amdsec.DigiprovWithPremis: updated PREMIS_Version to 2.2
 * 10.03.2015 (Andreas):
 * lib/docuteam-tools-1.10.6.jar: use most recent version with string.StringUtil.isDecimal(string)
 * 09.03.2015 (Andreas):
 * config_levels/levels_cmi_de.xml: additional elements
 * mets.metshdr.Header: add agent information when initializing a header
 * resources/templates/mets_sip.xml: remove <metsHdr> to enable initialization of a clean header for new SIPs.
 * 18.02.2015 (Christian):
 * unittest.darc.mets.Document: added two test methods to check invalid mimetype in root file
 * unittest.files.SingleFileWithoutValidMimeType: added test.owl as test file without valid mime type
 * 17.02.2015 (Andreas):
 * build.xml: set java compatibility to 1.7
 * lib/docuteam-tools-1.10.6.jar: use java 1.7 compatible build
 * 16.02.2015 (Christian):
 * mets.structmap.NodeAbstract: method createRootNode(StructureMap, File) added Exceptions for root file, if mime type or format id is not given 
 * 13.02.2015 (Andreas):
 * config_dist/levels_cmi_de.xml: adjust to latest CMI requirements
 * lib/*: use most recent docuteam tools library with modified DROID libraries
 * ead.ComponentAbstract: fix XPath for deathOfAuthor
 * mdconfig.MetadataElementValidatorDateHierarchyRangeCH: ignore children if respective MetadataElement is not available with them
 * 02.02.2015 (Christian):
 * util.XMLUtil: method asParentPath(String xpath) added
 * ead.EADNodeAbstract.deleteParentElementIfEmpty(String xpath): call XMLUtil.asParentPath instead of FileUtil.asParentPath
 * 29.01.2015 (Andreas):
 * ead.ComponentAbstract: change XPaths for two of the new metadata elements (deathOfAuthor, sourceType)
 * admin.Version: include verbose version information (about all docuteam libraries)
 * 27.01.2015 (Christian):
 * darc.mdconfig.MetadataElement: changed variable All from HashMap to LinkedHashMap to ensure order of attributes
 * unittest.darc.util.CSVExport: Updated order of csv attributes
 * build.xml changed tools to 1.10.5
 * lib/docuteam-tools replaced with new version 1.10.5
 * lib/droid-command-line, lib/droid-container, lib/droid-core, lib/droid-core-interfaces: replaced with new version 6.1.5
 * lib/poi: replaced with new version 3.11
 * build.xml: compile changed to java 1.8
 * 23.01.2015 (Andreas):
 * additional metadata elements to meet the requirements of the CMI Basismodell:
 * 		deathOfAuthor
 * 		accessionNumber
 * 		sourceType
 * 		usagePermission
 * 		usagePermissionExpiringDate
 * 		modeOfAcquisition
 * 		digitization
 * 		relationPeriod
 * ead.EADNodeAbstract: do deleteParentElementIfEmpty(xpath) on an xpath recursively
 * 16.12.2014 (Andreas):
 * mdconfig.MetadataElement: fix javadoc
 * mets.Document: change xml output format to be compact; saves space, formatting wasn't really indented in a readable way before either.
 * 01.12.2014 (Christian):
 * config_levels/levels_all_*.xml, config_levels/levels_generic_*.xml: added metadata elements
 * 23.11.2014 (Andreas):
 * ead.ComponentAbstract, unittest.mets.Document: fix renaming of methods
 * 21.11.2014 (Andreas):
 * ead.ComponentAbstract, ead.DID: move new elements from DID to NodeAbstract, rename bioghist to biographicalHistory and note to characteristicsNote
 * config/levels.xml: apply modified accessor names
 * 14.11.2014 (Christian):
 * unittest/files/config/levels.xml: added bioghist, accruals, note, and subject to level serie.
 * unittest.darc.mets.Document: added fields to respective test methods and adapted number of expected values where appropriate. 
 * unittest.darc.mdconfig.LevelOfDescription.testAccessingLevels: adapted number of expected dynamic metadata elements
 * ead.ComponentAbstract: added getters and setters for bioghist, accruals, note, and subject.
 * ead.DID: added xpath constants, fields, getters and setters for bioghist, accruals, note, and subject and updated constructor with assignments for these fields.
 *
 * Version 2.14.1:
 * 13.11.2014 (Andreas):
 * common.NodeAbstract: fix getDynamicElementTexts for replacements of <EAD:lb/>
 * 13.11.2014 (Christian):
 * common.NodeAbstract: corrected adding of linebreaks, respects now also old fashioned linebreaks (\n), Included method getNotEmptyValues into getDynamicElementTexts and removed it.
 * unittest.darc.common.NodeAbstract: testForLineBreaks: added test for using of \n in old mets.xml files, testForLineBreakElements: tests for right use of lb elements.
 * unittest.darc.common.MetadataMultilineTextElementTest: replaced by NodeAbstract.
 * unittest.files: added sip_without_linebreak_elements.zip.
 * files/config/levels_multiline_text.xml added level metadata scopecontent for tests.
 * unittest.darc.AllTests: replaced MetadataMultilineTextElementTest by NodeAbstract
 * 11.11.2014 (Andreas):
 * licenses/*: cleanup
 * 11.11.2014 (Christian):
 * unittest.darc.mets.Document.structMapInsertFolderNOK, createNewSIPFolderWithFolder, createNewSIPZIPWithFolder, createNewSIPFolderWithEmptyFolder, createNewSIPZIPWithEmptyFolder, createNewSIPFolderWithFile, createNewSIPZIPWithFile adapted for linux by allowing any order of the sequence of messages.
 * unittest.darc.ingest.AIPCreatorProxy added setup method to initialize static field AIPCreatorInstance.
 * unittest.darc.ingest.AIPCreatorProxyInitWithDoNothing: removed
 * common.NodeAbstract: change getDynamicElementText(): when multiple elements where read a linebreak was set, altered in respect of changed method in XMLUtil (see 03.11.2014).
 * lib/docuteam-tools-1.10.4.jar: Use tagged version of tools 1.10.4
 * build.xml: use new tagged version of docuteam-tools
 * 05.11.2014 (Christian):
 * common.NodeAbstract.getDynamicElementTexts added trim function to strings.
 * util.XMLUtil.addElementsWithTexts added trim function to strings.
 * 03.11.2014 (Christian):
 * util.XMLUtil.addElementsWithTexts corrected to reflect correct ead structure.
 * unittest.darc.common new package for tests
 * unittest.darc.common.MetadataMultilineTextElementText test class for multiline elements
 * levels_multiline_text.xml for tests
 * 30.10.2014 (Andreas):
 * Use current version of tools 1.10.4 with extension:
 * 		file.FileUtils: method to get human readable file size
 * 20.10.2014 (Christian):
 * mets.Document: reverted submit and changed revertToBackup to reflect use of ORIGINAL-METS backups that only have a mets.xml as content, changed save method to reflect zipfiles and folders.
 * mdconfig.MetadataElementDefaultExpressions: changed classname from MetadataElementDefaultExpression and set class to abstract and method to static.
 * 15.10.2014 (Christian):
 * mdconfig.MetadataElementValidatorDateHierarchyRangeCH: Checks date range of children too.
 * corrected MetadataElement.getValueFromNode 
 * 14.10.2014 (Christian):
 * Changes in mets.Document to reflect use of Mode.ReadWriteNoFileOps. Affected methods are: changed, save(boolean), submit(String), purgeBackups(), new method is: getLastMetsBackupFilePath()
 * common.NodeAbstract: Added Element <EAD:lb/> for multiline values in getDynamicElementTexts: reflecting EAD namespace. Added method getNotEmptyValues to extract only text element with text.
 * util.XMLUtil: Added Element <EAD:lb/> for multiline values in addElementsWithTexts
 * 07.10.2014 (Christian):
 * mdconfig.MetadataElementValidatorDateHierarchyRangeCH added. Checks if the date or date range of a node exceeds a given date or date range in an ancestor
 * mdconfig.MetadataElementDefaultExpression: added new class with currently one method:
 * getUniqueNumericValueWithParentsPrefix: takes the parents value of same metadata element, checks siblings and sets a new unique value.
 * Dependencies: docuteam.tools-1.10.4
 * 03.10.2014 (Christian):
 * mdconfig.MetadataElement: Constructor now builds a list of inner classes ValidatorInstances and postActionInstances
 * validateValueAgainstNode and executePostActionInNode run through all ValidatorInstances and PostActionInstances
 * api of MetadataElement has not changed but levels.xml may now have several MetadataElementValidators and MetadataElementSetterPostActions separated by AllowedValuesSeparator
 * 05.09.2014 (Andreas):
 * mdconfig.MetadataElementValidatorDateRangeCH: cleanup message names
 * Use current version of tools 1.10.4 with updated license information
 * lib/*: remove rosetta libraries (not needed in the generic darc)
 * licenses/*: general cleanup
 * mdconfig.LevelOfDescription, mdconfig.MetadataElement: move handling of AllowedValuesSeparator from MetadataElement to LevelOfDescrition as it is defined per level configuration file.
 * mdconfig.MetadataElementValidatorDateRangeCH: new validator which allows a range (using a dash); uses mdconfig.MetadataElementValidatorDateCH for validation of the single date values
 * mdconfig.MetadataElementValidatorDateCH: extend to allow not only "dd.MM.yyyy", but also "MM.yyyy" and "yyyy"
 * 04.09.2014 (Andreas):
 * unittest.files.config.levels.xml: revert change as not necessary.
 * 27.08.2014 (Andreas):
 * levels_BAR.xml: modify parameters (allowedValues, readOnly) for some elements
 * Version 2.14.1 initial.
 *
 * Version 2.14.0:
 * 27.08.2014 (Andreas):
 * unittest.darc.mdconfig.MetadataElementValidatorDateHierarchyYear: verify correct initialization or fail
 * unittest.files.config.levels_validators.xml: use correct validator class names
 * 27.08.2014 (Christian):
 * Use current version of tools 1.10.3 with fix when copying files
 * 18.08.2014 (Christian):
 * unittest.darc.mdconfig.MetadataElementValidatorUniqueValueAmongSiblings: adapted to last changes of class (
 * 25.06.2014 (Denis):
 * mdconfig.MetadataElement: Validate every new value against allowedValues, too (if defined). Tons of resulting changes.
 * 23.06.2014 (Denis):
 * mdconfig.*: Validators now return a message code which should be translated.
 * mdconfig.MetadataElementValidatorUniqueValueAmongSiblings: Correction: Check if node to test is root and hence has no siblings.
 * 20.06.2014 (Denis):
 * Use current version of tools 1.10.2 with extension:
 * 		translations.I18N: Add methods translate_NoCheck(String word) and translate_NoCheck(String word, Object... objects) to avoid exception when I18N is not initialized.
 * mdconfig.MetadataElementValidatorUniqueValueAmongSiblings: Translate metadata name in warning message.
 * mdconfig.MetadataElementValidatorDate, mdconfig.MetadataElementValidatorDateCH: Correction in parsing dates: be more strict.
 * 17.06.2014 (Denis):
 * mdconfig.MetadataElementSetterPostAction, mdconfig.MetadataElement, mdconfig.LevelMetadataElement: Corrections and UnitTests.
 * 16.06.2014 (Denis):
 * Interface change:
 * mdconfig.MetadataElementValidator:
 * 		The method check(...) doesn't return a String any more but now throws a MetadataElementValidatorException.
 * 		Consequent changes in many other places.
 * mdconfig.MetadataElementSetterPostAction, mdconfig.LevelOfDescription, mdconfig.MetadataElement, mdconfig.LevelMetadataElement,
 * exceptions.MetadataElementSetterPostActionClassNotFoundException, config_dist/levels.xsd:
 * 		Execute an optional configurable post-action after having set a dynamic metadata value.
 *
 * Version 2.13.2:
 * 16.06.2014 (Denis):
 * UnitTests for read-only dynamic metadata.
 * 13.06.2014 (Denis):
 * mdconfig.MetadataElementSetterPostAction, mdconfig.LevelOfDescription, mdconfig.MetadataElement, mdconfig.LevelMetadataElement,
 * exceptions.MetadataElementSetterPostActionClassNotFoundException, config_dist/levels.xsd:
 * 		Execute an optional configurable post-action after setting a dynamic metadata value. (still under development)
 * 12.06.2014 (Denis):
 * mets.structmap.NodeAbstract, mdconfig.MetadataElementInstance, mdconfig.LevelMetadataElement, exceptions.LevelMetadataElementIsReadOnly:
 * 		The normal setter for dynamic metadata in NodeAbstract ("setDynamicMetadataValueForName(String name, String value)") now throws
 * 		the exception "LevelMetadataElementIsReadOnly" when the corresponding metadata element is marked as read-only for this level.
 * 		The setter with an appended "_force" ("setDynamicMetadataValueForName_force(String name, String value)") sets the value
 * 		in any case, ignoring a read-only mark.
 *
 * Version 2.13.1:
 * 11.06.2014 (Denis):
 * util.XML2PDF: Cleanup.
 * util.CSVExport: New class.
 * 09.06.2014 (Andreas):
 * util.XML2PDF: set proper output, use saxon as xsl processing engine.
 * lib/: added current libraries for XSL-FO processing
 * 06.06.2014 (Denis):
 * util.XML2PDF: Still under development.
 * 05.06.2014 (Denis):
 * mets.Document, mets.structmap.NodeAbstract: Improve the searchForAllQuoted method: ALL search words must be present, but each in any of the searched areas.
 * 04.06.2014 (Denis):
 * Use current version of tools 1.10.2 with correction:
 * 		MetadataProviderDROID: Use full extension matching
 * 04.06.2014 (Christian)
 * ch.docuteam.darc.mdconfig.MetadataElementValidatorDateCH added. Checks if a date conforms to swiss dateformat.
 * ch.docuteam.unittest.darc.mdconfig.MetadataElementValidatorDateCH for unittest.
 * ch.docuteam.darc.mdconfig.MetadataElementValidatorUniqueValueAmongSiblings added. Checks if a refCode within same level is unique.
 * ch.docuteam.unittest.darc.mdconfig.MetadataElementValidatorUniqueValueAmongSiblings for unittest.
 * unittest uses:
 * - ch/docuteam/unittest/files/config/levels_unique.xml
 * - ch/docuteam/unittest/files/all-refcodes-unique-test.zip
 * 28.05.2014 (Denis):
 * Use current version of tools 1.10.2 with extension:
 * 		string.StringUtil: Add methods containsAll(String, String...), containsAll(String, List<String>), containsAny(String, String...), and containsAny(String, List<String>).
 * mets.Document, mets.structmap.NodeAbstract: Extend search to multiple search items, quoted.
 * mets.Document, exceptions.ZIPDoesNotContainMETSFileException: When a zipped SIP doesn't contain the METS file at the root level, throw this exception.
 * 22.05.2014 (Denis):
 * mets.Document: Corrections in methods submit(...) and checkIngestFeedback(...): can now handle correctly both zipped and unzipped SIPs.
 * 16.05.2014 (Denis):
 * bar.Document: Unit tests.
 * 15.05.2014 (Denis):
 * bar.Document: Finalization, Unit tests.
 * 14.05.2014 (Denis):
 * ch.docuteam.unittest.darc.mdconfig.MetadataElementValidatorDateHierarchyYear: Qualify all field accesses with "this".
 * 13.05.2014 (Christian):
 * Updated to tools library v.1.10.2
 * 12.05.2014 (Denis):
 * filesec.File: Bug fix: In rare cases, renaming a folder changed the href of files within this folder (if the file had the same name as the folder).
 * 29.04.2014 (Andreas):
 * Version 2.13.1 initial.
 *
 * Version 2.13.0:
 * 29.04.2014 (Andreas):
 * Use current version of tools 1.10.1 with extension:
 * 		updated DROID signature file to enhance support for PDF/A
 * mdconfig.MetadataElementValidatorDateHierarchyYear: new validator to check simple date logic between a node and its parent
 * 16.04.2014 (Denis):
 * structmap.NodeAbstract, structmap.NodeFile, structmap.NodeFolder:
 * 		Additional methods "boolean hasMimeType()" and "booelan hasFormatID()".
 * 		When inserting files, remember exceptions if mimeType and formatID can not be calculated.
 * 16.04.2014 (Denis):
 * bar.Document: Convert SIP to BAR-SIP.
 * 15.04.2014 (Denis):
 * Use current version of tools 1.10.1 with extension:
 * 		out.Logger: Added public method getLogger() that returns the logger for the calling class. When using this method, it is possible
 * 				to output the name and line number of the method where the logging is issued in.
 *
 * Version 2.13.0:
 * Interface change:
 * exceptions.MetadataElementIsNotAllowedException, exceptions.MetadataElementIsNotDefinedException,
 * mdconfig.LevelOfDescription, mets.Document, mets.structmap.NodeAbstract:
 * 		Better exception handling when accessing undefined or not configured metadata elements.
 * 14.04.2014 (Denis):
 * levels.xml, ead.ComponentAbstract: Extend the dynamic metadata by one more element: "accessRestrictionPeriodBaseYear".
 * 11.04.2014 (Denis):
 * bar.Document: Refactored util.BARSIPWriter and util.BARSIPReader to bar.Document.
 * 10.04.2014 (Denis):
 * structmap.NodeAbstract: Add method "getAllDynamicMetadataValuesForName_NoCheck(String)" to retrieve dynamic metadata values
 * 		even if the metadata element is not configured (= allowed) by the node's level.
 * util.XMLUtil: Correction: allow arbitrary values (including empty string or several words) as attribute values.
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 09.04.2014 (Denis):
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 08.04.2014 (Denis):
 * mdconfig.LevelOfDescription, mdconfig.LevelMetadataElement, mdconfig.MetadataElement:
 * 		Better exception handling when initializing levels.
 * 		In particular, in case of a bad validator class, keep the metadata element and ignore its bad validator.
 * Use current version of tools 1.10.1 with correction:
 * 		exception.Exception, exception.ExceptionCollector: Improve output as String.
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 07.04.2014 (Denis):
 * mdconfig.LevelOfDescription, mdconfig.LevelMetadataElement, mdconfig.MetadataElement: Better exception handling when initializing levels.
 * 04.04.2014 (Denis):
 * Version 2.12.1 initial.
 *
 * Version 2.12.0:
 * 04.04.2014 (Denis):
 * Use tagged version of tools 1.10.0.
 * Tagged as Version 2.12.0.
 * 02.04.2014 (Denis):
 * Additional dynamic metadata elements:
 * 		accessPolicy
 * 		accessRestrictionExplanation
 * 		accessRestrictionPeriod
 * 		accessRestrictionClassification
 * 		accessRestrictionPrivacy
 * 		accessRestrictionStatus
 * 		accessRestrictionStatusExplanation
 * lib/gson-2.2.4.jar: New library for converting data to and from JSON-format.
 * util.BARSIPReader: Use gson-lib to convert data to JSON-format.
 * util.BARSIPWriter: Use gson-lib to convert data from JSON-format.
 * 28.03.2014 (Denis):
 * config_levels/*: Extend dynamic metadata.
 * ead.ComponentAbstract: Extend dynamic metadata.
 * config_levels/levels_BAR.xml: Extend BAR-levels dynamic metadata.
 * util.BARSIPReader: Adapt to new BAR-levels dynamic metadata.
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 26.03.2014 (Denis):
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 25.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess:
 * 				Throw specific exception when Desktop can't launch or associate an application for a file.
 * 24.03.2014 (Denis):
 * util.BARSIPWriter: Convert SIP to BAR-SIP
 * 23.03.2014 (Denis):
 * util.XMLUtil: New class.
 * common.NodeAbstract: Use util.XMLUtil.
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 19.03.2014 (Denis):
 * util.BARSIPWriter: New.
 * util.BARSIPConverter: Renamed to BARSIPReader.
 * 13.03.2014 (Denis):
 * exception.BadPronomIdException, exception.FileConversionException, exception.OOConverterShallNotBeUsedException: Delete redundant classes.
 * 11.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.FileUtil: Prohibit "..", as legal file name generally. Removed a remaining trace in "isFileNameAllowed()"
 * 05.03.2014 (Denis):
 * unittest.darc.mets.Document: Adapted unittests for Linux.
 * Use current version of tools 1.10.0.
 * 03.03.2014 (Denis):
 * unittest.darc.mets.Document: All unittests within a class are now independent of the order in which they are executed.
 * 25.02.2014 (Denis):
 * mets.structMap.NodeFolder: More logging when inserting files or folders into a NodeFolder.
 * 20.02.2014 (Denis):
 * mets.Document: Copy SIPs (folder or zip to folder or zip).
 * 19.02.2014 (Denis):
 * mets.amdsec.AMDSection, mets.amdsec.DigiprovAbstract, mets.Document, mets.metshdr.Header, premis.Object:
 * 		Save Version.Product and Version.Number in the METS file.
 * 18.02.2014 (Denis):
 * config_levels/levels_standard_*.xml: Corrections in english translation, define Level1.png - Level9.png als default icons for levels.
 * amdsec.DigiprovAbstract, amdsec.DigiprovWithPremis, mets.Header, premis.Object:
 * 		Save Version.Product and Version.Number in the METS file.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * util.VirusScannerClam, exceptions.VirusScannerClamException: Removed (will be integrated into feeder).
 * 13.02.2014 (Denis):
 * build.xml: Removed targets that include the OOO apps.
 * 12.02.2014 (Denis):
 * util.FileConverter: Removed this class and all corresponding files (incl. the OOO apps). This class will be integrated into the project "Converters".
 * 11.02.2014 (Denis):
 * Use current version of tools 1.10.0 with extensions:
 * 		os.SystemClipboard: New class. Can be used to get text from and put text into the system clipboard.
 * 		gui.SystemOutView:
 * 				Add "Copy" button to copy the content of the text area into the system clipboard.
 * 				Add method to optionally set an "additional info text" string, which is added to the text area string when copying the text to the clipboard.
 * 		file.PropertyFile: Add method "getKeys()";
 * 10.02.2014 (Denis):
 * unittest.mets.Document, unittest.util.FileConverter: Fixed some UnitTests to ignore the ".svn"-folder when counting files and folders.
 * unittest.mets.Document: In one case, an opened document was not cleaned-up properly, resulting in a remaining working copy in the temp folder.
 * util.RosettaConverter, util.SIPHelper: Deleted.
 * structmap.NodeFile: Added methods "replaceByFile(String)" and "replaceByFile(File)".
 * 05.02.2014 (Denis):
 * Interface change:
 * Refactoring: Renamed package "ch.docuteam.docutools" to "ch.docuteam.tools".
 *
 * Version 2.11.4:
 * 05.02.2014 (Denis):
 * Use Docutools 1.10.0 with corrections:
 * 		The methods OperatingSystem.javaTempDir() and OperatingSystem.userHome() now always return the file path with a trailing File.separator.
 * Preliminary approvement for Linux.
 * 04.02.2014 (Denis):
 * mets.Document: Method "checkIngestFeedback()": Proper cleanup after feedback, including removal of the submitted zip file.
 * 03.02.2014 (Denis):
 * mets.amdsec.DigiprovWithPremis, mets.structmap.NodeAbstract, NodeFile, NodeFolder:
 * 		When creating events, include current user login name into event detail.
 * mets.Document: Method "checkSubmission()": distinguish between folders and zipped SIPs.
 * 31.01.2014 (Denis):
 * mets.Document:
 * 		Include in "checkSubmission()" the test if the packet already exists in the submission folder.
 * 		Make "checkIngestFeedback()" more strict, and check zipped SIPs as well.
 * 30.01.2014 (Denis):
 * structmap.NodeFolder: Added method "getChildren()".
 * mets.Document:
 * 		When submitting, reject if SIP already exists in the submit folder.
 * 		Method "checkIngestFeedback()" can now handle zipped SIPs as well.
 * 23.01.2014 (Denis):
 * mets.Document:
 * 		When submitting, zip the SIP without the enclosing folder.
 * 		Made method "boolean isZIPFile()" public.
 * 21.01.2014 (Denis):
 * util.FileConverter$OOConverter: Adapt to run under Linux, too.
 * 16.01.2014 (Denis):
 * mets.Document: Correction in revert to the last saved document version.
 * All java sources: Change copyright message from "2011-2013" to "2011-2014".
 * 15.01.2014 (Denis):
 * mets.Document: Correction in revert to the last saved document version: force-unlock the document before reverting.
 * 14.01.2014 (Denis):
 * mets.Document: Revert to the last saved document version.
 * 08.01.2014 (Denis):
 * Use Docutools 1.9.1 with extensions:
 * 		gui.GUIUtil: new Class.
 * 		file.PropertyFile: Added new method get(String key, String ifAbsent, String ifEmpty) with additional option "ifEmpty".
 * 19.12.2013 (Denis):
 * mets.Document: Revert to the last saved document version.
 * mets.Document: checkIngestFeedback(): When found an ingest feedback, replace the current lock by a "lock-as-submitted" lock.
 * structmap.NodeAbstract$SubmitStatus: Changed the content of the lock file in the cases of "submitRequestPending" and "submitted".
 * Use Docutools 1.9.1.
 * 18.12.2013 (Denis):
 * mets.Document: Big refactoring in open*() methods.
 * 12.12.2013 (Denis):
 * mets.Document: Revert to the last saved document version.
 * 04.12.2013 (Denis):
 * mets.Document: Reset the lock when submit fails.
 * 02.12.2013 (Denis):
 * unittest/files/VirusScanner/fileNameWithUmlaut_ö.txt, unittest/docudarc/util/VirusScannerClam:
 * 		Removed file with umlaut from UnitTests for VirusScannerClam.
 * 27.11.2013 (Denis):
 * util.KeyAndValue: New class.
 * INTERFACE CHANGE:
 * mdconfig.MetadataElement: allowedValues is now a List<KeyAndValue> and not any more a List<String>.
 * ingest.AIPCreatorProxy: Don't throw exception when initialized with null or empty String.
 *
 *
 * 2.11.3 (Denis, 22.11.2013):
 * ead.ComponentAbstract, mets.structmap.NodeAbstract: SubmitStatus.
 * util.RosettaConverter: create IEs.
 * mets.Document: Refactoring: Rename some public methods and mark the old ones as @Deprecated:
 * 		getSipFolder() -> getSIPFolder()
 * 		getOriginalSipFolder() -> getOriginalSIPFolder()
 * 		getOriginalSipName() -> getSIPName()
 * mets.Document: Submit.
 * ead.MetadataElementInstance: Refactoring: Moved this class to package 'mdconfig'.
 * 		NOTE: Imports have to be adjusted!
 * util.RosettaConverter: Add method 'getEADElementPath(NodeAbstract)' to provide a node's EAD-source from the root down to the node.
 * Use Docutools 1.9.0 with redesigned FileFilter.
 * mets.Document: New method 'checkIngestFeedback(String ingestFeedbackFolderPath, String workspaceFolderPath)'.
 * updated license information on used libraries.
 * util.FileConverter$OOConverter: Initialize path to OO now with canonical filename.
 * mets.Document, structmap.NodeAbstract, util.RosettaConverter:
 * 		Moved method submitCheck() from mets.Document and structmap.NodeAbstract to util.RosettaConverter.
 * util.RosettaConverter: Enhanced submit check.
 * mets.structmap.NodeAbstract: getDynamicMetadataElementInstancesToBeDisplayed():
 * 		Initialize empty dynamic metadata elements if necessary.
 * util.RosettaConverter: Is now deprecated and replaced by:
 * ingest.AIPCreator: Interface.
 * ingest.AIPCreatorRosetta: Implementation of AIPCreator which replaces util.RosettaConverter:
 * 		Can now create Collections in addition to IEs.
 * ingest.AIPCreatorRosetta$DB: preparation.
 * ingest.AIPCreatorRosetta: feedback.
 * ingest.AIPCreatorProxy: Abstract static wrapper around the interface 'AIPCreator' which handles the interface implementations.
 * ingest.AIPCreatorRosetta: confirmStorage().
 * ingest.AIPCreatorRosetta:
 * 		Correction in checkSubmission(): Allow unconfigured dynamic Metadata for DC.
 * 		Correction in checkSubmission(): Allow undefined PID when level is undefined.
 * ingest.AIPCreatorRosetta: Removed this and all related classes from this project (and moved to project DocuteamPackerETH).
 *
 * 2.11.2 (Denis, 22.10.2013):
 * Release 2.11.2 has been extracted from ongoing work and does not refer to a specific revision of the trunk as development was overlapping.
 * Please check the commit comment on tag for "Version 2.11.2" for more details.
 *
 * util.FileConverter, exception.FileConverterException: When the file converter fails, throw now an exception instead of just returning an error code.
 * 		NOTE: The interface has changed! Calls to util.FileConverter.convertFile(...) now have to catch FileConverterException.
 * mets.Document:
 * 		Corrected method "isValidSIPFolder()": the mets.xml within the folder MUST be a file - a folder will not do.
 * 		The methods "isLockedByWhom(String)" and "isLockedBySomebodyElse(String)" are now public.
 * 		Added methods "isLockedByWhom(File)" and "isLockedBySomebodyElse(File)".
 * 		Added methods "isLocked(File)" and "isLocked(String)".
 * Use Docutools 1.8.4 with correction in class out.MailSender: The mail body can now contain umlauts.
 * mets.Document, exceptions.FileOrFolderIsInUseException:
 * 		Throw an Exception when saving the SIP while a file or folder inside the SIP is in use, e.g. by another application or the Win7 file explorer.
 * mdconfig.LevelOfDescription, mdconfig.LevelOfDescriptionSet, ... (many resulting changes):
 * 		Access to Levels is not via static methods any more, but via instances of LevelOfDescriptionSet.
 * 		Added instance variable "protected LevelOfDescriptionSet levels" to DocumentAbstract. Each document has now its own LevelOfDescriptionSet.
 * exceptions.FileOrFolderIsInUseException: Add additional information "originalSIPName" and "securitySIPName" to improve message shown to user.
 * mets.Document, mets.structmap.NodeAbstract: Search in one SIP.
 * structmap.NodeAbstract, structmap.NodeFile, structmap.NodeFolder: Extended with additional methods: getTreePath() and getWithDescendantsDepthFirst().
 * Use Docutools 1.8.4 with new class string.Pattern.
 * mets.Document: Corrected inconsistency when setting KeepBackupsCount: When now trying to set to null, ignore it and leave as is.
 * mets.Document: Allow to open a folder. Assume there is a mets.xml file within and open this.
 * mets.structmap.StructureMap: Fixed a bug when setting a new root folder, the initialization might fail because the old root folder was still in place.
 * exceptions.OriginalSIPIsMissingException, mets.Document: Throw an exception when the original SIP is missing while saving.
 * util.FileConverter: Finding out about current OO-Installation.
 * util.FileConverter$OOConverter, OOConverterShallNotBeUsedException:
 * 		If the default OO installation is absent and no external OO application path was supplied, assume that the OO Converter shall not be used.
 * util.FileConverter$OOConverter: Method disconnect() now cleans up the OOConverter thorougly.
 * util.BARSIPConverter: The BARSIPConverter can now handle ZIPs with or without a top folder.
 * util.FileConverter: Fast initialization:
 * 		When initializing the OOConverter in a separate thread AND the service is being requested, wait for the initialization to finish.
 * lib/slf4j-log4j12-1.5.6.jar: redirect slf4j through log4j instead of java.util.logging (e.g. jodconverter)
 * Use Docutools 1.8.4 with extension:
 * 		file.PropertyFile: Resolve environment variables in property values.
 * sa.SubmissionAgreement: When getting all final SAs from the SA folder, ignore files that start with a "." or a "~".
 * Use Docutools 1.8.4 with extension:
 * 		Redirect jul-logging via slf to log4j.
 *
 * 2.11.1 (Andreas, 06.06.2013):
 * premis.EventOutcome und premis.EventType: accept other values than the predefined.
 * add *.dotx to known documents formats
 *        (Denis, 01.07.2013):
 * mdconfig.MetadataElementValidatorShort: New.
 * Use Docutools 1.8.2 with correction in class Zipper.
 * Corrections in FileConverter unit tests.
 * ead.DID, ead.ComponentAbstract: Add dynamic properties fromYear, toYear, characteristics, findingAids, and locationOfOriginals.
 * ead.ComponentAbstract: Cleanup and refactoring.
 * util.FileConverter$OOConverter: Refactoring. Introduce new static method to set the number of initialization retries.
 * Use Docutools 1.8.2 with correction in class FileUtil.
 * util.FileConverter$OOConverter: Initialize now the OOConverter with the path INCLUDING the OOO application name.
 * config_dist/levels.xml: Contains now all levels from Docustore and the ISAD(G) set of metadata for each level.
 * config_dist/levels_standard_*.xml: Translated standard levels.xml.
 * Use Docutools 1.8.3 with improved DROID-Exceptions.
 * config_dist/levels.xml, config_dist/levels_standard_*.xml: Add kB, MB, and GB to material-allowedValues.
 * ead.ComponentAbstract: Bug fix when creating a copy of a C or ArchDesc element.
 * mets.Document: Refactoring: Include class DocumentFactory as private inner class.
 * ead.Document: Refactoring: Include class DocumentFactory as private inner class.
 * sa.SubmissionAgreement: Refactoring: Include class SubmissionAgreementFactory as private inner class.
 * util.BARSIPDocument: Convert a BAR-SIP to a Matterhorn-SIP.
 * util.BARSIPDocument: Removed class from project.
 * config_dist/levels_generic.xml: New.
 * util.BARSIPConverter: Re-inserted and renamed class util.BARSIPDocument back into project.
 * Use Docutools 1.8.3 with method FileUtil.appendSuffixToFileName().
 * util.BARSIPConverter: Corrections.
 * util.BARSIPConverter: Corrections: When comparing file names, do it case-INsensitive.
 * structmap.NodeFolder: Methods insertFile(), insertFolder(), and createNewFolder() with additional parameter "boolean renameIfNecessary".
 * 		When true, the inserted file or folder will be renamed, if it already exists in the parent node, by adding "-i" to the name,
 * 		where i is a 3-digit integer.
 * util.BARSIPConverter: Can convert now zip files, too.
 * structmap.NodeFolder: Bug fix: When creating a new SIP, the root folder's access rights are now set correctly.
 * config_dist/levels*.xml: Set the level "Undefined" as the first default-sublevel for the level "Undefined".
 * filesec.File: If DROID doesn't return a unique mimetype for a file, don't leave the field "mimeType" undefined but set it to "".
 * mets.Document, structmap.NodeFolder, util.BARSIPConverter, exceptions.FolderNameIsEmptyException:
 * 		Throw an exception when trying to insert a folder with an empty name. Refactoring.
 * Use Docutools 1.8.4 which is adapted for Java 7.
 * util.VirusScannerClam: Fixed a potential memory leak.
 * mets.*.*: Inserted protected default constructors (for subclasses).
 * mets.Document: Changed the visibility of some methods from private to protected (for subclasses).
 * mets.Document: Added method saveAs(String newMETSFilePath);
 * Use Docutools 1.8.4 with correction in SystemOutRedirector: When redirecting SYSOUT, the log4j logs are now redirected, too.
 * Use Docutools 1.8.4 with improved Exception and ExceptionCollector.
 * Switch back to Java 6. Use Docutools 1.8.4 which is adapted for Java 6.
 * Use Docutools 1.8.4 with correction when opening a file externally in Windows.
 * Use Docutools 1.8.4 with extended SmallPeskyMessageWindow and SmallPeskyProgressBarWindow which can now block the underlying parent window.
 * mets.Document: When saving a SIP with backup, limit the number of backups, i.e. delete some of the oldest.
 * util.FileConverter$OOConverter, sa.SubmissionAgreement: Added some missing getter methods.
 * Use Docutools 1.8.4 with correction:
 * 		gui.JTableWithSpecificCellEditorPerRow: Added method "commitOrCancelCurrentCellEditor()" to commit (or cancel if commit fails) the current cell editor.
 * build.xml: Don't overwrite config_dist/log4j.xml when getting Docutools.
 * build.xml: Correction in target manifest.classpath.
 *
 * 2.11.0 (Denis, 05.02.2013):
 * mets.Document: SIPs can now be opened in readOnly mode.
 * 		Redesign and Refactoring => Interface changed => move from version 2.10.2 to 2.11.0
 * mets.Document, structmap.StructureMap, common.DocumentAbstract: Bug fix: Clean-up in METS-Template when creating a new SIP.
 * mets.Document: Bug fix: When creating a new SIP, don't save it twice.
 * structmap.StructureMap, structmap.NodeFile: Fixed a bug when the root file was migrated WITH keeping the original file.
 * mets.Document: Refactoring of some method names due to inconsistent and unlogic naming.
 * mets.Document: Throw DocumentIsReadOnlyException when trying to save a readOnly document.
 * mets.Document: When savingAs a readOnly document under a different name, change the document mode from readOnly to readWrite.
 * mets.Document: Can now set the document's SA.
 * structmap.NodeFile: File nodes can now be marked as notAllowedBySA.
 * mets.Document, structmap.StructureMap, structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Check against other SA.
 *
 * 2.10.2 (Denis, 22.01.2013):
 * structmap.NodeAbstract: Refactoring usage of method initializeDynamicMetadataElementInstancesWhichAreMandatoryOrAlwaysDisplayed().
 * mets.Document: When creating a SIP from a template, initialize all node's dynamic metadata elements.
 * All java sources: Change copyright message from "2011-2012" to "2011-2013".
 * mdconfig.LevelOfDescription, mdconfig.MetadataElement: Lazy initialization.
 * Use Docutools 1.8.1 with new DROID.
 * structmap.StructureMap: Bug fix: When creating a new SIP, the orphaned DMDSection of the original root node (from the template) is now removed.
 * filesec.File, premis.Object, structmap.NodeFile: Checksum is now stored only in premis.Object, not any more in filesec.File too.
 * All classes: JavaDoc.
 *
 * 2.10.1 (Denis, 20.12.2012):
 * ead.ComponentAbstact, ead.C, ead.ArchDesc, mets.Document, structmap.NodeAbstract:
 * 		Big refactoring: Move all dynamic metadata properties from C up to ComponentAbstract, so that ArchDesc has all these properties, too.
 * 		Reason is that generated EAD export files contain all dynamic metadata.
 * ead.DID: Get rid of the property "unitId" since it is not used. Lots of resulting changes.
 * Use Docutools 1.8.0.
 *
 * 2.10.0 (Denis, 12.12.2012):
 * ead.ComponentAbstract, ead.C, ead.ArchDesc: PID is now a dynamic metadata element.
 * Use Docutools 1.6.6.
 * structmap.NodeAbstract: When changing a node's level, initialize dynamic metadata if necessary and possible.
 * ead.DID: Changed XPath of "unitTitle" from "EAD:unittitle" to "EAD:unittitle[@label = 'main']".
 * unittest/files/*: Many UnitTest files had to be adapted.
 * ead.DID, config_dist/levels.xml: Added new dynamic metadata field "unitTitleAdditional" with XPath "EAD:unittitle[@label = 'additional']".
 * structmap.NodeAbstract: Added methods getDynamicMetadataValueForName(String) and getDynamicMetadataValueForName(String, String) WITHOUT parameter "int index", for non-repeatable items.
 * Use Docutools 1.6.7.
 * mets.Document: When creating the working copy, preserve the file's and folder's access rights.
 * structmap.NodeAbstract: When building up the tree, don't throw exceptions if a file or a folder is missing or not readable.
 * structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Added methods "hasPredecessorNotReadableByCurrentUser()" and "hasDescendantNotReadableByCurrentUser()".
 * Use Docutools 1.7.0.
 * many classes: Adapted to new exception handling in FileUtil.
 * structmap.NodeAbstract, structmap.NodeFolder, structmap.NodeFile:
 * 		Added methods "hasPredecessorNotWritableByCurrentUser()" and "hasDescendantNotWritableByCurrentUser()".
 * structmap.NodeAbstract: Added method "hasPredecessorNeitherReadableNorWritableByCurrentUser()".
 * structmap.NodeFolder: Added method "hasDescendantNeitherReadableNorWritableByCurrentUser()".
 * mets.Document: Disable saving with backup when document has at least one file that is not readable.
 * Use Docutools 1.7.1.
 * mets.Document: Set files and folders to writable before cleanup.
 * mets.Document: Cleanup properly after creating new SIP - no dead bodies left behind any more.
 * structmap.NodeAbstract: Renamed method "hasPredecessorNeitherReadableNorWritableByCurrentUser()" to "hasPredecessorNotReadableOrWritableByCurrentUser()".
 * structmap.NodeFolder: Renamed method "hasDescendantNeitherReadableNorWritableByCurrentUser()" to "hasDescendantNotReadableOrWritableByCurrentUser()".
 * mets.DocumentAbstract, structmap.NodeAbstract: New boolean property in DocumentAbstract: "isAtLeastOneFileNotWritable".
 * mets.Document: When saving with backup a SIP that contains nonreadable files, don't make a backup.
 * mets.Document: When saving a SIP that contains nonreadable or nonwritable files, ignore all FileUtilExceptions.
 * structmap.NodeAbstract, structmap.NodeFile, structmap.NodeFolder: Set the node's access rights when adding files or folders to a node.
 * util.FileConverter: When setting the folder of the OOO application for converting files, now only the location of the "OpenOffice.org" folder must be provided, not the complete path to the executable file within.
 * structmap.StructureMap, resources/templates/mets_sip.xml: Don't accept METS-Files whose structmap has a root element count != 1. The METS-template contains now an empty structmap root element.
 * structmap.NodeAbstract: Improve handling of bad structmap root nodes: strictly don't accept empty or improper types.
 * mets.Document: Now locks are removed and working copies are cleaned-up even when exceptions occur opening bad SIPs.
 * structmap.NodeFolder: Refactoring when inserting folders, retaining their access rights.
 * structmap.NodeAbstract: Initialize mandatory & repeatable dynamic metadata elements which have no instance, with one empty instance.
 * mdconfig.LevelMetadataElement, mdconfig.LevelOfDescription, structmap.NodeAbstract, config_dist/levels.xsd:
 * 		Added new level property "boolean isAlwaysDisplayed".
 * ead.MetadataElementInstance, mdconfig.MetadataElement: Add toolTipTexts.
 * Use Docutools 1.7.2 with Interface "ToolTipText".
 * When creating a template from a SIP, delete all metadata.
 * mdconfig.LevelOfDescription, mdconfig.LevelMetadataElement, mets.Document, config_dist/levels.xsd:
 * 		Added new level property "boolean keepInTemplate".
 * 		When creating a template from a SIP, delete all metadata except those marked with "keepInTemplate='true'".
 * mets.dmdsec.DMDSectionWithEAD: When creating a new node, set the unitTitle to the node's label (= file name), if the node is a folder.
 * 		If the node is a file, cut away the label's extension.
 * ead.C, ead.DID, ead.ComponentAbstract, ead.EADNodeAbstract:
 * 		When deleting some dynamic metadata, delete the parent element if empty.
 * mdconfig.LevelOfDescription, structmap.NodeFolder, structmap.NodeFile:
 * 		Levels have now a default sublevel.
 * 		Initialization of a new subelement's level to the parent level's defaultSubLevel. Before: "Undefined".
 * mets.Document: Added methods isValidSIPFolder(File) and isValidSIPFolder(String).
 *
 * 2.9.4 (Denis, 08.10.2012):
 * Use Docutools 1.6.4.
 * mets.Document: Locking.
 * mets.Document: Refactoring instance variables "filePath" and "originalSipFolder". Added variables "isWorkingFolder" and "lockedBy".
 * ead.MetadataElementInstance: Avoid overwriting a value with the same value, marking the document wrongly as "modified".
 * mets.Document, mets.structmap.StructureMap: New method "hasNodesWithDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()" :-)
 * mdconfig.LevelOfDescription, mdconfig.MetadataElement, config/levels.xml, config/levels.xsd:
 * 		Add element "AllowedValuesSeparator" to element "MetadataElements" in "levels.xml".
 * mdconfig.LevelMetadataElement, config/levels.xml, config/levels.xsd:
 * 		Add attribute "displayRows" to element "LevelMetadataElement" in "levels.xml".
 * Use Docutools 1.6.5 with class NextNumber.
 * mets.structmap.NodeFolder: Add method boolean isPredecessorOf(NodeAbstract).
 * mets.Document: It is now possible to set a backup folder where all backups are made into.
 * mets.Document: Correction in the template handling: Unlock the template and cleanup after creating a template.
 *
 * 2.9.3 (Denis, 19.09.2012):
 * Use Docutools 1.6.3.
 * ead.C, ead.DID, config_dist/levels.xml: Integrate all remaining dynamic metadata fields.
 * ead.MetadataElement: Refactoring: renamed to ead.MetadataElementInstance.
 * structmap.NodeAbstract: Handling of mandatory AND repeatable dynamic metadata.
 * mets.Document, mets.amdsec.AMDSection, mets.amdsec.DigiprovAbstract: Create a SIP out of a template, create a template out of a SIP.
 *
 * 2.9.2 (Andreas, 28.08.2012):
 * Use Docutools 1.6.2 (with possibility to set different DROID signature file).
 *
 * 2.9.1 (Denis, 07.08.2012):
 * ead.Header: Correction: Mark the document as isModified when the eadId is being set.
 * config_dist/levels.xml: Define the Docuteam standard levels.
 *
 * 2.9.0 (Denis, 06.08.2012):
 * NOTE: The interface changed because the LevelOfDescriptions are now read from an xml-file and not any more from a csv-file!
 * ead.DataElement, ead.LevelDataElement: new classes for dynamic metadata properties.
 * ead.LevelOfDescription: Extend to contain LevelMetadataElements and allowedSubLevels.
 * ead.MetadataElementValidator: Interface to validate DataElements.
 * ead.MetadataElementValidatorAlwaysOK: Example implementation of DataElementValidator which always returns 'OK' (that is: null).
 * ead.MetadataElementValidatorAlwaysNOK: Example implementation of DataElementValidator which always returns 'Not OK' (that is: an error Message).
 * ead.MetadataElementTester: Temporary class during development.
 * ead.LevelMetadataElement: Class to join a LevelOfDescription with a MetadataElement.
 * mets.structmap.NodeAbstract: Add methods for the level logic.
 * ead.C: Add methods to access dynamic metadata.
 * mets.structmap.NodeAbstract: Add methods to access dynamic metadata.
 * exceptions.MetadataElementValidatorException: New exception class indicating that a validator rejected a value.
 * ead.MetadataElementValidatorDate: Implementation of DataElementValidator which accepts only date strings in 'yyyy-mm-dd' format.
 * ead.MetadataElementValidatorYear: Implementation of DataElementValidator which accepts only a 4-digit number.
 * ead.*, mdconfig.*: Refactoring: moved some classes from package ead to package mdconfig.
 * ead.MetadataElement: Created new class.
 * util.JavaInterpreter: Created new class.
 * lib.bsh-core-2.0b4.jar: New lib (BeanShell) for the JavaInterpreter.
 * ead.MetadataElement: Dynamic Metadata logic.
 * mets.dmdsec.DMDSectionWithEAD: The C element is now (optionally) nested within an EAD:ead element.
 * mets.structmap.NodeAbstract: Clear unneeded metadata values when switching level of description.
 * mets.Document: Corrected bug: In some circumstances the original SIP folder was deleted on cleanup.
 * mets.Document: Can now create a new SIP as a FOLDER. Before, only new SIPs as ZIPs were possible.
 * apps_dist/*: Both OpenOffice.org packages (OS X and Windows) replaced by the current version 3.4.
 * mets.Document: When creating a new SIP, throw an exception if the destination folder already exists and is not empty.
 * exceptions.FolderIsNotEmptyException: Created new class.
 * structmap.Node*, mdconfig.MetadataElement, mdconfig.LevelMetadataElement:
 * 		Initialization of mandatory dynamic metadata elements happens now only when a new file or folder gets inserted into the tree.
 * 		MetadataElements are listed in the order in which they appear in the level.xml file.
 * structmap.NodeAbstract: Detach a node's label (= fileName) from its unitTitle. Initialize the unitTitle with the fileName omitting the file extension.
 * mdconfig.MetadataElement: When validating dynamic metadata elements, always allow null value.
 * Use Docutools 1.5.5. This version includes the possibility to suppress the automatic popping-up of the SystemOutView when output occurs.
 * structmap.NodeAbstract: Added method hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet().
 * mdconfig.MetadataElement: Correction in methods isMandatoryButNotSet() and isMandatoryOrSet() (empty string is equivalent to null).
 * util.FileConverter.OOConverter: Added methods: initializeDontWait(...) to initialize OOConverter without waiting until initialization is finished.
 * Use Docutools 1.5.6.
 * ead.ComponentAbstract, ead.C, ead.ArchDesc, structmap.NodeAbstract: AccessNr is now a dynamic metadata field.
 * ead:MetadataElement: Correction in method boolean isMandatoryOrSet().
 * licences.*: Added required software licenses to the project.
 * mets.Document: Use FileUtil.deleteOnExit() instead of File.deleteOnExit() because the latter doesn't work on non-empty folders.
 * Use Docutools 1.6.0.
 *
 * 2.8.2 (Denis, 23.05.2012):
 * Use Docutools 1.5.1.
 * mets.Document, mets.structmap.NodeAbstract: When reading a METS-file with files the current user can't read, don't throw an exception but set a flag in NodeAbstract and document.
 * mets.structmap.NodeAbstract: Has now four new attributes: canRead, canWrite, canExecute, and fileExists.
 * mets.structmap.NodeAbstract: Add method 'filesAndFoldersNotReadableByCurrentUser()' that returns all files and folders the current user is not allowed to read.
 *
 * 2.8.1 (Andreas, 16.05.2012):
 * VirusScannerClam: will now hand over file references to clamd instead of streaming the files through the socket (which is still available as a separate method).
 * Document: set the working directory of a sip to be deleted on exit.
 *
 * 2.8.0 (Denis, 15.05.2012):
 * mets.structmap.StructureMap, NodeAbstract, NodeFolder, NodeFile: Method searchLabel(String) now returns a List<NodeAbstract> instead of a NodeAbstract.
 * mets.Document: Set the property "isModified" whenever something changes, and clear it on save.
 *
 * 2.7.5 (Denis, 11.05.2012):
 * mets.DocumentAbstract: Has now a MessageDistributor to be able to send messages to any Observer who is interested in.
 * 						  When inserting files and folders, distribute via MessageDistributor the filename currently inserting.
 * Use Docutools 1.5.0.
 * util.FileConverter$OOConverter: Destroy the OOConverter process when disconnecting from the OOConverter service.
 * mets.structmap.NodeFile: Bug fix when migrating a file where the destination file already exists.
 *
 * 2.7.4 (Denis, 13.04.2012):
 * Use Docutools 1.4.11.
 * When using a temporary folder, use now FileUtil.getTempFolder().
 * Bug Fix in Docutools.util.FileUtil.
 *
 * 2.7.3 (Denis, 29.03.2012):
 * config.document-formats.xml, config.migration-config.xml: Added docm and xlsm so that util.FileConverter can handle MS Word documents and MS Excel sheets that contain macros.
 * util.FileConverter: If the destination file name of a conversion alrady exists, append the current timestamp to the filename.
 * sa.SubmissionAgreement: After downloading the current SAs from the server, return the list of SA file names that are NOT on the server. The caller might want to delete them.
 * Use Docutools 1.4.10.
 *
 * 2.7.2 (Denis, 06.03.2012):
 * ead.C and ead.ArchDesc: Place the dao element BEHIND the did element.
 * All sources: Changed the copyright message from 2011 to 2011-2012.
 *
 * 2.7.1 (Denis, 20.02.2012):
 * Use Docutools 1.4.7.
 * structmap.NodeFolder: Handle correctly inserting files and folders from a drive (like "D:/")
 *
 * 2.7.0 (Denis, 09.02.2012):
 * mets.Document: Allow reading a SIP without creating a working copy. In this case, all operations manipulating files are not allowed.
 * Created: exception.FileOperationNotAllowedException.
 * Created: common.DocumentAbstract: New superclass of mets.Document and ead.Document.
 * mets.Document: Introduce a boolean variable 'isModified' that indicates whether this document was modified or not.
 * Use Docutools 1.4.6.
 *
 * 2.6.5 (Denis, 26.01.2012):
 * sa.SubmissionAgreement.updateSAsFromServer(): Removed catch() statements because the method should throw exceptions rather than catch them.
 * structmap.NodeFolder: Added method boolean doesLabelHaveNumericPrefix();
 *
 * 2.6.4 (Denis, 20.12.2011):
 * ead.*: EAD export: Export with levelsOfDescription and acquisitionNo. Refactoring and cleanup.
 * ead.*: EAD export: Export with PID (= EAD:dao xlink:href).
 *
 * 2.6.3 (Denis, 08.12.2011):
 * ead.C: Contains now an acqinfo element.
 *
 * 2.6.2 (Denis, 07.12.2011):
 * Renamed class ead.ComponentOtherLevel to ead.LevelOfDescription.
 * Corrected bug in ead.LevelOfDescription: When initialized, the "Undefined" Level is now the 1st level in the list. Before, it was exactly "undefined".
 * mets.structmap.NodeAbstract: Added convenience methods getLevel() and setLevel(LevelOfDescription).
 * mets.structmap.NodeAbstract: Added methods getAcquisitionNo() and setAcquisitionNo(String).
 * mets.structmap.NodeAbstract and subclasses: Added methods getDepth() and getTreeDepth().
 * mets.structmap.NodeAbstract and subclasses: Added method getWithDescendants().
 *
 * 2.6.1 (Denis, 06.12.2011):
 * ead.C: Extend with DAO.
 * Added class: ead.ComponentOtherLevel.
 * ead.C: Extend with mutable "otherlevel".
 *
 * 2.6.0 (Denis, 29.11.2011):
 * structMap.NodeAbstract: Renamed method getEvents() to getMyEvents() and getEvent(i) to getMyEvent(i).
 * structMap.NodeAbstract: Generate an associated DMDSectionWithEAD automatically when none is already present.
 * structMap.NodeAbstract: Handle associated DMDSectionWithEAD when inserting, deleting, renaming, and migrating files and folders.
 * structMap.StructureMap: Allow temporarily null as root.
 *
 * 2.5.2 (Denis, 24.11.2011):
 * Refactoring: Overall unification of method names and great cleanup.
 *
 * 2.5.1 (Denis, 22.11.2011):
 * Added classes: mets.dmdsec.DMDSectionGeneric and mets.dmdsec.DMDSecionWithEAD.
 * Refactoring in classes: ead.*
 * mets.Document: Added method: insertDMDSectionWithEADsForAllFiles(). A METS-file can now be extended with dmdsecs that contain EAD.
 *
 * 2.5.1 (Andreas, 05.01.2012):
 * Extended OOConverter to be able to use external configuration file (default: config/document-formats.xml).
 *
 * 2.5.0 (Denis, 16.11.2011):
 * sa.SubmissionAgreement: deleted static method getOverview().
 * sa.SubmissionAgreement: added method getOverviews() and static method getAllFinalOverviews(), each returning a List<Overview>.
 * Use DocuTools 1.4.1.
 * build.xml: Rename project from DocuDarc to Docudarc.
 *
 * 2.4.4 (Denis, 14.11.2011):
 * sa.SubmissionAgreement: Get SA overview from the SAs that are currently in the SA folder.
 * sa.SubmissionAgreement: Added static method initializeBaseURL(String) to initialize URL for both updateSAsFromServer() AND openAsHTMLExternally().
 *
 * 2.4.3 (Denis, 11.11.2011):
 * sa.SubmissionAgreement: Don't use environment variable "SUBM_AGR_DIR" any more, but the static method setSAFolder(String) to set the SA folder.
 * sa.SubmissionAgreement: Added static method updateSAsFromServer(String remoteSADirName) to update the SAs from the network.
 * mets.Document: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMETS_SIPTemplateFile(String) to set the SIP Template file location.
 * ead.EAD: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setEADTemplateFile(String) to set the EAD Template file location.
 * util.FileConverter: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMigrationConfigFile(String) to set the migration-config file location.
 * util.FileConverter: Don't use environment variable "DOCUDARC_HOME" any more, but the static method setMigrationHomeFolder(String) to set the migration home folder.
 *
 * 2.4.2 (Denis, 09.11.2011):
 * log4j.xml: Add encoding parameter.
 *
 * 2.4.1 (Denis, 07.11.2011):
 * Use DocuTools 1.4.0.
 * mets.structmap.StructureMap: Throw exception when a METS file has no root element.
 * mets.Document: Added accessors needed by DocuPack.
 *
 * 2.4.0 (Denis, 07.11.2011):
 * Changed class mets.Document: Removed the possibility to open a METS document without a working copy. Thus the interface changed significantly.
 * Changed class mets.Document: Removed the possibility to save a METS document with a different METS file name (saveAs()). Thus the interface changed significantly.
 * Changed class mets.Document: Added Method saveTo() to save a copy of the SIP somewhere else.
 *
 * 2.3.3 (Denis, 03.11.2011):
 * Use DocuTools 1.3.17.
 *
 * 2.3.2 (Denis, 02.11.2011):
 * Fixed a bug in util.VirusScannerClam: in the rare case that the FileStream chunk size fits exactly into the file size, an IndexOutOfBounds exception was thrown.
 * Use DocuTools 1.3.16.
 * There are some weird problems with locked files under windows.
 *
 * 2.3.1 (Denis, 01.11.2011):
 * Removed classes: FileChecksumCalculator, FileWithMetadata, MetadataProviderDROID, MetadataProviderJHOVE, MetadataFromJPGFile (moved to Docutools)
 *
 * 2.3.0 (Denis, 26.10.2011):
 * MetadataProviderDROID: Moved from DROID Version 4 to Version 5. The interface changed significantly!
 * Added Copyright message to all source files.
 *
 * 2.2.10 (Andreas, 21.10.2011):
 * Use DocuTools 1.3.13
 * MetadataProviderDROID: look for config file in DOCUDARC_HOME first
 *
 * 2.2.9 (Andreas, 22.09.2011):
 * Use DocuTools 1.3.11
 * MetadataProviderDROID: Do not update DROID automatically
 *
 * 2.2.8 (Andreas, 25.08.2011):
 * Changed default chunk size for virus scanner streams
 *
 * 2.2.7 (Denis, 29.07.2011):
 * Using DocuTools 1.3.6.
 * Extend build.xml with target 'distWithOpenOfficeForOSXAndWindows'.
 * Renamed folder config_gen to config_dist and adapted build.xml accordingly.
 * Added folder apps_dist that contains the OOO Apps zipped for distribution.
 * Improved error message when the OOO App for converting files is not found.
 *
 * 2.2.6 (Denis, 26.07.2011):
 * Use DocuTools 1.3.5 (bug fix in class JTableWithDynamicToolTipTexts)
 *
 * 2.2.5 (Denis, 25.07.2011):
 * In folder 'app' the two OOO-packages are now zipped. On distribution they get unzipped.
 *
 * 2.2.4 (Denis, 25.07.2011):
 * Create an EAD-file from a METS-file.
 * EAD UnitTests.
 *
 * 2.2.3 (Andreas, 22.07.2011):
 * Undo previously commited config files
 *
 * 2.2.2 (Andreas, 22.07.2011):
 * Use DocuTools 1.3.4 (for zip files >4GB)
 *
 * 2.2.1 (Denis, 21.07.2011);
 * Refactoring in EAD package.
 * Can now insert new elements into the EAD.
 *
 * 2.2.0 (Denis, 20.07.2011);
 * Added EAD package.
 *
 * 2.1.30 (Denis, 20.07.2011):
 * Some UnitTests and the migration-config files had to be adapted because of the new DROID_SignatureFile_V51.
 * Refactoring: Moved class NodeAbstract from package 'mets.common' to 'common'.
 *
 * 2.1.29 (Andreas, 07.07.2011):
 * Implemented node type "rootfile"
 * bugfix virusscan unittest
 *
 * 2.1.28 (Denis, 07.07.2011):
 * Include OOO into project.
 *
 * 2.1.27 (Denis, 30.06.2011):
 * Use DocuTools 1.3.3.
 *
 * 2.1.26 (Denis, 24.06.2011):
 * util.FileConverter$OOConverter: Corrections and more flexible initialization.
 *
 * 2.1.25 (Denis, 20.06.2011):
 * Use DocuTools 1.3.2.
 * util.FileConverter$OOConverter: Use either an internal or a pre-installed OOO-Service. Improve and accelerate the initialization.
 *
 * 2.1.24 (Denis, 15.06.2011);
 * Use DocuTools 1.2.14.
 * Cleanup: Corrected some code showing warnings.
 *
 * 2.1.23 (Andreas, 09.06.2011):
 * Use DocuTools 1.2.13.
 *
 * 2.1.22 (Denis, 08.06.2011):
 * Use DocuTools 1.2.12.
 *
 * 2.1.21 (Denis, 30.05.2011):
 * Use DocuTools 1.2.10.
 * util.FileConverter$OOConverter: Made class and some of its methods public, to be used by other classes.
 *
 * 2.1.20 (Denis, 27.05.2011):
 * New class: util.VirusScannerClam
 *
 * 2.1.19 (Denis, 25.05.2011):
 * Use DocuTools 1.2.9.
 *
 * 2.1.18 (Denis, 18.05.2011):
 * structMap.NodeAbstract: Marked two unnecessary methods as deprecated (getRelativeSizeBar() and getRelativeSizeBar(int));
 *
 * 2.1.17 (Denis, 18.04.2011):
 * New class: structMap.FileAlreadyExistsException, used in structmap.NodeFolder.
 * Don't throw generic Exception any more, but more specific ones.
 *
 * 2.1.16 (Denis, 15.04.2011):
 * sa.SubmissionAgreement: added method openAsHTMLExternally() to display itself as HTML in the browser (requires to be initialized with the BaseURL)
 *
 * 2.1.15 (Denis, 12.04.2011):
 * sa.SubmissionAgreement: read(): throw 3 different Exceptions instead of 1 generic.
 * util.FileConverter: In migration_config.xml, 'parameter="..."' can now be in element "application" OR in element "mimeType", where "mimeType" takes precedence over "application".
 * sa.SubmissionAgreement: openExternally() prepared (not yet finished)
 *
 * 2.1.14 (Denis, 08.04.2011):
 * Don't use System.getenv() any more but only EnvironmentVariable.get...().
 *
 * 2.1.13 (Andreas, 08.04.2011):
 * mets.amdsec.AMDSection: Insert a amdSec at the correct position
 * mest.structmap.NodeAbstract: Add a digiprovMD element for a node if there is none
 *
 * 2.1.12 (Denis, 08.04.2011):
 * Use DocuTools 1.2.7.
 * New class: exception.BadPronomTypeException, used in util.FileConverter.
 *
 * 2.1.11 (Denis, 07.04.2010):
 * Use DocuTools 1.2.6.
 * util.FileConverter: location of migrationConfig file can be chosen.
 *
 * 2.1.10 (Denis, 04.04.2011):
 * util.FileConverter: Handles correctly file migrations while retaining the original files
 * util.FileConverter: Prepare restructuring the migration_config.xml file
 * util.FileConverter: Prepare getting rid of the conversion scripts in the bin folder
 *
 * 2.1.9 (Denis, 29.03.2011):
 * util.FileConverter: JODConverter is now utilized using the Java API and not the command line interface any more.
 * util.FileConverter: Can now handle conversions that consist of multiple steps
 * Added numerous libraries required by the JODConverter class.
 *
 * 2.1.8 (Denis, 28.03.2011):
 * mets.Document: Correction: document type is set when a new SIP is created
 * mets.Document: Correction: after reading a METS-file, the ExceptionCollector was cleared, what was wrong. Now the ExceptionCollector is left as is.
 *
 * 2.1.7 (Andreas, 28.03.2011):
 * mets.Document: added setType method
 *
 * 2.1.6 (Denis, 25.03.2011):
 * Use DocuTools 1.2.5.
 * mets.Document: filter out hidden files on import and creation
 * mets.Document: added method filesNotAllowedBySubmissionAgreement() that lists all FileNodes not compliant with the SA.
 *
 * 2.1.5 (Denis, 24.03.2011):
 * mets.Document: removed method createNewWithRootElement(...) and replaced it by createNewZIPWithRootElement(...).
 * That means that when a new SIP is created, it is packed into a ZIP archive.
 *
 * 2.1.4 (Andreas, 23.03.2011):
 * Updated Droid library
 * modified build process to create standard jar file
 *
 * 2.1.3 (Denis, 23.03.2011):
 * mets.Document can now insert a DC file even when the namespace in that file is spelled in lowercase letters.
 * Refactored classes dc.DC and dc.OAI_DC.
 * util.FileConverter doesn't use a working folder any more -> conversions are much faster
 * Use DocuTools 1.2.4.
 *
 * 2.1.2 (Denis, 21.03.2011):
 * Extend util.FileConverter to remember the name of the recently used file converter (this is needed in DocuMill).
 * Use DocuTools 1.2.3.
 *
 * 2.1.1 (Denis, 16.03.2011):
 * When the submission agreement can not be loaded, an Exception is now added to the ExceptionCollector (before: an Exception was thrown).
 * Use DocuTools 1.2.2.
 *
 * 2.1.0 (Denis, 11.03.2011):
 * When the submission agreement does NOT accept a file, an Exception is now added to the ExceptionCollector (before: an Exception was thrown, interrupting the operation).
 */
public abstract class Version
{
	static public final String Product = "docuteam darc";
	static public final String Number = "2.18.2";
	static public final String LastChange = "01.11.2016";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args No parameters are expected.
	 */
	public static void main(String[] args)
	{
		if (Arrays.asList(args).contains("-v")) {
			System.out.println(ch.docuteam.darc.admin.Version.Product + ": " + ch.docuteam.darc.admin.Version.Number + " (" + ch.docuteam.darc.admin.Version.LastChange + ")");
			System.out.println(ch.docuteam.tools.admin.Version.Product + ": " + ch.docuteam.tools.admin.Version.Number + " (" + ch.docuteam.tools.admin.Version.LastChange + ")");
		} else
			System.out.println(Number);
	}
}
