/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.mets.Document;

/**
 * This exception gets thrown when the attempt is made to modify or save a
 * read-only SIP.
 *
 * @author denis
 *
 */
public class DocumentIsReadOnlyException extends Exception {

	/**
	 * @deprecated Use constructor
	 *             "DocumentIsReadOnlyException(String sipName) instead."
	 */
	@Deprecated
	public DocumentIsReadOnlyException() {
		super("This SIP can't be modified because it was opened in read-only mode");
	}

	public DocumentIsReadOnlyException(Document doc) {
		super("The SIP '" + doc.getOriginalSIPFolder() + "' can't be modified because it was opened in read-only mode");
	}

}
