/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;

/**
 * Interface to specify classes that can be used to execute a post-action after
 * a MetadataElement value has been changed.
 *
 * @author denis
 *
 */
public interface MetadataElementSetterPostAction {
	/**
	 * Perform some action after the metadata value has been changed.
	 * 
	 * @param oldValue
	 *            The previous metadata value.
	 * @param newValue
	 *            The new metadata value.
	 * @param context
	 *            The node the value belongs to, in the case that this
	 *            post-action needs the context.
	 * @param metadataElement
	 *            The metadata element containing the new value.
	 * @param index
	 *            The index position of the metadata element changed (usually 0,
	 *            if repeatable, >= 0).
	 */
	public void execute(String oldValue, String newValue, NodeAbstract context, MetadataElement metadataElement,
			int index) throws MetadataElementSetterPostActionException;

}
