/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa.archive;

import java.util.List;

import org.dom4j.Element;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.Contact;
import ch.docuteam.darc.sa.common.NodeAbstract;

/**
 * This class, used by
 * <a href="../SubmissionAgreement.html">SubmissionAgreement</a>, represents a
 * ???. It contains an ISIL (International Standard Identifier for Libraries)
 * and a list of <a href="./Contact.html">Contacts</a>.
 *
 * @author denis
 *
 */
public class Archive extends NodeAbstract {
	private String isil;
	private List<Contact> contacts;

	private Archive(SubmissionAgreement sa, Element element) {
		this.sa = sa;
		this.element = element;

		this.isil = this.element.attributeValue("isil");
		this.contacts = Contact.parse(this.sa, this.element);
	}

	static public Archive parse(SubmissionAgreement sa, Element parent) {
		return new Archive(sa, (Element) parent.selectSingleNode("./SA:archive"));
	}

	public String getIsil() {
		return this.isil;
	}

	public List<Contact> getContacts() {
		return this.contacts;
	}

	@Override
	public String toString() {
		StringBuilder stringBuilder = new StringBuilder("[Archive:").append(this.isil);

		for (Contact c : this.contacts)
			stringBuilder.append(c);

		return stringBuilder.append("]").toString();
	}

}
