/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.sa.producer;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.Contact;
import ch.docuteam.darc.sa.common.NodeAbstract;

/**
 * This class, used by
 * <a href="../SubmissionAgreement.html">SubmissionAgreement</a>, represents a
 * ???. It contains a list of <a href="../common/Contact.html">Contacts</a>.
 *
 * @author denis
 *
 */
public class Producer extends NodeAbstract {

	private List<Contact> contacts;

	private Producer(SubmissionAgreement sa, Element element) {
		this.sa = sa;
		this.element = element;

		this.contacts = Contact.parse(this.sa, this.element);
	}

	static public List<Producer> parse(SubmissionAgreement sa, Element parent) {
		List<Producer> producers = new ArrayList<Producer>();

		for (Object o : parent.selectNodes("./SA:producer"))
			producers.add(new Producer(sa, (Element) o));

		return producers;
	}

	public List<Contact> getContacts() {
		return this.contacts;
	}

	@Override
	public String toString() {
		StringBuilder stringBuilder = new StringBuilder("[Producer:");

		for (Contact c : this.contacts)
			stringBuilder.append(c);

		return stringBuilder.append("]").toString();
	}

}
