/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.converter.admin;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * Version 1.4.0
 * 10.10.2016:
 * - bump to next minor version (additional functionality)
 * - handle file extensions when migrating to folder
 * - upgrade dependency for docuteam-tools to 1.11.5
 * - fix exception handling for PDF-Tools Document Converter
 * 31.08.2016 (Iliya/Andreas):
 * - handle conversions which return multiple files for a single file
 * 26.07.2016 (Andreas):
 * - bump to new bugfix version
 *
 * Version 1.3.0
 * 26.07.2016 (Andreas):
 * - upgrade dependency for docuteam-tools to 1.11.4
 * - update DLLs and API library for document converter 4.8.x
 * 01.07.2016 (Andreas):
 * - exception handling: FileConverter will not deal with specific exceptions from classes called by reflection
 * - slightly modified logging
 * - bump to new minor version (changes in exception handling)
 * 28.06.2016 (Iliya):
 * - PDF tools can accept now job options and when the conversion fails it stops at the thrown Exception
 * 30.03.2016 (Andreas):
 * - bump to new bugfix version
 *
 * Version 1.2.3
 * 30.03.2016 (Andreas):
 * lib/docuteam-tools-1.11.1.jar: update to current version, changes since version 1.10.9:
 * 		- translations.I18N: extended to load several resource bundles per language
 * 		- config_dist/container-signature-20160121.xml, config_dist/DROID_SignatureFile_V84.xml, file.MetadataProviderDROID: update to current DROID signature files
 * 		- file.FileChecksumCalculator: add checksum calculations for SHA-256 and SHA-512
 * 		- file.FileWithMetadata:
 * 			- extend with new checksums
 * 			- set the defaultChecksumAlgorithm to MD5 and add a setter method to change this
 * 		- file.MetadataProviderJHOVE: disable checksum calculation and remove respective methods
 * 23.03.2016 (Andreas):
 * config_dist/migration-config*.xml: include fmt/645 as regular jpg
 * 29.02.2016 (Andreas):
 * admin.Version: bump to new bugfix version
 * 
 * Version 1.2.2
 * 29.02.2016 (Christian):
 * converter.FileConverter: check not only the filename but the whole file's pathname for conflict with the command separator of migration-config.xml
 * 20.01.2016 (Christian):
 * converter.FileConverter: if temporary file is used for migration, put it into temporary folder named with thread id to avoid conflicts with concurrent processes
 * 
 * Version 1.2.1
 * 26.10.2015 (Andreas):
 * lib/docuteam-tools-1.10.9:
 * 		- file.FileUtil, file.FileWithMetadata, file.MetadataProviderDROID, file.MetadataProviderJHOVE, file.PropertyFile, os.OSXAdapter: replace any Exception.printStackTrace() to proper logging calls
 * 06.10.2015 (Andreas):
 * - unittest.FileConverter: additional test with JPEG2000 and DIB (kind of BMP, needs special parameters) file.
 *
 * Version 1.2.0
 * 08.09.2015 (Andreas):
 * admin.Version: bump to new minor version
 * unittest.FileConverter_PDFToolsConverter: use URL from system properties
 * lib/DCVE.jar, dll/*: updated libraries for PDF-Tools Document Converter version 4.4
 * 
 * Version 1.1.1
 * 08.09.2015 (Andreas):
 * - unittest/files/config/migration-config_*.xml: fix expected output of ghostscript 9.16 to fmt/19 (Win and OSX)
 * 28.08.2015 (Andreas):
 * lib/docuteam-tools-1.10.8: Use final tagged version
 * 		- file.FileUtil: fix basicCopyTo method to ignore copying if source equals destination
 * lib/docuteam-tools-1.10.7: Use final tagged version
 * 		- lib/log4j-1.2.17.jar: updated version
 * 		- lib/commons-codec-1.9.jar: dependency of poi-3.11-20141221.jar
 * 16.08.2015 (Andreas):
 * unittest.converter.FileConverter_PDFToolsConverter: use 192.168.0.74 as test server for pdf-tools
 * 14.07.2015 (Christian):
 * config_dist/migration-config_with-pdf-tools.xml: added for use with pdf-tools
 * config_dist/migration-config.xml: added entries for postscript
 * 15.04.2015 (Andreas):
 * admin.Version: initialized new version
 *
 * Version 1.1.0:
 * 09.04.2015 (Andreas):
 * reintegrate branch "20150407_eug_fileformats_without_migration":
 * 		- FileConverter: skip migration if no applicationID is provided in migration-config.xml (including related unittests)
 * 08.04.2015 (Andreas):
 * lib/docuteam-tools-1.10.6: Use final tagged version
 * 		- config/*: updated DROID signature files
 * 		- string.StringUtil: new method isDecimal(String)
 * 		- lib/droid*: clean droid libraries
 * 31.03.2015 (Andreas):
 * change version to 1.1.0
 * integrate branch from /branches/20150331-nf-use-intermediary-name-as-target:
 * 		- FileConverter:
 * 			- Use a unique temporary filename as conversion target, then rename it to the correct name
 * 			- Do not duplicate the extension even if the output file will have the same name as the input file
 * 			- Cleanup commented code
 * 		- unittest.FileConverter:
 * 			- include ghostscript for pdf conversion
 * 			- expect PDF/A output from OpenOffice
 * 		- unittest/files/config/migration-config_OSX.xml: expect PDF/A output from OpenOffice
 * 31.03.2015 (Andreas):
 * integrate branch from /branches/targetPronom with several values ce:
 * 		- FileConverter: accept multiple target pronom IDs now (comma separated)
 * 		- unittest.converter.FileConverter_MultiplePuids: proper tests with pdf examples that return different output formats
 * 		- unittest.converter.FileConverter_ParameterSeparator: renamed class
 * 		- unittest.converter.FileConverter: expect PDF/A as output from OpenOffice
 * 		- unittest/files/config/migration-config_*.xml: expect PDF/A as output from OpenOffice
 * 		- unittest/files/config/migration-config_pdf*.xml: remove unnecessary config files
 * 		- unittest/files/FileConverterMultiplePuids: added testfiles
 * 10.03.2015 (Andreas):
 * lib/docuteam-tools-1.10.6.jar: use most recent version with string.StringUtil.isDecimal(string)
 * 24.02.2015 (Christian):
 * config_dist/migration-config.xml, unittest/files/config/migration-config_Linux.xml, unittest/files/config/migration-config_OSX.xml, unittest/files/config/migration-config_Win.xml, unittest/files/config/migration-config_pdf_Linux.xml, unittest/files/config/migration-config_pdf_OSX.xml, unittest/files/config/migration-config_pdf_Win.xml: changed ghostscript parameter to -sColorConversionStrategy=/UseDeviceIndependentColor#
 * 17.02.2015 (Andreas):
 * build.xml: set java compatibility to 1.7
 * lib/docuteam-tools-1.10.6.jar: use java 1.7 compatible build
 * 13.02.2015 (Andreas):
 * lib/*: use most recent docuteam tools library with modified DROID libraries
 * 09.02.2015 (Christian):
 * lib/docuteam-tools: updated to version 1.10.5 (now really)
 * 28.01.2015 (Christian):
 * lib/docuteam-tools: updated to version 1.10.5
 * lib/droid-*: updated to version 6.1.5
 * lib/poi: updated to version 3.11
 * build.xml compiler settings updated to java 8
 *
 * Version 1.0.3:
 * 12.11.2014 (Andreas):
 * Use tagged version of tools 1.10.4:
 * 		file.FileUtil: add method to get the human readable size of a file
 * 		util.JavaInterpreter: set method execute(Object, String) as deprecated; changed method execute(Object, Object, String) to method using varargs as: execute(String, Object...)
 * 05.09.2014 (Andreas):
 * Use current version of tools 1.10.4 with updated license information
 * licenses/*: general cleanup
 * 01.09.2014 (Andreas):
 * unittest.files.config.migration-config_*.xml: correct windows paths
 *
 * Version 1.0.2:
 * 27.08.2014 (Christian):
 * Changed dependency from docuteam-tools-1.10.2 to docuteam-tools-1.10.3.
 * 14.07.2014 (Christian):
 * Added constant DefaultCommandlineSeparator to converter.FileConverter
 * Added constant AlternativeCommandlineSeparators to converter.FileConverter
 * Added function determineApplicableSeparator. Determines a separator (one of AlternativeCommandlineSeparator and DefaultCommandlineSeparator that is not used in the name of the file to be converted.
 * 23.05.2014 (Denis):
 * Use current version of tools 1.10.2 with extension:
 * 		added new method: File EnvironmentVariable.getFileTryCurrentContextFirst(String environmentVariableName, String relativeFileName). Returns File or null if resulting file does not exist.
 * 29.04.2014 (Andreas):
 * Version 1.0.2 initial.
 *
 * Version 1.0.1:
 * 29.04.2014 (Andreas):
 * Use current version of tools 1.10.1 with extension:
 * 		updated DROID signature file to enhance support for PDF/A
 * 15.04.2014 (Denis):
 * Use current version of tools 1.10.1 with extension:
 * 		out.Logger: Added public method getLogger() that returns the logger for the calling class. When using this method, it is possible
 * 				to output the name and line number of the method where the logging is issued in.
 * 		exception.Exception, exception.ExceptionCollector: Improve output as String.
 * 04.04.2014 (Denis):
 * Version 1.0.1 initial.
 *
 * Version 1.0.0:
 * 04.04.2014 (Denis):
 * Use tagged version of tools 1.10.0.
 * Tagged as Version 1.0.0.
 * 03.04.2014 (Andreas):
 * FileConverter: remove code that will append all available information as parameters, even if they were not specified in the configuration
 * config/migration-config.xml: add usage information, add "flac" file format, add application definition for PDF-Tools, disable video migration by default, clean formatting
 * unittest/migration-config_XXX.xml: clean formatting
 * 02.04.2014 (Denis):
 * Use current version of tools 1.10.0.
 * 28.03.2014 (Andreas):
 * unittest.converter.FileConverter_PDFToolsConverter: use test instance of PDF-Tools service
 * 27.03.2014 (Andreas):
 * config/migration-config.xml: simplify default parameters for openoffice
 * 26.03.2014 (Andreas):
 * extend with openoffice for linux
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess: Throw specific exception when Desktop can't launch or associate an application with a file. * 21.03.2014 (Andreas):
 * extend migration-config files.
 * FileConverter: define some methods as public: calculateDestinationFilePath, getMigrationInstructions
 * 21.03.2014 (Günter):
 * update migration-config with word perfect puid and mimetype
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 05.03.2014 (Denis):
 * unittest.converter.*: Adapted unittests for Linux.
 * Use current version of tools 1.10.0.
 * 04.03.2014 (Denis):
 * FileConverter$PDFToolsConverter: The PDFToolsConverter now checks by himself if the required VM argument "-Djava.library.path" exists and points to the correct folder.
 * 27.02.2014 (Denis):
 * FileConverter: Handle too long file paths under Windows by performing the conversion in the temp folder.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * 13.02.2014 (Denis):
 * FileConverter$PDFToolsConverter: Include PDFTools Converter.
 * 12.02.2014 (Denis):
 * Initial version 1.0.0.
 *
 */
public abstract class Version
{
	static public final String Product = "docuteam converter";
	static public final String Number = "1.4.0";
	static public final String LastChange = "10.10.2016";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args No parameters are expected.
	 */
	public static void main(String[] args)
	{
		System.out.println(Number);
	}
}
