/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.mdconfig.LevelOfDescription;

/**
 * This exception gets thrown when an attempt is made to change the meetadata
 * value although the corresponding LevelMetadataElement is read-only.
 *
 * @author denis
 *
 */
public class LevelMetadataElementIsReadOnly extends Exception {

	private LevelOfDescription level;
	private String mdElementName;

	public LevelMetadataElementIsReadOnly(LevelOfDescription level, String mdElementName) {
		super("Can not change metadata element '" + mdElementName + "' because it is read-only in level '"
				+ level.getName() + "'");

		this.level = level;
		this.mdElementName = mdElementName;
	}

	public LevelOfDescription getLevel() {
		return this.level;
	}

	public String getMdElementName() {
		return this.mdElementName;
	}

}
