/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.exceptions;

import ch.docuteam.darc.mdconfig.LevelOfDescription;

/**
 * This exception gets thrown when a metadata element is referenced which is not
 * configured (= not allowed) for this level.
 *
 * @author denis
 *
 */
public class MetadataElementIsNotAllowedException extends Exception {

	private LevelOfDescription level;
	private String mdElementName;

	public MetadataElementIsNotAllowedException(LevelOfDescription level, String mdElementName) {
		super("Level '" + level.getName() + "' references the metadata element '" + mdElementName
				+ "' which is not allowed for this level.");

		this.level = level;
		this.mdElementName = mdElementName;
	}

	public LevelOfDescription getLevel() {
		return this.level;
	}

	public String getMdElementName() {
		return this.mdElementName;
	}

}
