/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mets.structmap.NodeAbstract;

/**
 * Interface to specify classes that can be used to validate MetadataElement
 * values.
 *
 * @author denis
 *
 */
public interface MetadataElementValidator {
	/**
	 * Check the value.
	 * 
	 * @param value
	 *            The value to be tested.
	 * @param context
	 *            The node the value belongs to, in the case that this validator
	 *            needs the context of the value to be tested.
	 * @param metadataElement
	 *            The metadata element containing the value to be checked.
	 * @return null if the check is OK, or a message if not.
	 */
	public void check(String value, NodeAbstract context, MetadataElement metadataElement)
			throws MetadataElementValidatorException;
}
