/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.file;

import java.io.*;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.iptc.IptcDirectory;

/**
 * @author denis
 *
 */
public abstract class MetadataFromJPGFile
{
	//	===========================================================================================
	//	========	Structure				=======================================================
	//	===========================================================================================

	//	========	Static Final Public		=======================================================

	//	========	Static Final Private	=======================================================

	//	========	public static			=======================================================

	//	========	private static			=======================================================

	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	//	========	Static Initializer		=======================================================

	//	========	public static			=======================================================

	public static Directory getEXIF(String jpgPicFileName) throws JpegProcessingException, IOException
	{
		return getEXIF(new File(jpgPicFileName));
	}

	public static Directory getEXIF(File jpgPic) throws JpegProcessingException, IOException
	{
		checkFile(jpgPic);

		return JpegMetadataReader.readMetadata(jpgPic).getDirectory(ExifIFD0Directory.class);
	}


	public static Directory getIPTC(String jpgPicFileName) throws JpegProcessingException, IOException
	{
		return getIPTC(new File(jpgPicFileName));
	}

	public static Directory getIPTC(File jpgPic) throws JpegProcessingException, IOException
	{
		checkFile(jpgPic);

		return JpegMetadataReader.readMetadata(jpgPic).getDirectory(IptcDirectory.class);
	}

	//	========	private static			=======================================================


	private static void checkFile(File file) throws FileNotFoundException
	{
		if (!file.exists())		throw new FileNotFoundException(file.getPath());
		if (!file.isFile())		throw new FileNotFoundException("File '" + file + "' is supposed to be a file, but is a directory.");
	}
}
