/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.file.exception;

import java.util.List;




/**
 * @author denis
 *
 */
public class FileUtilExceptionListException extends java.lang.Exception implements FileUtilException
{
	//	===========================================================================================
	//	========	Methods					=======================================================
	//	===========================================================================================

	private List<FileUtilException>			exceptions;

	//	========	Constructors Public		=======================================================

	public FileUtilExceptionListException(List<FileUtilException> exceptions)
	{
		super();

		this.exceptions = exceptions;
	}

	//	========	Accessors				=======================================================

	public List<FileUtilException> getAllExceptions()
	{
		return this.exceptions;
	}


	@Override
	public String getMessage()
	{
		StringBuilder message = new StringBuilder();
		for (FileUtilException x: this.exceptions)		message.append("\n").append(x.toString());

		return message.toString();
	}

}
