/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.tools.gui;
/**
 * 
 */


import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;


/**
 * @author denis
 *
 */
public class GridBagPanel extends JPanel implements Observer
{

	private static final Border		DefaultBorder = new EmptyBorder(10, 10, 10, 10);
	private static final Insets		DefaultInsets = new Insets(0, 0, 0, 0);


	private Insets					insets = DefaultInsets;


	public GridBagPanel()
	{
		super(new GridBagLayout());
		this.insets = DefaultInsets;
		this.setBorder(DefaultBorder);
	}

	public GridBagPanel(Insets insets)
	{
		this();
		this.insets = insets;
	}

	public GridBagPanel(Border border)
	{
		this();
		this.setBorder(border);
	}

	public GridBagPanel(Border border, Insets insets)
	{
		this();
		this.insets = insets;
		this.setBorder(border);
	}


	@Override
	public Component add(
			Component component)
	{
		return this.add(component, GridBagConstraints.RELATIVE);
	}


	@Override
	public Component add(
			Component component,
			int row)
	{
		return this.add(component, row, GridBagConstraints.RELATIVE);
	}


	public Component add(
			Component component,
			int row,		int column)
	{
		return this.add(component, row, row, column, column);
	}


	public Component add(
			Component component,
			int row,		int column,
			int anchor)
	{
		return this.add(component, row, row, column, column, anchor);
	}


	public Component add(
			Component component,
			int fromRow,		int toRow,
			int fromColumn,		int toColumn)
	{
		return this.add(component, fromRow, toRow, fromColumn, toColumn, GridBagConstraints.CENTER);
	}


	public Component add(
			Component component,
			int fromRow,		int toRow,
			int fromColumn,		int toColumn,
			int anchor)
	{
		return this.add(component, fromRow, toRow, fromColumn, toColumn, anchor, GridBagConstraints.NONE, 0, 0);
	}


	public Component add(
			Component component,
			int row,			int column,
			int anchor,
			int fill,
			double weightx,		double weighty)
	{
		return this.add(component, row, row, column, column, anchor, fill, weightx, weighty, this.insets);
	}


	public Component add(
			Component component,
			int fromRow,		int toRow,
			int fromColumn,		int toColumn,
			int anchor,
			int fill,
			double weightx,		double weighty)
	{
		return this.add(component, fromRow, toRow, fromColumn, toColumn, anchor, fill, weightx, weighty, this.insets);
	}


	public Component add(
			Component component,
			int fromRow,		int toRow,
			int fromColumn,		int toColumn,
			int anchor,
			int fill,
			double weightx,		double weighty,
			Insets insets)
	{
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridy = fromRow;
		gbc.gridx = fromColumn;
		gbc.gridheight = toRow - fromRow + 1;
		gbc.gridwidth = toColumn - fromColumn + 1;
		gbc.anchor = anchor;
		gbc.fill = fill;
		gbc.weightx = weightx;
		gbc.weighty = weighty;
		gbc.insets = insets;

		((GridBagLayout)this.getLayout()).setConstraints(component, gbc);
		super.add(component);

		return component;
	}


	@Override
	public void setLayout(LayoutManager mgr)
	{
		if (mgr.getClass() != GridBagLayout.class)		throw new RuntimeException("It's not possible to set a new layout in DLPanel other that a GridBagLayout");
		super.setLayout(mgr);
	}
	
	
	public void setInsets(Insets insets)
	{
		this.insets = insets;
	}
	

	/* (non-Javadoc)
	 * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
	 */
	@Override
	public void update(Observable observable, final Object parameter)
	{
		//	The concrete implementation may react here to a change of the observable object.
	}
	

}
