/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package uk.gov.nationalarchives.droid.core;

import uk.gov.nationalarchives.droid.core.signature.FileFormat;


/**
 * @author denis
 *
 * Extends uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier to provide a public method to get the FileFormat for the given puid.
 * This is needed because when getting file identifications of container type in the class file.MetadataProviderDROID, the name, mime type,
 * and version of the file identification are not supplied.
 * With this method, the FileFormat object for a given puid can be retrieved, which returns these missing values.
 */
public class BinarySignatureIdentifier_Extended extends BinarySignatureIdentifier
{
	public FileFormat getFileFormatForPuid(String puid)
	{
		return this.getSigFile().getFileFormat(puid);
	}
}
