/**
 *	Copyright (C) 2011-2016 Docuteam GmbH
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 3
 *	as published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package ch.docuteam.packer.admin;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.Properties;


/**
 * @author denis
 *
 * CHANGES HISTORY:
 *
 * Version 2.4.8:
 * 24.11.2016:
 * fix opening URL on Windows (PACKER-88)
 * fix appraisal report if no items apply (PACKER-86)
 * 23.11.2016:
 * revert commit of 08.11.2016 (PACKER-87)
 * 09.11.2016:
 * bump to next bugfix version
 *
 * Version 2.4.7:
 * 09.11.2016:
 * remove unnecessary code updating the sipView after saving
 * 08.11.2016:
 * use more efficient saveAndClose() in the respective context
 * 01.11.2016:
 * add platform/java information into debug output
 * bump to next bugfix version
 *
 * Version 2.4.6:
 * 01.11.2016:
 * update dependency for docuteam-darc to 2.18.2
 * don't try initializing aipcreator if no class is given 
 * 28.10.2016:
 * bump to next bugfix version
 *
 * Version 2.4.5:
 * 28.10.2016:
 * update dependency for docuteam-darc to 2.18.1
 * update dependency for docuteam-tools to 1.11.7
 * fix exception handling on submit
 * fix refresh workspace on submit and feedback
 * 27.10.2016:
 * bump to next bugfix version
 *
 * Version 2.4.4:
 * 27.10.2016:
 * fix aipcreator initialization
 * 26.10.2016:
 * update dependency for docuteam-darc to 2.18.0
 * update dependency for docuteam-tools to 1.11.6
 * 24.10.2016:
 * keep GUI agnostic of AIPCreator implementation details
 * use generic logos in reports
 * 23.10.2016:
 * SIPView: change visibility of properties and reduce logic for submit (should be managed by the respective aipcreator implementation)
 * 11.10.2016:
 * bump to next bugfix version
 *
 * Version 2.4.3:
 * 10.10.2016:
 * fix missing translations
 * update dependency for docuteam-darc to 2.17.0
 * update dependency for docuteam-converter to 1.4.0
 * update dependency for docuteam-tools to 1.11.5
 * 26.09.2016:
 * fix enabled actions for multiselect
 * 08.09.2016:
 * bump to next bugfix version
 *
 * Version 2.4.2:
 * 08.09.2016:
 * update dependency for docuteam-darc to 2.16.8
 * 07.09.2016:
 * bump to next bugfix version
 *
 * Version 2.4.1:
 * 07.09.2016:
 * update dependency for docuteam-darc to 2.16.7
 * add level configurations and translations for new metadata fields
 * 27.07.2016:
 * bump to next bugfix version
 * 
 * Version 2.4.0:
 * 26.07.2016 (Andreas):
 * update dependency for docuteam-darc to 2.16.5
 * update dependency for docuteam-tools to 1.11.4
 * update dependency for docuteam-converter to 1.3.0
 * 14.06.2016 (Andreas):
 * build.xml: fix main class
 * 10.06.2016 (Andreas):
 * - submit will move the SIP instead of copying
 * - add property to set a external directory for report templates
 * - new report for appraisal
 * 09.06.2016 (Andreas):
 * resources/translations/*: add translations for option to delete sources after SIP creation
 * 08.06.2016 (Iliya):
 * gui.sipView.*: fixed bugs with multiple selection by delete node file
 * gui.launcher.LauncherView: fix performance issue with workspace table
 * gui.sipView.SIPView: submit has moved from darc to aipcreator
 * gui.*: extract inner classes, new packaging structure
 * 08.06.2016 (Andreas):
 * admin.Version: bump to next minor version
 * 07.06.2016 (Andreas):
 * gui.PackerConstants, gui.LauncherView, CreateNewSIPDialog: add option to delete sources after SIP creation
 * 01.06.2016 (Andreas):
 * lib/docuteam-darc-2.16.4.jar:
 * 		- mdconfig.MetadataElementValidatorYYYYMMDD: new validator for dates without months/days
 * 27.05.2016 (Andreas):
 * admin.Version: bump to next bugfix version
 *
 * Version 2.3.1:
 * 27.05.2016 (Andreas):
 * lib/docuteam-darc-2.16.3.jar:
 * 		- mets.Document: add logging information for submit through SFTP
 * 		- premis.Object: public setter/getter for default checksum algorithm
 * gui.LauncherView: fix check for existing SIPs in workspace
 * 24.05.2016 (Andreas):
 * gui.LauncherView, config/docuteamPacker.properties, resources/translations/*: new property "docuteamPacker.defaultChecksumAlgorithm" to set a specific algorithm (default is SHA-512)
 * 17.05.2016 (Andreas):
 * config_dist/levels*.xml, resources/translations/*.properties: add new metadata element 'extentNote'
 * 11.05.2016 (Andreas):
 * admin.Version: bump to next bugfix version
 *
 * Version 2.3.0:
 * 11.05.2016 (Andreas):
 * - lib/docuteam-darc-2.16.2.jar: updated dependency
 * 		- lib/docuteam-tools-1.11.3.jar: updated dependency
 * 			- fix closing of SFTP streams
 * 10.05.2016 (Iliya):
 * - gui.SIPView: fix initialization of submit folder
 * 10.05.2016 (Andreas):
 * - gui.SIPView: fix check for URL metadata content to ignore null values
 * - gui.LauncherView: fix column titles
 * 09.05.2016 (Andreas):
 * - lib/docuteam-darc-2.16.1.jar: updated dependency
 * - gui.SIPView: set submit status in parent nodes as well for partial (re-)submits
 * - gui.LauncherView:
 * 		- inner class FileProperty has no file access after instantiation
 * 		- fix inner class SIPTableModel to update in case of changed list of files
 * 06.05.2016 (Andreas):
 * - gui.LauncherView:
 * 		- bug fix: if (this.sipsWithSavingInProgress.contains(String sipPath)) was wrong as sipsWithSavingInProgress was initialized with SIPView, 
 * 			- changed generic to FileProperty instead of SIPView
 * 			- adapted all entries of sipsWithSavingInProgress
 * 		- async update of size and lockedBy columns for not zipped SIPs
 * 			- added inner class FileProperty with functionality encapsulated
 * 			- unregistering SIPView updates workspace only if SIP is in workspace
 * 			- changed selectedSIP to type FileProperty and adapted respective calls
 * 			- added method updateColumns with asynchronous calls
 * 			- changed column numbers from int to enum Column for better reading
 * 		- optimize information collection for table
 * 		- add string in list to indicate whether a SIP has been (partially) submitted.
 * - gui.SIPView:
 * 		- move logic for setting the SubmitStatus into darc.mets.structmap.NodeAbstract
 * 		- allow inserting files and creating subfolder for submitted nodes
 * 		- changed constructor signatur (second parameter is now of type FileProperty)
 * 		- fix retracting of submitStatus
 * 		- fix check for SubmitStatus of node (only check nodes that are marked for submission; don't try to change status for already submitted nodes)
 * 		- fix setting of SubmitStatus by first checking both directions in the hierarchy before actually applying the changes.
 * 		- don't allow dragging if the node is being/has been submitted:
 * 		- configure logic for selection of specifics elements for submission in parts
 * 		- automatically set submit status for parent nodes as well
 * 		- enable GUI elements for submission in parts
 * - resources/translations/*.properties: adjust translations for submit actions
 * - lib/docuteam-darc-2.16.0.jar:
 * 		- partial submit
 * 		- submit using SSH
 * 		- migration keeping original will create subfolder to contain original and derived copy
 * 		- additional AIPCreator implementation with additional checks regarding submit status
 * 		- mets.structmap.NodeFolder: create missing digiprovMDs for folders as well when checking SA for conforming file formats
 * 27.04.2016 (Iliya/Andreas):
 * - gui.SIPView, gui.DeleteFileContentAction: add function to delete the file content of a node
 * - lib/docuteam-darc-2.15.0.jar:
 * 		- lib/jsch-0.1.53.jar: support for SSH/SFTP
 * 13.04.2016 (Andreas):
 * - gui.SIPView: display URL metadata in blue and listen for ctrl-clicks on these cells to open them
 * 07.04.2016 (Andreas):
 * - lib/docuteam-converter-1.2.3.jar:
 * 		- config_dist/migration-config*.xml: include fmt/645 as regular jpg
 * - lib/docuteam-converter-1.2.2.jar:
 * 		- converter.FileConverter: check not only the filename but the whole file's pathname for conflict with the command separator of migration-config.xml
 * 		- converter.FileConverter: if temporary file is used for migration, put it into temporary folder named with thread id to avoid conflicts with concurrent processes
 * - lib/docuteam-darc-2.15.0.jar: updated version
 * 		- mdconfig.LevelMetadataElement, mdconfig.MetadataElement, mets.structmap.NodeAbstract: validate default expressions against metadata validators and allowed values
 * 		- premis.Object: set default algorithm to SHA-512
 * 		- mets.structmap.NodeFile:
 * 			- instead of hard-coded use of MD5, select the specified algorithm to check fixity.
 * 			- verify checksums only for submitted nodes.
 * 		- from tags 2.14.8 to 2.14.10 from trunk:
 * 			- mets.amdsec.DigiprovWithPremis: new method signatures to create PREMIS events with a specific date
 * 			- mets.Document: simplify filter for valid SIP folders
 * 			- mets.Document, mdconfig.LevelOfDescription: use SAXReader.read() with a File instead of a String to handle file paths with special characters
 * 			- mets.Document: add method saveAndClose which moves the sip instead of copying it (closing the working copy and setting it into ReadWriteNoFileOps mode) using less resources
 * 			- mdconfig.MetadataElementValidatorDate*: accept a value of 'NoDate' (and translations if available, e.g. "undatiert")
 * 			- mdconfig.MetadataElementValidator*CH: allow dates to have single digits for month/day components
 * 			- mdconfig.MetadataElementValidatorDateHierarchyRangeCH: fix check for null values in child nodes
 * 			- mdconfig.MetadataElementValidatorDateHierarchyRangeCH: fix to include the "NoDate" string into interpretation
 * 			- mdconfig.MetadataElementValidatorDateHierarchyYear: fix to deal with empty/null values and check against child nodes as well
 * 			- mdconfig.MetadataElementValidatorDateRangeCH: fix to allow dates with single digit days/months
 * - lib/docuteam-tools-1.11.1.jar: update to current version, changes since version 1.11.0:
 * 		- translations.I18N: extended to load several resource bundles per language
 * 		- config_dist/container-signature-20160121.xml, config_dist/DROID_SignatureFile_V84.xml, file.MetadataProviderDROID: update to current DROID signature files
 * - lib/docuteam-tools-1.11.0: use tagged version:
 * 		- file.FileChecksumCalculator, file.FileWithMetadata: add checksum calculations for SHA-256 and SHA-512
 * 16.03.2016 (Andreas):
 * resources/images/Level*CMI.png: icons to be used in the context of CMISTAR
 * 
 * Version 2.2.6:
 * 26.10.2015 (Andreas):
 * config/docuteamPacker.properties: add example value for AIPCreatorBasic
 * lib/docuteam-converter-1.2.1: only dependency update
 * lib/docuteam-darc-2.4.7:
 * 		- ingest.AIPCreatorBasic: new AIPCreator that only checks for mandatory metadata elements and readability of files
 * 		- config_levels/levels_all_*.xml: include additional icon filenames
 * lib/docuteam-tools-1.10.9:
 * 		- file.FileUtil, file.FileWithMetadata, file.MetadataProviderDROID, file.MetadataProviderJHOVE, file.PropertyFile, os.OSXAdapter: replace any Exception.printStackTrace() to proper logging calls
 * 21.10.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.5:
 * 20.10.2015 (Andreas):
 * resources/images/Level*.png, config_dist/levels_isad-g_*.xml: additional icons for levels archives, collection and fonds
 * 20.10.2015 (Christian):
 * resources/images/Logo_docuteam_64.png: add docuteam logo
 * resources/templates.reports/Metadaten*.xsl: adapt image-path
 * 13.10.2015 (Christian):
 * resources/templates.reports/Metadaten-Quer.xsl: corrected image-path
 * resources/templates.reports/Metadaten.xsl: corrected image-path
 * 06.10.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.4:
 * 06.10.2015 (Andreas):
 * translations.*: insert translation for 'NoDate'
 * dist_src/Launch4jConfig*: require java 8, 64Bit
 * lib/docuteam-converter-1.2.0: Use final tagged version
 * 		- lib/DCVE.jar, dll/*: updated libraries for PDF-Tools Document Converter version 4.4
 * lib/docuteam-darc-2.14.6.jar: Use final tagged version
 *		- mdconfig.MetadataElementValidator*CH: allow dates to have single digits for month/day components
 *		- levels_*.xml: fit translations to actual language definition
 * 05.10.2015 (Andreas):
 * translations.*: remove unnecessary property
 * 21.09.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.3:
 * 21.09.2015 (Andreas):
 * lib/docuteam-converter-1.1.1: Use final tagged version
 * 		- config_dist/migration-config_with-pdf-tools.xml: added for use with pdf-tools
 " 		- config_dist/migration-config.xml: added entries for postscript
 * lib/docuteam-darc-2.14.5.jar: Use final tagged version
 *		- mdconfig.MetadataElementValidatorDateHierarchyRangeCH: fix check for null values in child nodes
 * lib/docuteam-darc-2.14.4.jar: Use final tagged version
 * 		- mdconfig.MetadataElementValidatorDate*: accept a value of 'NoDate' (and translations if available, e.g. "undatiert")
 * 		- ead.C: fix to allow EAD files with just an archdesc and no further child components
 * lib/docuteam-darc-2.14.3.jar: Use final tagged version
 * 		- ead.Document: added static method read(BufferedReader)
 * 		- util.XMLUtil: replace both \r and \n with <EAD:lb> elements
 * 		- config_levels/levels_cmi_de.xml:
 * 		- allow repetition of levels
 * 		- change objectType for document level to mandatory/not repeatable
 * lib/docuteam-tools-1.10.8: Use final tagged version
 * 		- file.FileUtil: fix basicCopyTo method to ignore copying if source equals destination
 * lib/docuteam-tools-1.10.7: Use final tagged version
 * 		- lib/log4j-1.2.17.jar: updated version
 * 		- lib/commons-codec-1.9.jar: dependency of poi-3.11-20141221.jar
 * 07.09.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.2:
 * 07.09.2015 (Andreas):
 * resources/translations/Translations*.properties: added some untranslated labels for dynamic metadata elements
 * 16.08.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.1:
 * 05.08.2015 (Andreas):
 * gui.LauncherView: fix help information
 * 13.07.2015 (Christian):
 * resources/translations/Translations*.properties: added some untranslated labels in previous revision
 * 08.07.2015 (Andreas):
 * gui.LauncherView, gui.SIPView: remove hidden dialog of Denis
 * 17.06.2015 (Christian):
 * gui.LauncherView:
 * 		- changed signature of method savingDocumentInProgress from string to SIPView
 * 		- changed signature of method savingDocumentFinished from string to SIPView
 * gui.SIPView: adapted call of respective methods in SIPView
 * 29.04.2015 (Andreas):
 * admin.Version: bump to next development version
 *
 * Version 2.2.0:
 * 29.04.2015 (Andreas):
 * admin.Version: bump to next minor version
 *
 * Version 2.1.4:
 * 21.04.2015 (Christian/Andreas):
 * lib/docuteam-converter-1.1.0: use final tagged version:
 * 		- accept multiple target pronom IDs now (comma separated)
 * 		- use a unique temporary filename as conversion target, then rename it to the correct name
 * 		- do not duplicate the extension even if the output file will have the same name as the input file
 * 		- skip migration if no applicationID is provided
 * 		- modified generic Ghostscript parameters to fit current version
 * lib/docuteam-darc-2.14.2: use final tagged version:
 * 		- additional metadata fields required by the CMI Basismodell
 * 		- revised handling of PREMIS events
 * 		- more compact xml output for METS
 * 		- show warning if submission agreement not referenced in METS
 * 		- smaller fixes (<metsHdr> initialization, PREMIS version to 2.2, format information on root file)
 * lib/docuteam-tools-1.10.6: use final tagged version:
 *		- config/*: updated DROID signature files
 *		- string.StringUtil: new method isDecimal(String)
 *		- lib/*: updated droid and poi libraries
 * gui.LauncherView:
 *		- does not close until all savings are done
 *		- remove inner class EnterAction which is not used
 * gui.SIPView: remove unused variables and methods
 * 20.04.2015 (Andreas):
 * resources/translations/*.properties: updated translations
 * config_dist/levels_cmi_de.xml: updated version
 * 17.04.2015 (Andreas):
 * gui.SIPView: fix one warning
 * resources/templates/reports/*: add generic reports
 * config_dist/log4j.xml: add category to suppress common FOP warnings
 * 15.04.2015 (Christian):
 * config_dist/container-signature-20150327.xml: new droid format definition file for containers
 * config_dist/DROID_SignatureFile_V82.xml: new droid format definition file
 * 14.04.2015 (Christian):
 * gui.SIPView.ElementRenamingDialog: removed throw of headlessException in constructor
 * gui.SIPView.ElementRenamingDialog: changed name of internal class, added parameters width and height and use this dialog also to get new folder name
 * gui.SIPView: changed method names to reflect better their purpose
 * resources/translations/Translations.properties: adapted respective text (cosmetic)
 * resources/translations/Translations_de.properties: adapted respective text (cosmetic)
 * resources/translations/Translations_en.properties: adapted respective text (cosmetic)
 * resources/translations/Translations_fr.properties: adapted respective text (cosmetic)
 * gui.SIPView: name of action SaveAsECH0160 changed to exportAsECH0160. Removed from main menu, added to export menu
 * resources/translations/Translations.properties: changed export menu name and tooltip
 * resources/translations/Translations_de.properties: changed export menu name and tooltip
 * resources/translations/Translations_en.properties: changed export menu name and tooltip
 * resources/translations/Translations_fr.properties: changed export menu name and tooltip
 * 31.03.2015 (Christian):
 * gui.LauncherView: trimmed text field contents
 * gui.SIPView: trimmed text field contents
 * 10.03.2015 (Andreas):
 * lib/docuteam-converter.jar: use most recent version with current docuteam-tools
 * lib/docuteam-darc.jar: use most recent version with current docuteam-tools and fix for metsHdr
 * lib/docuteam-tools.jar use most recent version with string.StringUtil.isDecimal(string)
 * 24.02.2015 (Christian):
 * gui.SIPView: added internal class for getting a resizable rename item dialog
 * config_dist/migration-config.xml: changed ghostscript parameter to -sColorConversionStrategy=/UseDeviceIndependentColor#
 * 17.02.2015 (Andreas):
 * build.xml: set java compatibility to 1.7
 * lib/docuteam-*.jar: use java 1.7 compatible build
 * 17.02.2015 (Christian):
 * gui.LauncherView: changed not  working key events and key modifiers
 * gui.SIPView: changed not  working key events and key modifiers
 * 16.02.2015 (Christian):
 * gui.LauncherView: adapted key modifiers of menu entries to conform shortcut document
 * gui.SIPView: adapted key modifiers of menu entries to conform shortcut document
 * 13.02.2015 (Andreas):
 * gui.LauncherView: add JVM information into AboutView
 * lib/docuteam-darc-2.14.2.jar: use most recent version
 *		- rename MetadataElements from bioghist to biographicalHistory and note to characteristicsNote
 *		- include additional MetadataElements for CMISTAR
 *		- compatible with java 1.8
 * lib/docuteam-converter-1.0.4.jar: use most recent version
 *		- compatible with java 1.8
 * lib/docuteam-tools-1.10.6.jar: use most recent version
 *		- update DROID and POI libraries
 *		- allow to set file extension usage for DROID
 *		- parse string as filesize
 *		- compatible with java 1.8
 * config_dist/levels.xml: include additional metadata elements
 * config_dist/levels_cmi_de.xml: configuration for CMISTAR
 * 02.02.2015 (Christian):
 * build.xml: set to java version 1.8
 * 20.01.2015 (Christian):
 * gui.LauncherView: added setLocale to explicit set locale for e.g. message dialog buttons.
 * 19.01.2015 (Christian):
 * gui.LauncherView: changed shortcuts
 * gui.SIPView: changed shortcuts
 *
 * Version 2.1.3:
 * 19.11.2014 (Christian):
 * gui.LauncherView$SIPTableModel.getValueAt: corrected calculation of file size for directories.
 * 14.11.2014
 * Use tagged version of converter 1.0.3
 * Use tagged version of darc 2.14.1
 * Use tagged version of tools 1.10.4
 * 05.11.2014 (Christian):
 * gui.SIPView allow to change levels in layer and level mode.
 * resources/images adapted icons for mode nofileops
 * gui.SIPView.saveCopyAs always reread workspace after save.
 * 30.10.2014 (Christian):
 * gui.SIPView.MetadataTable: added tableChanged and setRowHeights, removed setRowHeights in CellEditors and CellRenderers
 * 27.10.2014 (Christian):
 * gui.LauncherView: added functionality for new work mode readWriteNoFileOps
 * gui.SearchView: changed boolean parameter for work mode to Mode type
 * gui.SIPView: added functionality for new work mode readWriteNoFileOps
 * gui.SIPView: changed focus 'jumps' by introducing UnfocusableCellRenderer, that gets no focus for columns < 2
 * Translations.properties, Translations_fr.properties, Translations_en.properties, Translations_de.properties ergänzt. Müsste überprüft werden.
 * resources/images: OpenReadWriteNoFileOps.png, OpenInWorkspaceReadWriteNoFileOps.png müssen noch gezeichnet werden.
 *
 * Version 2.1.2:
 * 20.10.2014 (Andreas):
 * gui.FilePreviewer: Add ImageIO to be used for previews, specifically: JPX (JPEG 2000 Part 2)
 * 13.10.2014 (Christian):
 * docuteamPacker.properties extended by properties docuteamPacker.SIPView.TreeExpandAll(boolean) and docuteamPacker.SIPView.DefaultTab(int [1-3]), code in SIPView added (ETH-161)
 * gui.SIPView added code to expand tree if property is set to true and to select tab according to respective attribute set.
 * 08.10.2014 (Christian):
 * gui.FilePreviewer: added GraphicsJAIConvertableImageRead to enum FileType to support jpeg2000 images
 * gui.FilePreviewer$FilePreviewPanel added case GraphicsJAIConvertableImageRead to support new ImageIcon(JAI.create("ImageRead", fileName)
 * 07.10.2014 (Christian):
 * Added translations for darc.mdconfig.MetadataElementValidatorDateHierarchyRangeCH
 * 05.10.2014 (Andreas):
 * gui.LauncherView: use existing apache commons library to get the folder size
 * resources/translations/Translations_fr.properties: small corrections by Frédéric Noyer
 * 03.10.2014 (Christian):
 * gui.LauncherView:
 * 		- added method folderSize to inner class SIPTableModel and
 * 		- changed return value of method getValueAt in same class to return the size of the file or folder content.
 * 05.09.2014 (Andreas):
 * translations/*: additional validator messages
 * licenses/*: general cleanup
 * lib/*: remove rosetta libraries (not needed in the generic packer)
 * Use current version of converter 1.0.3 with extension:
 * 		cleanup of libraries and licenses
 * Use current version of darc 2.14.1 with extension:
 * 		mdconfig.*: additional/modified validators
 * Use current version of tools 1.10.4 with extension (from 1.10.3):
 * 		new methods for String handling and usage of environment variables
 * 		use full extension matching with DROID
 * 13.08.2014 (Andreas):
 * gui.SIPView: Use StyledComboBox with variable width of the dropdown list.
 * 12.08.2014 (Andreas):
 * gui.SIPView: Use copy cursor for drag and drop from the file system.
 * 11.08.2014 (Andreas):
 * gui.SIPView:
 * 		use hour glass cursor during file replacement.
 * 		allow multiple selection for context menu (alter change from 31.01.2014).
 * 21.07.2014 (Christian):
 * Translations_fr.properties: ToolTipDynamicMetadataTypes "X = seulement lisible" geändert in "X = Lecture seul"
 * 26.06.2014 (Denis):
 * gui.SIPView: Change the cursor while dragging from the file system. (still under development - see gui.SIPView line 3012)
 * 23.06.2014 (Denis):
 * Use current version of darc 2.14.0 with extension:
 * 		mdconfig.*: Validators now return a message code which should be translated.
 * 		mdconfig.MetadataElementValidatorUniqueValueAmongSiblings: Correction: Check if node to test is root and hence has no siblings.
 * resources/translations: Add translations for validator message codes.
 * 20.06.2014 (Denis):
 * Use current version of darc 2.14.0 with extension:
 * 		translations.I18N: Add methods translate_NoCheck(String word) and translate_NoCheck(String word, Object... objects) to avoid exception when I18N is not initialized.
 * 		mdconfig.MetadataElementValidatorUniqueValueAmongSiblings: Translate metadata name in warning message.
 * 		mdconfig.MetadataElementValidatorDate, mdconfig.MetadataElementValidatorDateCH: Correction in parsing dates: be more strict.
 * 18.06.2014 (Denis):
 * gui.SIPView: When inserting files or folders, show a message if the submission agreement prohibits some of the files.
 * 17.06.2014 (Denis):
 * Use current version of darc 2.14.0 with extensions:
 * 		Interface change:
 * 		mdconfig.MetadataElementValidator:
 * 				The method check(...) doesn't return a String any more but now throws a MetadataElementValidatorException.
 * 				Consequent changes in many other places.
 * 		mdconfig.MetadataElementSetterPostAction, mdconfig.LevelOfDescription, mdconfig.MetadataElement, mdconfig.LevelMetadataElement,
 * 		exceptions.MetadataElementSetterPostActionClassNotFoundException, config_dist/levels.xsd:
 * 				Execute an optional configurable post-action after having set a dynamic metadata value.
 * 13.06.2014 (Denis):
 * Use current version of darc 2.13.2 with correction:
 * mets.structmap.NodeAbstract, mdconfig.MetadataElementInstance, mdconfig.LevelMetadataElement, exceptions.LevelMetadataElementIsReadOnly:
 * 		The normal setter for dynamic metadata now throws the exception LevelMetadataElementIsReadOnly when the corresponding metadata
 * 		element is read-only for this level. The setter with an appended "_force" sets the value ignoring any read-only.
 * 12.06.2014 (Denis):
 * Use current version of darc 2.13.1 with extension:
 * 		util.CSVExport: New class.
 * gui.SIPView: Correction of the "Packet" menu.
 * 11.06.2014 (Denis):
 * Use current version of darc 2.13.1 with extension:
 * 		util.XML2PDF: Create a report.
 * gui.SIPView: Integrate report creation in SIPView "Packet" menu.
 * 06.06.2014 (Denis):
 * gui.SIPView: On non-empty search results, show in footer black text "Elements found: xxx".
 * 05.06.2014 (Denis):
 * gui.FilePreviewer: When opening a file externally, make this file (actually a copy of it) read-only, so it can't be modified.
 * gui.LauncherView: On shutdown, make the temp-folder recursively writable.
 * Use current version of darc 2.13.1 with correction:
 * 		mets.Document, mets.structmap.NodeAbstract: Improve the searchForAllQuoted method: ALL search words must be present, but each in any of the searched areas.
 * 04.06.2014 (Denis):
 * gui.SIPView, gui.SearchView: On empty search results, show in footer red text "No Elements found".
 * gui.LauncherView: The column "lastModified" shows the lastModified timestamp of the 'mets.xml' file within, if the SIP is a folder.
 * Use current version of darc 1.10.2 with corrections and extensions:
 * 		MetadataProviderDROID: Use full extension matching
 * 		ch.docuteam.darc.mdconfig.MetadataElementValidatorDateCH added. Checks if a date conforms to swiss dateformat.
 * 		ch.docuteam.unittest.darc.mdconfig.MetadataElementValidatorDateCH for unittest.
 * 		ch.docuteam.darc.mdconfig.MetadataElementValidatorUniqueValueAmongSiblings added. Checks if a refCode within same level is unique.
 * 		ch.docuteam.unittest.darc.mdconfig.MetadataElementValidatorUniqueValueAmongSiblings for unittest.
 * 03.06.2014 (Denis):
 * gui.FilePreviewer: Optional textual preview for files with unknown type.
 * 02.06.2014 (Denis):
 * config_dist/docuteamPacker.properties, gui.LauncherView:
 * 		New property "docuteamPacker.newSIPDefaultsToZipped". When true (case doesn't matter), the default format of a new SIP is a zipped
 * 		archive; otherwise it is a folder (undefined = true).
 * 28.05.2014 (Denis):
 * Use current version of darc 2.13.1 with extensions:
 * 		mets.Document, mets.structmap.NodeAbstract: Extend search to multiple search items, quoted.
 * 		mets.Document, exceptions.ZIPDoesNotContainMETSFileException: When a zipped SIP doesn't contain the METS file at the root level, throw this exception.
 * gui.SIPView, gui.SearchView: Extend packet and workspace search to multiple search items, quoted.
 * gui.SearchView: Extend workspace search with the possibility to choose between AND- and OR-search.
 * gui.LauncherView, gui.SIPView: Don't allow opening a SIP in the Launcher if it is just being saved.
 * 27.05.2014 (Denis):
 * gui.FilePreviewer: Fixed a bug where in some cases temporary files needed for preview were not deleted under Windows.
 * 23.05.2014 (Denis):
 * gui.FilePreviewer: Correction: Don't delete temporary files needed for preview on packer startup, but only on packer shutdown.
 * Use current version of converter 1.0.2
 * 22.05.2014 (Denis):
 * Use current version of darc 2.13.1 with correction:
 * 		mets.Document: Corrections in methods submit(...) and checkIngestFeedback(...): can now handle correctly both zipped and unzipped SIPs.
 * 21.05.2014 (Denis):
 * resources_dist, build.xml: Folder "resources_dist" renamed to "resources".
 * 15.05.2014 (Andreas):
 * resources_dist/translations: Corrections in translations.
 * 14.05.2014 (Andreas):
 * build.xml: use wildcards instead of listing start scripts individually
 * dist_src: unify launch4j scripts to use relative paths
 * 14.05.2014 (Denis):
 * gui.LauncherView: Column "last changed date" in the Launcher contains now the seconds.
 * Use current version of darc 2.13.1 with extensions and corrections:
 * 		Use current version of tools 1.10.1 with extension:
 * 				updated DROID signature file to enhance support for PDF/A
 * 		mdconfig.MetadataElementValidatorDateHierarchyYear: new validator to check simple date logic between a node and its parent
 * 		filesec.File: Bug fix: In rare cases, renaming a folder changed the href of files within this folder (if the file had the same name as the folder).
 * Use current version of converter 1.0.2.
 * 13.05.2014 (Andreas):
 * launch4j-Konfiguration für standalone-executable
 * 01.05.2014 (Andreas):
 * Version 2.1.2 initial.
 *
 * Version 2.1.1:
 * 01.05.2014 (Andreas):
 * build.xml: use proper resources_dist directory
 * Use tagged version of darc 2.13.0
 *		- new BAR-SIP reader and writer
 *		- includes tools 1.10.1 with updated DROID signature file
 * Use tagged version of converter 1.0.1
 * 15.04.2014 (Denis):
 * Use current version of tools 1.10.1 with extension:
 * 		out.Logger: Added public method getLogger() that returns the logger for the calling class. When using this method, it is possible
 * 				to output the name and line number of the method where the logging is issued in.
 * Use current version of darc 2.13.0 with modification:
 * 		exceptions.MetadataElementIsNotAllowedException, exceptions.MetadataElementIsNotDefinedException,
 * 		mdconfig.LevelOfDescription, mets.Document, mets.structmap.NodeAbstract:
 * 				Better exception handling when accessing undefined or not configured metadata elements.
 * 14.04.2014 (Denis):
 * Use current version of darc 2.12.1 with extension:
 * 		levels.xml, ead.ComponentAbstract: Extend the dynamic metadata by one more element: "accessRestrictionPeriodBaseYear".
 * 		gui.LauncherView: Display Date&Time column in german style (dd.MM.yyyy HH.mm) while column is still sortable.
 * 04.04.2014 (Denis):
 * Version 2.1.1 initial.
 *
 * Version 2.1.0:
 * 04.04.2014 (Denis):
 * Use tagged version of darc 2.12.0.
 * Use tagged version of converter 1.0.0.
 * Tagged as Version 2.1.0.
 * 02.04.2014 (Denis):
 * config_dist/documentPacker.properties: Add note that environment variables can be referenced in the property file.
 * Use current version of darc 2.12.0 with additional dynamic metadata elements:
 * 		accessPolicy
 * 		accessRestrictionExplanation
 * 		accessRestrictionPeriod
 * 		accessRestrictionClassification
 * 		accessRestrictionPrivacy
 * 		accessRestrictionStatus
 * 		accessRestrictionStatusExplanation
 * 26.03.2014 (Andi):
 * Use current version of converter 1.0.0 with support for openoffice on linux.
 * 25.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		os.SystemProcessCantLaunchApplicationException, os.SystemProcess:
 * 				Throw specific exception when Desktop can't launch or associate an application for a file.
 * French translation of this message still missing.
 * gui.LauncherView:
 * 		Display SIP size in Launcher right-aligned and in kB, not in bytes.
 * 		SIP list is now sortable.
 * 20.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.MetadataProviderDROID: Use current versions of DROID-signature and container-signature files.
 * 12.03.2014 (Denis):
 * resources/translations/Translations_fr: Corrections in french translation.
 * 11.03.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		file.FileUtil: Prohibit "..", as legal file name generally. Removed a remaining trace in "isFileNameAllowed()"
 * gui.SIPView: Fixed a bug when closing the SIPView with a modified document: the SIP was cleaned-up and unlocked before it was saved.
 * gui.LauncherView:
 * 		When creating a new SIP (from scratch or from template), reject if a SIP with this name already exists in the folder.
 * 		Fixed a memory leak: Clean-up files properly when creating a new SIP.
 * 06.03.2014 (Denis):
 * Use current version of darc 2.12.0.
 * Use current version of converter 1.0.0.
 * dist_src/.../Info.plist: Added key "CFBundleExecutable" value "docuteam packer" so that the distributed app can be renamed.
 * 25.02.2014 (Denis):
 * gui.SIPView: After inserting nodes, select one of the inserted nodes.
 * 24.02.2014 (Denis):
 * resources/translations/Translations_fr: Corrections in french translation.
 * 21.02.2014 (Denis):
 * gui.LauncherView, gui.SIPView: Improved and unified the way how to close dialogs with the ESC key.
 * 20.02.2014 (Denis):
 * gui.LauncherView$AboutView: Small visual improvements.
 * gui.LauncherView: When creating a copy of a SIP, user can choose if the copy is a zip, or not.
 * Use current version of darc 2.12.0 with extension:
 * 		mets.Document: Copy SIPs (folder or zip to folder or zip).
 * 19.02.2014 (Denis):
 * Use current version of darc 2.12.0 with extension:
 * 		mets.amdsec.AMDSection, mets.amdsec.DigiprovAbstract, mets.Document, mets.metshdr.Header, premis.Object:
 * 				Save Version.Product and Version.Number in the METS file.
 * resources: Renamed to "resources_dist".
 * resources/icons: Removed all colored balls icons Level0 - Level9.
 * config_dist/levels_standard_*.xml: Standard distribution uses only icons LevelUndefined, LevelSerie, LevelDossier, and LevelItem.
 * 19.02.2014 (Andi):
 * resources/translations: submit module and other selective strings
 * 18.02.2014 (Denis):
 * config_dist/levels_standard_*.xml: Corrections in english translation, define Level1.png - Level9.png als default icons for levels.
 * resources/images/Level*.png: Set the Level0.png - Level9.png icons to be colored balls.
 * 17.02.2014 (Denis):
 * Use current version of tools 1.10.0 with correction:
 * 		gui.SystemOutView: Minor visual improvements in the GUI.
 * 14.02.2013 (Denis):
 * gui.LauncherView: When initializing the SystemOutView, set the additionalInfoText even when the SystemOutView is not used.
 * gui.LauncherView$AboutView: Add version info of "docuteam converter".
 * 13.02.2013 (Denis):
 * build.xml, gui.FilePreviewer, gui.LauncherView: Switch from darc.util.FileConverter to converter.FileConverter.
 * gui.LauncherView, translations/Translations*.properties: The URL for the packer help page is now in the translation files.
 * 11.02.2014 (Denis):
 * Use current version of tools 1.10.0 with extensions:
 * 		os.SystemClipboard: New class. Can be used to get text from and put text into the system clipboard.
 * 		gui.SystemOutView:
 * 				Add "Copy" button to copy the content of the text area into the system clipboard.
 * 				Add method to optionally set an "additional info text" string, which is added to the text area string when copying the text to the clipboard.
 * 		file.PropertyFile: Add method "getKeys()";
 * gui.LauncherView: When copying the console text to the system clipboard, include version info, system info, user info, and the current properties from "docuteamPacker.properties".
 * 10.02.2014 (Denis):
 * Use current version of darc 2.12.0 with extension:
 * 		structmap.NodeFile: Added methods "replaceByFile(String)" and "replaceByFile(File)".
 * gui.SIPView, translations/Translations*.properties: Added action "replaceFileAction".
 * 06.02.2014 (Denis):
 * Refactoring: Renamed package "ch.docuteam.docupack" to "ch.docuteam.packer".
 * Use current version of darc 2.12.0.
 * Use tools 1.10.0 with corrections:
 * 		The methods javaTempDir() and userHome() now always return the file path with a trailing File.separator.
 * 04.02.2014 (Denis):
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document: Method "checkIngestFeedback()": Proper cleanup after feedback, including removal of the submitted zip file.
 * 03.02.2014 (Denis):
 * gui.LauncherView: Check ingest feedback on startup automatically.
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document: Method "checkSubmission()": distinguish between folders and zipped SIPs.
 * 31.01.2014 (Denis):
 * Use current version of Docudarc 2.11.4 with corrections:
 * 		mets.Document:
 * 				Include in "checkSubmission()" the test if the packet already exists in the submission folder.
 * 				Make "checkIngestFeedback()" more strict, and check zipped SIPs as well.
 * gui.SIPView, gui.LauncherView: Right-click first selects the item under the current mouse position, THEN opens the popup menu.
 * 30.01.2014 (Denis):
 * translation/*: Added translations for "MessageSubmitSIPExistsAlreadyInSubmitFolder".
 * Use current version of Docudarc 2.11.4 with correction:
 * 		mets.Document: When submitting, reject if SIP already exists in the submit folder.
 * 29.01.2014 (Denis):
 * dist_src/docuteam packer.app/Contents/Resources/Info.plist:
 * 		Add Key-Value-Pair "CFBundleExecutable"->"docuteam packer" so that the app can be renamed under OSX.
 * translation/*: Rename the tabs "Information" and "Metadata" to "Administration" and "Description (Beschreibung)"
 * gui.SIPView: In the tree view, remove the columns "Children count" and "Descendants count".
 * gui.SIPView: In the tree view, select the inserted node.
 * dist_src: Refactoring, added linux start script.
 * 27.01.2014 (Denis):
 * gui.LauncherView, translations/*:
 * 		The two dialogs "CreateNewSIP" and "CreateNewSIPFromTemplate" now contain a checkBox to define whether the SIP shall be zipped or not.
 * 24.01.2014 (Denis):
 * gui.SIPView: Fixed bug: in certain occasions it could happen that drag&drop within an SIP didn't work.
 * 23.01.2014 (Denis):
 * gui.SIPView: The tooltip text of a node now contains additional information whether the file is absent, unreadable or read-only.
 * Use current version of Docudarc 2.11.4 with correction:
 * 		mets.Document:
 * 				When submitting, zip the SIP without the enclosing folder.
 * 				Made method "boolean isZIPFile()" public.
 *  gui.LauncherView: HelpPageURL is now up-to-date.
 * 17.01.2014 (Denis):
 * gui.SearchView: Changed the order of the "search" text field and the "search in packets" text field.
 * All java sources: Change copyright message from "2011-2013" to "2011-2014".
 * Use current versions of Docudarc 2.11.4 with correction:
 * 		mets.Document: Correction in revert to the last saved document version.
 * 15.01.2014 (Denis):
 * gui.SIPView: Correction in method submit(): Better message before submitting.
 * Use current versions of Docudarc 2.11.4 with correction:
 * 		mets.Document: Correction in revert to the last saved document version: force-unlock the document before reverting.
 * 14.01.2014 (Denis):
 * gui.LauncherView: Fixed a small visual bug when renaming a packet.
 * Use current versions of Docutools 1.9.1 and Docudarc 2.11.4.
 * 08.01.2014 (Denis):
 * Use Docutools 1.9.1 with extensions:
 * 		gui.GUIUtil: new Class.
 * 		file.PropertyFile: Added new method get(String key, String ifAbsent, String ifEmpty) with additional option "ifEmpty".
 * gui.LauncherView:
 * 		When initializing folders, don't use "project home" as default, but "user home".
 * 		The default for the temp dir is now the folder "DocuteamPacker" in the java temp dir.
 * 		Create empty SIP dir if it doesn't exists.
 * 06.01.2014 (Denis):
 * translations: Correction in error messages.
 * 19.12.2013 (Denis):
 * gui.LauncherView, gui.SIPView: Correction in initialization of IngestSubmitDirectory and IngestFeedbackDirectory.
 * gui.LauncherView: Refresh views after submit feedback.
 * 13.12.2013 (Denis):
 * resources/translations/Translations*.*: Small corrections.
 * 04.12.2013 (Denis):
 * Use Docudarc 2.11.4 with correction:
 * 		mets.Document: Reset the lock when submit fails.
 * < 04.12.2013 (Denis):
 * Use Docudarc 2.11.2 with extension:
 * 		Redirect jul-logging via slf to log4j.
 * 		SubmitStatus.
 *		mets.Document: New methods: submit() and submitCheck().
 * updated license information on used libraries.
 * Use Docutools 1.9.0 with redesigned FileFilter.
 * Use Docudarc 2.11.2 with extension:
 * 		mets.Document: New method 'checkIngestFeedback(String ingestFeedbackFolderPath, String workspaceFolderPath)'.
 * gui.Launcher: Ingest-Feedback.
 * SIPView: Show submit status, trigger submitCheck and submit.
 * Use Docudarc 2.11.3.
 * gui.LauncherView, gui.SIPView, config_dist/docuteamPacker.properties:
 * 		Submit folder and ingest feedback folder can now be configured in docuteamPacker.properties.
 * 		Refactoring in method 'enableOrDisableActions()'.
 * gui.SIPView: Render the submit status in the tree view.
 * Use Docudarc 2.11.3 with correction:
 * mets.structmap.NodeAbstract: getDynamicMetadataElementInstancesToBeDisplayed():
 * 		Initialize empty dynamic metadata elements if necessary.
 * resources/translations/Translations*.*: Small corrections.
 * Use Docudarc 2.11.3 with correction:
 * mets.structmap.NodeAbstract: getDynamicMetadataElementInstancesToBeDisplayed():
 * 		Initialize empty dynamic metadata elements if necessary.
 * Use Docudarc 2.11.3 with correction:
 * 		ingest.AIPCreator: Interface.
 * 		ingest.AIPCreatorRosetta: Implementation of AIPCreator which replaces util.RosettaConverter:
 * 				Can now create Collections in addition to IEs.
 * 		ingest.AIPCreatorRosetta$DB: preparation.
 * 		ingest.AIPCreatorRosetta: feedback.
 * Use Docudarc 2.11.3 with correction:
 * 		ingest.AIPCreatorRosetta: Removed this and all related classes from this project (and moved to project DocuteamPackerETH).
 * gui.SIPView: Better user messages when submitting.
 * validators.MetadataElementValidatorStupid: Removed class.
 * Use Docudarc 2.11.4. with extension:
 * 		util.KeyAndValue: New class.
 * 		mdconfig.MetadataElement: allowedValues is now a List<KeyAndValue> and not any more a List<String>.
 * gui.SIPView: The DropDown lists contain now of a List<KeyAndValue> and not any more a List<String>.
 * gui.SIPView: Better tooltip text in tree view.
 * gui.SIPView: Take the version string displayed in the bottom right corner from the LauncherView.
 * gui.LauncherView: Improve column widths.
 * config_dist.docuteamPacker.properties: New property "docuteamPacker.AIPCreator.className".
 * gui.SIPView: Initialize AIPCreatorProxy with value from propertyFile.
 *
 * 2.0.1 (Denis/Andreas, 04.10.2013):
 * gui.LauncherView$AboutView: Extended AboutView with informations about OOO installation.
 * dist_src/docuteam packer.sh, dist_src/docuteam packer.app/Contents/MacOS/docuteam packer:
 * 		Added 'export LC_CTYPE="UTF-8"' to the scripts to avoid "?" in java file names with other than ascii characters.
 * Use Docudarc 2.11.2 with correction:
 * 		If the default OO installation is absent and no external OO application path was supplied, assume that the OO Converter shall not be used.
 * gui.FilePreviewer: Handle the case that the OO Converter is not available.
 * corrected French translations (Julien)
 * Use Docudarc 2.11.2 with correction:
 * 		util.FileConverter: Fast initialization:
 * 		When initializing the OOConverter in a separate thread AND the service is being requested, wait for the initialization to finish.
 * Use Docutools 1.8.4 with extension:
 * 		file.PropertyFile: Resolve environment variables in propertyFile values.
 * gui.LauncherView: Cleanup initialization() method and accelerate startup by using util.FileConverter's fast initialization.
 * Rebranding: Docupack -> docuteam packer.
 * Created Tag: Version 2.0.1
 *
 * 2.0.0 (Denis, 29.08.2013):
 * gui.LauncherView: New main window in Docupack.
 * translations/*: Translations of new functionality.
 * admin.Version, gui.LauncherView, gui.LauncherView$AboutView, gui.SIPView, gui.MainView, gui.MainView$AboutView, resources/gui/images/*:
 * 		Change product name from "Docupack" to "docuteam packer", use new Logo.
 * Use Docudarc 2.11.2 with correction:
 * 		Throw an Exception when saving the SIP while a file or folder inside the SIP is in use, e.g. by another application or the Win7 file explorer.
 * gui.LauncherView: Changed the access modifier of some methods so they can be used by subclasses.
 * gui.SIPView$TableTransferHandler: Drag&Drop.
 * gui.LauncherView: Initialize SIPView with property file.
 * Use Docudarc 2.11.2 with correction:
 * 		Access to Levels is not via static methods any more, but via instances of LevelOfDescriptionSet.
 * 		Added instance variable "protected LevelOfDescriptionSet levels" to DocumentAbstract. Each document has now its own LevelOfDescriptionSet.
 * gui.LauncherView, gui.SIPView: Launcher redesign.
 * gui.LauncherView: New action "rereadWorkspaceFolder".
 * resources/images/Open.png, OpenReadOnly.png: New icons for opening SIPs.
 * Use Docudarc 2.11.2 with extension: Search within the SIP.
 * gui.SIPView: Search within the SIP.
 * Use Docutools 1.8.4 with new class string.Pattern.
 * gui.LauncherView: Workspace search.
 * gui.LauncherView: Make workspace search available only in development mode for now.
 * Use Docudarc 2.11.2 with corrections:
 * 		mets.Document: Corrected inconsistency when setting KeepBackupsCount: When now trying to set to null, ignore it and leave as is.
 * 		mets.Document: Allow to open a folder. Assume there is a mets.xml file within and open this.
 * build.xml, dist_src: Move build from "Docupack" to "docuteam packer".
 * resources/images/*, gui.*View, dist_src/*: Renamed images Docupack.* to DocuteamPacker.*.
 * gui.SearchView: Fixed a bug where under Windows, the SearchView loses the focus after the search.
 * gui.SIPView: Show a message when the original SIP is missing while saving with backup.
 * gui.LauncherView: Small corrections when shutting down.
 * gui.SearchView: When searching, skip folders that don't contain a mets.xml file.
 * gui.LaunchView, gui.SearchView, gui.SIPView: Small visual corrections.
 * Created Tag: Version 2.0.0
 *
 * 1.6.3 (Denis, 27.07.2013):
 * Tagged Version with new OS X Application package structure but without LauncherView.
 *
 * 1.6.2 (Andreas, 06.02.2013):
 * Use Docudarc 2.11.1 which allows any premis event types and outcomes.
 * gui.MainView: generally display premis.outcome for events in table.
 *       (Denis, 02.07.2013):
 * Small visual corrections.
 * Use Docudarc 2.11.1 with MetadataElementValidatorShort and additional dynamic metadata elements.
 * config_dist/levels.xml: Standard levels.xml.
 * resources/translations/Translations*.properties: Translation corrections.
 * gui.MainView: Simplified the popup menu: made it shorter and without submenu.
 * Use Docudarc 2.11.1 with the possibility to set the number of retries when initializing the OOConverter.
 * gui.MainView: Correction in the GUI when creating an empty folder.
 * Use Docutools 1.8.2 with correction in class FileUtil.
 * gui.MainView$MyTreeCellRenderer: Handle case that a node's level is null.
 * config_dist/levels.xml: Contains now all levels from Docustore and the ISAD(G) set of metadata for each level.
 * config_dist/levels_standard_*.xml: Translated standard levels.xml.
 * config_dist/levels.xml, config_dist/levels_standard_*.xml: Add kB, MB, and GB to dropdownlist metadata->material.
 * build.xml: Refactoring: create OS X Application package.
 * Use Docudarc 2.11.1 with bug fix when creating a copy of a C or ArchDesc element.
 * gui.MainView: Fixed a bug when dragging a String into the tree.
 * Use Docudarc 2.11.1 with possibility to convert a BAR-SIP to a Matterhorn-SIP.
 * gui.FilePreviewer: Fixed a bug where an exception was thrown when a file without mimetype was rendered.
 * Use Docudarc 2.11.1 with corrections:
 * 		structmap.NodeFolder: Bug fix: When creating a new SIP, the root folder's access rights are now set correctly.
 * 		config_dist/levels*.xml: Set the level "Undefined" as the first default-sublevel for the level "Undefined".
 * gui.MainView:
 * 		When encountering an exceptionCollectorExceptions while creating a new SIP, continue, don't stop, but show a warning.
 * 		Refactoring and unification in exception handling.
 * gui.MainView: From the "New SIP" dialog, the user can now create an empty SIP.
 * Use Docudarc 2.11.1 with corrections: Adapted to Java 7.
 * Use Docudarc 2.11.1 with correction in SystemOutRedirector: When redirecting SYSOUT, the log4j logs are now redirected, too.
 * gui.MainView: initialize(CommandLine): Don't use Logger before it is correctly initialized.
 * gui.SearchView: Facade of a possible search view.
 * gui.LauncherView: Facade of a possible launcher view.
 * Use Docudarc 2.11.1 with corrections:
 * 		Use Docutools 1.8.4 with correction when opening a file externally in Windows.
 * 		Use Docutools 1.8.4 with extended SmallPeskyMessageWindow and SmallPeskyProgressBarWindow which can now block the underlying parent window.
 * While saving/reading/inserting, block the main window using the new SmallPeskyMessageWindow.
 * gui.MainView, config_dist/docupack.properties: Different file paths for Windows and OSX.
 * gui.MainView: When exporting files or folders, don't delete possibly existing files in the destination folder (= merge).
 * config_dist/docupack.properties: Set the max. number of backups; exeeding backups will be deleted.
 * gui.MainView, gui.FilePreviewer: Small visual improvements in tab "Metadata" and "Preview".
 * Use Docutools 1.8.4 with correction:
 * 		gui.JTableWithSpecificCellEditorPerRow: Added method "commitOrCancelCurrentCellEditor()" to commit (or cancel if commit fails) the current cell editor.
 * build.xml: Don't overwrite config_dist/log4j.xml when getting Docudarc.
 * Use Docudarc 2.11.2 with correction:
 * 		When the file converter fails, throw now an exception instead of just returning an error code.
 *
 * 1.6.1 (Denis, 05.02.2013):
 * Use Docudarc 2.10.1 with Docutools 1.8.0.
 * Use Docudarc 2.10.2 with initialization of dynamic metadata when creating a SIP from a template.
 * All java sources: Change copyright message from "2011-2012" to "2011-2013".
 * Use Docudarc 2.10.2 with lazy initialization of LevelOfDescription, new DROID (Version 6.1), and a bug fix when creating a new SIP.
 * Use Docudarc 2.11.0 with the possibility to open SIPs read-only.
 * Use Docudarc 2.11.0 with possibility to set the document's submission agreement.
 * mets.Document: Test or assign SA to document.
 *
 * 1.6.0 (Denis, 14.12.2012):
 * Use Docudarc 2.9.5 with PID as dynamic metadata.
 * gui.MainView: Remove textField "PID".
 * config_dist/levels.xml: Add "PID" to MetadataElements.
 * gui.MainView: When changing a node's level, initialize dynamic metadata if necessary and possible.
 * gui.MainView$TextFieldTableCellEditor: End editing in dynamic metadata table when editor loses focus. (still under development)
 * gui.MainView$MetadataTableModel: Fixed a memory leak when using a combo box editor in the dynamic metadata table.
 * config_dist/levels.xml: Add "unitTitleAdditional" to MetadataElements.
 * Use Docudarc 2.9.5 with Docutools 1.7.0.
 * gui.MainView, gui.FilePreviewer: Adapted to new exception handling in FileUtil.
 * gui.MainView: Show files and folders with restricted access (not writable, not readable, not present) with a colored background in the tree view.
 * gui.MainView: Restrict operations depending on access restrictions of current node, its predecessors, and its descendants.
 * gui.MainView, config_dist/docupack.properties: Versioning (saving with or without backups) can be switched on and off.
 * gui.MainView: Disable "saveAs" action when document contains unreadable files.
 * Use Docudarc 2.9.5 with Docutools 1.7.1.
 * gui.MainView$TextAreaTableCellEditor: Stop editing when the user hits the alt-tab or alt-enter key. On alt-tab, the next table row gets selected.
 * gui.MainView$MyTreeCellRenderer: Improved tree cell rendering implementation.
 * gui.MainView, gui.MainView$MyTreeCellRenderer: Use org.jdesktop.swingx.decorator.Highlighter to color rows in the treeTable.
 * gui.MainView: Fixed a bug when enabling/disabling Buttons.
 * config_2/*: Added alternative configuration folder.
 * gui.MainView, translations/Translations*.properties: Adjusted and cleaned up translation tables.
 * gui.MainView$TableTransferHandler: Bug fix: importing files and folders using D&D was disabled - it is now re-enabled and respects file access permissions.
 * config_dist/docupack.properties: When setting the folder of the OOO application for converting files, now only the location of the "OpenOffice.org" folder must be provided, not the complete path to the executable file within.
 * gui.MainView: Bug fix: When inserting a new folder, don't restrict to only "safe" characters for the folder name.
 * gui.FilePreviewer: Bring "separate preview" window to the front when clicking on the "Open Separately" button.
 * gui.MainView, translations/Translations*.properties: ToolTipText for dynamic metadata comboBox.
 * gui.MainView: Bug fix: When closing a SIP, opening another SIP, or creating a new one, the previously opened SIP now gets correctly unlocked.
 * Use Docudarc 2.9.5 with improved file and exception handling.
 * gui.MainView: Added shutdown hook for cleaning up even in a forced shutdown situation.
 * Use Docudarc 2.9.5 with improved dynamic metadata handling: Initialize mandatory & repeatable dynamic metadata elements which have no instance, with one empty instance.
 * Use Docudarc 2.9.5 with new level property "boolean isAlwaysDisplayed".
 * gui.MainView: When opening a SIP, now the file selector allows just ZIP files or folders which contain a mets.xml file.
 * Use Docudarc 2.9.5 with dynamic metadata elements that have translated tooltip texts.
 * gui.MainView, gui.MainView$MetadataTableModel, gui.MainView$JTableForDynamicMetadataInstances:
 * 		Display translated metadata tooltip texts in the MetadataTable.
 * gui.MainView$JTableForDynamicMetadataInstances: Renamed to gui.MainView$MetadataTable
 * gui.MainView: Ask if to overwrite existing files or folders when exporting.
 * Use Docudarc 2.9.5 with deletion of all metadata when creating a template from a SIP.
 * gui.MainView$TextAreaTableCellEditor: Use the TAB-Key instead of the Alt-TAB-Key to leave the edit modus and commit the editor changes.
 * Use Docudarc 2.9.5 with new level property "boolean keepInTemplate"
 * 		and with deletion of all metadata except those marked with "keepInTemplate='true'" when creating a template from a SIP.
 * gui.FilePreviewer$FilePreviewPanel: Bug fix: Under windows sometimes a temporary file for rendering documents could not be reused.
 * gui.MainView, translations/Translations*.properties: Optional label for InsertDynamicMetadata ComboBox.
 * gui.FilePreviewer$FilePreviewPanel, gui.FilePreviewer$FilePreviewPanel$FileType:
 * 		Refactoring: to retrieve the file type for previewing, FIRST check the PUID, THEN the MIME type, and FINALLY the file extension.
 * gu.MainView: Subclasses can define own version strings.
 * Use Docudarc 2.9.5 with: When creating a new node, set the unitTitle to the node's label (= file name), if the node is a folder.
 * 			If the node is a file, cut away the label's extension.
 * gui.MainView$MetadataTableModel: Dynamic Metadata table: To open a ComboBox in the metadata table, double-click it now (before: single-click).
 * gui.MainView$MetadataTableModel: Dynamic Metadata table: When the first item of a ComboBox list is a "*", this ComboBox is editable.
 * Use Docudarc 2.10.0 with: Initialization of a new subelement's level with the parent level's defaultSubLevel. Before: "Undefined".
 * resources/images: Added new icon "Packet.png" and replaced "MenuFile.png".
 * Use Docudarc 2.10.0 with new methods: isValidSIPFolder(File) and isValidSIPFolder(String).
 * gui.MainView$SIPFileChooser: Improved FileOpenDialog by showing SIPs with a different icon and making SIP folders not traversable (= can not enter).
 * gui.FilePreviewer, gui.FilePreviewer$FilePreviewPanel: Cleanup temp-folder on startup, because under Windows, cleaning-up on shutdown doesn't work.
 * gui.MainView, config_dist/docupack.properties, translations/*: Move all "Template" functionality from project DocupackETH to here.
 *
 * 1.5.5 (Denis, 08.10.2012):
 * gui.MainView: Refactoring: Modify the static methods so that a subclass of MainView can be instanciated.
 * gui.MainView: The fileMenu is now a protected MainView instance variable so it can be accessed (and modified) by subclasses.
 * gui.MainView: Integrating document locking into GUI.
 * gui.MainView: Show message when opening SIPs if nodes exist with empty mandatory values.
 * gui.MainView: In Development Mode, add to menu "File" new menu entry: "SystemOut Document".
 * config_dist/levels.xml, config_dist/levels.xsd: Add "AllowedValuesSeparator" to "levels.xml".
 * gui.MainView: JTextArea as TableCellEditor.
 * Use Docudarc with Docutools 1.6.5.
 * gui.MainView$JTableWithSpecificCellEditorPerRow: Remove class, use the same class from Docutools 1.6.5 instead.
 * gui.MainView$MetadataTableModel: Implements now interface "TableModelWithSpecificCellEditorPerRow" from Docutools 1.6.5.
 * gui.MainView: All tables have now a light-gray grid.
 * gui.MainView: Fixed memory leak when displaying dynamic metadata list.
 * gui.MainView, gui.FilePreviewer: Preview in separate window.
 * gui.MainView$TableTransferHandler: Allow moving multiple files and folders with D&D.
 * gui.MainView, config_dist/docupack.properties: It is now possible to set a backup folder where all backups are made into.
 * gui.MainView, gui.FilePreviewer: Opening a file externally opens a copy of this file in the temp folder.
 * gui.MainView, gui.FilePreviewer: Don't allow to open a folder externally.
 * gui.MainView: Export (for now, only one single file or folder).
 * mets.Document: Correction in the template handling: Unlock the template and cleanup after creating a template.
 *
 * 1.5.4 (Denis, 17.09.2012):
 * Use Docudarc 2.9.3. Integrate all remaining dynamic metadata fields.
 *
 * 1.5.3 (Denis, 22.08.2012):
 * gui.MainView: When changing an item's file name, use FileUtil.isFileNameAllowed() instead of FileUtil.asSafeFileName(). This allows more special characters.
 * gui.MainView$AboutView: Small visual correction.
 *
 * 1.5.2 (Denis, 09.08.2012):
 * config_dist/levels.xml: Define the Docuteam standard levels.
 * gui.MainView: Refactoring to make method overriding easier.
 * *.*: Moved everything related to ETH to the project DocupackETH.
 * gui.MainView: Added new button "Close". Refactoring.
 *
 * 1.5.1 (Denis, 06.08.2012):
 * Use ICEpdf library for PDF preview.
 * gui.MainView: Add menu entry "Docupack/Help" that opens the Docuwiki:Docupack webpage in the browser.
 * gui.MainView: Use class OSXAdapter to handle Mac OS X "cmd-q" and "About" menu entry.
 * gui.MainView: Veto on "close window" action is now possible.
 * Initialization of mandatory dynamic metadata elements happens now only when a new file or folder gets inserted into the tree.
 * MetadataElements are listed in the order in which they appear in the level.xml file.
 * gui.MainView$CreateNewMetsDialog: Added new text field for SIP name.
 * gui.MainView$CreateNewMetsDialog: Before creating a new SIP, check if the destination folder lies within the source folder.
 * gui.MainView$CreateNewMetsDialog: Before creating a new SIP, check if the destination folder is not empty and - if yes - aks if to delete it.
 * Detach a node's label (= fileName) from its unitTitle. Initialize the unitTitle with the fileName omitting the file extension.
 * gui.MainView: The AcquisitionNr can now be entered for every node in the Metadata tab.
 * gui.MainView$FileDataViewTableModel: Removed rows "PID" and "AcquisitionNr" from Info tab (both are now in the Metadata tab).
 * Use Docutools 1.5.5. This version includes the possibility to suppress the automatic popping-up of the SystemOutView when output occurs.
 * gui.MainView: Switch on or off the automatic popping-up of the SystemOutView using the property file ("docupack.openSystemOutViewOnOutput").
 * gui.MainView$FileStructureTreeTableModel: Display in the tree a column showing if some mandatory dynamic metadata elements of this node are empty.
 * gui.MainView: Different default startup screen size (1000 x 600) and position (centered). Before: (1000 x 800) and (100 x 100).
 * gui.MainView: Initialize OOConverter in a background thread in some circumstances.
 * gui.MainView: Use and display only canonical or absolute file names, no relative file names.
 * gui.MainView: Delete multiple items.
 * gui.MainView: AccessNr is now a dynamic metadata field.
 * gui.MainView: Added new menu entry: "Refresh node". Added new main menu entry: "Window".
 * licences.*: Added required software licenses to the project.
 * gui.MainView: Added context menu to tree.
 * gui.MainView, gui.FilePreviewer: Simplify the handling of mouse clicks in the tree view.
 * gui.MainView: Use deleteOnExit() instead of delete() for cleaning-up.
 * gui.MainView: Improved error message when SA can't be opened externally.
 * lib: Added library 'jai_imageio-1.1.jar' to be able to render the french version of 'documentation_docuteam.pdf'.
 * Use Docutools 1.6.0.
 *
 * 1.5.0 (Denis, 28.06.2012):
 * Improve handling of default directories when opening, saving, and creating SIPS, and when inserting files or folders.
 * 		NOTE: config/docupack.properties has changed!
 * All Dialogs can now be closed with the ESC key.
 * Cleanup. Make as many internal classes as possible static.
 * Use lib.commons-cli-1.2 to parse command line arguments.
 * gui.MainView: Extend usage of command line parameters: can specify now -open, -configDir, and -help.
 * Use Docutools 1.5.0.
 * Use Docudarc 2.8.0.
 * In the tree, the items can now be expanded and collapsed using the cursor keys.
 * gui.MainView: Reorganized method readPropertyFileAndInitialize() so that the JODConverter message "INFO: connected" doesn't appear in the SystemOutViewer.
 * Use Docudarc 2.9.0.
 * gui.MainView: Switched to LevelOfDescription configuration using levels.xml (before: Levels.csv).
 * gui.MainView: Level logic.
 * gui.MainView: Use the document's property "isModified" to display the "isModified" message.
 * Use Docudarc 2.9.0d.
 * gui.MainView: New Dynamic Metadata tab. (still under construction)
 * resources.translations.Translations_fr.properties: Improved french translation
 * gui.MainView: When changing an element's level of description, set/unset some of the dynamic metadata.
 * gui.MainView: Can now create a new SIP as a folder, not only as a ZIP file.
 * gui.MainView: Getting the current SAs from the server on startup can now be swiched on and off using a property in the property file.
 * scripts.Docupack.bat: Added a batch file to run Docupack under Windows with additional parameters.
 * gui.MainView: When creating a new SIP, show a message and don't create SIP if the destination folder already exists and is not empty.
 *
 * 1.4.10 (Denis, 03.05.2012):
 * Use Docudarc 2.7.5.
 * Use ScrollableMessageDialog when showing Message that SIP can not be created.
 * SplashScreen is not any more at the top of ALL windows.
 * When inserting files and folders, display filename currently being inserted.
 * Show progress while reading a SIP.
 * When inserting new folders or renaming files or folders, bad characters in entered filename are now handled correctly.
 * Restructured the menu and added menu icons.
 * Refactoring: The translation tables are now not java classes but property files.
 * When SA server can't be reached, show translated error message.
 *
 * 1.4.9 (Denis, 13.04.2012):
 * Use Docudarc 2.7.4.
 * The folder for temporary files can now be configured using the property "docupack.tempFolder" in the property file "docupack.properties".
 * Bug Fix in Docutools.util.FileUtil.
 *
 * 1.4.8 (Denis, 29.03.2012):
 * Bug fix: After changing the AcquisitionNo, the view was not refreshed when using windows.
 * All sources: Changed the copyright message from 2011 to 2011-2012.
 * Use Docudarc 2.7.3.
 * Cleanup SubmissionAgreements on startup (after confirmation).
 * gui.MainView: Improved handling of level icons.
 *
 * 1.4.7 (Denis, 20.02.2012):
 * Use Docudarc 2.7.1.
 * The default folders for insert and save are now "user.home" (before: ".") as long as nothing else is specified in the property file.
 *
 * 1.4.6 (Denis, 08.02.2012):
 * Allow multiple selections in the tree and be able to assign a levelOfDescription to all selected items.
 * Assign levelOfDescriptions to the selected node's sub*-levels.
 * Cleanup in the "tableItemWasSelected" method.
 * Assign levelsOfDescription to the selected node's sub*-levels according to the label name (if file -> "Item", if numeric prefix -> "Series", else "Dossier").
 * ExpandAll and CollapseAll.
 * Display files and folders in the tree view with different fonts and colors.
 * Disable DnD when multiple items are selected.
 * Fixed: Menu entry "Save As" did the same as menu entry "Save".
 * Use Docudarc 2.7.0.
 *
 * 1.4.5 (Denis, 21.12.2011):
 * Introduced new Menu "Docupack" containing "About Screen", "Quit Action", and "Open Error Console".
 * Remove "About Screen" and "Open Error Console" from alt-klick on Docupack Logo and Version number.
 * Use Docudarc 2.6.4 (corrected version).
 * Use image 'Docupack.png' as the windows icon for all windows when using Docupack under MS Windows.
 *
 * 1.4.4 (Denis, 15.12.2011):
 * Use Docudarc 2.6.4.
 * User can now export to EAD including levelsOfDescription and acquisitionNo.
 * User can now export to EAD including PID.
 * GUI optimization and bug fixes.
 * Fixed a bug in build.xml: after building, 'run' was not possible any more without a previous 'clean'.
 *
 * 1.4.3 (Denis, 08.12.2011):
 * Use Docudarc 2.6.3.
 * User can now change the acquisitionNo.
 *
 * 1.4.2 (Denis, 06.12.2011):
 * Use Docudarc 2.6.2.
 * Show different icons in the tree view, depending on the node level.
 * Assign description levels to nodes - individually or per tree level.
 *
 * 1.4.1 (Denis, 16.11.2011):
 * Use Docudarc 2.5.0.
 * Get the SAs from the SA directory and not from overview.xml.
 * build.xml: Rename project from DocuPack to Docupack.
 *
 * 1.4.0 (Denis, 09.11.2011):
 * Improved button mnemonics: Use ctrl-modifier instead of alt-modifier.
 * Added default SA folder "agreements" in project root folder, containing an SA that allows all file types.
 * Use DocuDarc 2.4.1.
 * Save-as for documents.
 * Added about-screen.
 * Enabled drag&drop for files and folders.
 * log4j.xml: Add encoding parameter.
 * Terminated Beta-state :-)
 *
 * 1.4.0b10 (Andreas, 03.11.2011):
 * Use DocuDarc 2.3.3.
 *
 * 1.4.0b9 (Denis, 28.10.2011):
 * Use DocuDarc 2.3.0.
 * Insert copyright message into all sources.
 * Remember directory when selecting files to insert, or mets-file to load.
 * Can now insert multiple files at once.
 * Save-as button.
 * Delete-button asks if to delete; when pressing shift, not.
 * PDF-Preview: Can now enter page number to preview.
 * Button mnemonics: Alt-s for save, Alt-o for open, Alt-n for new document, Alt-q for quit, Alt-del for delete item, etc.
 *
 * 1.4.0b8 (Andreas, 27.10.2011):
 * Use DROID_SignatureFile_V52.xml
 *
 * 1.4.0b7 (Denis, 26.09.2011):
 * The LookAndFeel can now be configured in the property file docupack.properties (property docupack.useSystemLookAndFeel).
 *
 * 1.4.0b6 (Denis, 29.07.2011):
 * Use DocuDarc 2.2.7 (which contains the OOO Apps).
 * Renamed folder config_gen to config_dist and adapted build.xml accordingly.
 * Corrected build.xml (use 'exec unzip' to extract the OS X OOO package because the ant task 'unzip' doesn't preserve the file permission 'executable').
 * Corrected build.xml (use 'exec zip' to create zips because the ant task 'zip' doesn't preserve the file permission 'executable').
 *
 * 1.4.0b5 (Denis, 26.07.2011):
 * Use DocuDarc 2.2.6 (using DocuTools 1.3.5 (bug fix in class JTableWithDynamicToolTipTexts)).
 * Can now change language during runtime (except for the toolTipTexts and the treeView headers).
 *
 * 1.4.0b4 (Denis, 24.06.2011):
 * Use DocuDarc 2.1.26.
 * Improved gui.FilePreviewer's initialization and cache.
 *
 * 1.4.0b3 (Denis, 22.06.2011):
 * Use DocuDarc 2.1.25.
 * Data tables now have toolTipTexts showing the cell content.
 * Created class gui.FilePreviewer, taking the file preview functionality out of the class MainView.
 *
 * 1.4.0b2 (Denis, 06.06.2011):
 * File Preview (not yet finished):
 * 			Can preview all text-files, HTML, GIF, PNG, and JPEG
 * 			Can now preview PDFs (using pdf-renderer 1.0.5)
 * 			Can now preview RTFs and MS Office documents (using OOo API converter)
 * 			Can now preview other graphic formats like BMP and TIFF (using JAI - Java Advanced Imaging)
 * 			Can now preview more graphic formats like PSD (using JIMI)
 * 			Can now resize the preview
 * 			Can now preview more graphic formats like EPS (using ImageMagick)
 * 	Use DocuDarc 2.1.22.
 *
 * 1.3.9 (Denis, 18.05.2011):
 * Relative file sizes are displayed as bars of different width.
 *
 * 1.3.8 (Denis, 18.05.2011):
 * Internationalization D and F.
 * All buttons now have icons in addition to labels.
 *
 * 1.3.7 (Denis, 18.04.2011):
 * Use DocuDarc 2.1.17.
 *
 * 1.3.6 (Denis, 18.04.2011):
 * Using DocuDarc 2.1.16.
 * Added button [Show SA Externally]
 *
 * 1.3.5 (Andreas, 05.04.2011):
 * Use DocuDarc 2.1.10.
 *
 * 1.3.4 (Denis, 24.03.2011):
 * Show small info window when inserting files or folders.
 * When creating a new SIP, create a ZIP archive instead of a folder.
 * Use DocuDarc 2.1.5.
 *
 * 1.3.3 (Denis, 17.03.2011):
 * Open the SystemOutView when alt-clicking the logo button.
 *
 * 1.3.2 (Denis, 10.03.2011):
 * Output in case of errors and warnings improved (not yet finished).
 * Use DocuDarc 2.1.1.
 */
public abstract class Version
{
	static public final String Product = "docuteam packer";
	static public final String Number = "2.4.8";
	static public final String LastChange = "24.11.2016";

	/**
	 * This main method is being used by the ant build script to be able to add a version number to the compiled jar file.
	 *
	 * @param args: No parameters are expected.
	 */
	public static void main(String[] args)
	{
		if (Arrays.asList(args).contains("-v")) {
			System.out.println(Product + ": " + Number + " (" + LastChange + ")");

			System.out.println("\n===== Environment =====");
			Iterator<Entry<String, String>> iter = System.getenv().entrySet().iterator();
			while (iter.hasNext()) {
				Entry<String, String> entry = iter.next();
				System.out.println(entry.getKey() + " = " + entry.getValue());
			}

			System.out.println("\n===== Properties =====");
			Properties p = System.getProperties();
			Enumeration<Object> keys = p.keys();
			while (keys.hasMoreElements()) {
				String key = (String) keys.nextElement();
				System.out.println(key + ": " + p.get(key));
			}
		} else {
			System.out.println(Number);
		}
	}

}
