package ch.docuteam.packer.gui.launcher;

import javax.swing.table.DefaultTableCellRenderer;

import static ch.docuteam.packer.gui.PackerConstants.DATE_FORMAT;
import ch.docuteam.tools.string.DateFormatter;

public class DateTableCellRenderer extends DefaultTableCellRenderer {

	public DateTableCellRenderer() {
		super();
		this.setHorizontalAlignment(DefaultTableCellRenderer.RIGHT);
	}

	@Override
	public void setValue(Object object) {
		if (object == null){
			return;
		}
		super.setValue(DateFormatter.getDateTimeString((Long) object, DATE_FORMAT));
	}

}
