package ch.docuteam.packer.gui.launcher;

import static ch.docuteam.packer.gui.PackerConstants.*;
import java.io.File;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;

import ch.docuteam.darc.mets.Document;
import ch.docuteam.tools.translations.I18N;

public class SIPFileChooser extends JFileChooser {

	private static final ImageIcon SIPFolderIcon = new ImageIcon("./resources/images/Packet.png");
//	private static SIPFileChooser Singleton = null;

//	public static SIPFileChooser getInstance(LauncherView launcherView) {
//		if(Singleton == null){
//			Singleton = new SIPFileChooser(launcherView);
//		}
//		return Singleton;
//	}

	public SIPFileChooser(String lastUsedOpenOrSaveDir) {
		super(lastUsedOpenOrSaveDir);

		setDialogType(JFileChooser.OPEN_DIALOG);
		setMultiSelectionEnabled(false);
		setDialogTitle(I18N.translate("TitleOpenSIP"));
		setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		setFileFilter(new javax.swing.filechooser.FileFilter() {
			@Override
			public boolean accept(File file) {
				// No hidden files or folders:
				if (file.isHidden() || file.getName().startsWith(".")) {
					return false;
				}
				if (file.isFile()) {
					// Only zip files:
					if (file.getName().toLowerCase().endsWith(ZIP_EXT)) {
						return true;
					}
				} else {
					// Only folders that contain a mets.xml // ToDo: (this
					// doesn't work: then all folders are invisible!):
					// if (Document.isValidSIPFolder(file)) return true;
					return true;
				}

				return false;
			}

			@Override
			public String getDescription() {
				return "SIP Folder or ZIP-File";
			}
		});

		setFileView(new FileView() {
			/**
			 * Whether the directory is traversable or not. This might be
			 * useful, for example, if you want a directory to represent a
			 * compound document and don't want the user to descend into it.
			 */
			@Override
			public Boolean isTraversable(File folder) {
				if (folder == null || !folder.exists() || !folder.canRead())
					return false;
				if (folder.isFile())
					return false;

				return (!Document.isValidSIPFolder(folder));
			}

			/**
			 * The icon that represents this file in the
			 * <code>JFileChooser</code>.
			 */
			@Override
			public Icon getIcon(File file) {
				if (file.isFile()) {
					if (file.getName().toLowerCase().endsWith(ZIP_EXT))
						return SIPFolderIcon;
				} else {
					if (Document.isValidSIPFolder(file))
						return SIPFolderIcon;
				}

				return null;
			}
		});
	}

}
